/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class SizeGrip
extends Canvas {
    private static final int WIDTH = 13;
    private static final int HEIGHT = 13;
    private static final long UPDATE_DELAY = 25L;
    private int mouseDownOffsetX;
    private int mouseDownOffsetY;
    private int snapBackX;
    private int snapBackY;
    private boolean cancelled;
    private Cursor sizeCursor;
    private Point minSize;
    private boolean userVisible;
    private volatile long lastUpdate;
    private Timer timer;
    private TimerTask timerTask;
    private Composite resizableParent;

    public SizeGrip(Composite composite, int n) {
        this(composite, (Composite)composite.getShell(), n);
    }

    public SizeGrip(Composite composite, final Composite composite2, int n) {
        Listener listener;
        n = SizeGrip.checkStyle(n);
        super(composite, n);
        this.userVisible = true;
        this.timer = new Timer(true);
        this.resizableParent = composite2;
        this.setSize(13, 13);
        this.sizeCursor = new Cursor((Device)this.getDisplay(), 8);
        this.setCursor(this.sizeCursor);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (SizeGrip.this.sizeCursor != null) {
                    SizeGrip.this.sizeCursor.dispose();
                    SizeGrip.this.sizeCursor = null;
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = SizeGrip.this.getClientArea();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                Display display = SizeGrip.this.getDisplay();
                Color color = display.getSystemColor(18);
                Color color2 = display.getSystemColor(20);
                event.gc.setLineWidth(1);
                if ((SizeGrip.this.getStyle() & 0x800000) != 0) {
                    event.gc.setBackground(color2);
                    event.gc.fillRectangle(rectangle.width - 3, rectangle.height - 3, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 7, rectangle.height - 3, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 11, rectangle.height - 3, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 3, rectangle.height - 7, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 7, rectangle.height - 7, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 3, rectangle.height - 11, 2, 2);
                    event.gc.setBackground(color);
                    event.gc.fillRectangle(rectangle.width - 4, rectangle.height - 4, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 8, rectangle.height - 4, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 12, rectangle.height - 4, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 4, rectangle.height - 8, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 8, rectangle.height - 8, 2, 2);
                    event.gc.fillRectangle(rectangle.width - 4, rectangle.height - 12, 2, 2);
                    event.gc.setForeground(color2);
                } else {
                    event.gc.setForeground(color);
                    event.gc.drawLine(rectangle.width - 3, rectangle.height - 2, rectangle.width - 2, rectangle.height - 3);
                    event.gc.drawLine(rectangle.width - 4, rectangle.height - 2, rectangle.width - 2, rectangle.height - 4);
                    event.gc.drawLine(rectangle.width - 7, rectangle.height - 2, rectangle.width - 2, rectangle.height - 7);
                    event.gc.drawLine(rectangle.width - 8, rectangle.height - 2, rectangle.width - 2, rectangle.height - 8);
                    event.gc.drawLine(rectangle.width - 11, rectangle.height - 2, rectangle.width - 2, rectangle.height - 11);
                    event.gc.drawLine(rectangle.width - 12, rectangle.height - 2, rectangle.width - 2, rectangle.height - 12);
                    event.gc.setForeground(color2);
                    event.gc.drawLine(rectangle.width - 5, rectangle.height - 2, rectangle.width - 2, rectangle.height - 5);
                    event.gc.drawLine(rectangle.width - 9, rectangle.height - 2, rectangle.width - 2, rectangle.height - 9);
                    event.gc.drawLine(rectangle.width - 13, rectangle.height - 2, rectangle.width - 2, rectangle.height - 13);
                }
                if ((SizeGrip.this.getStyle() & 4) != 0) {
                    if (event.width > 13) {
                        event.gc.drawLine(0, rectangle.height - 1, rectangle.width - 14, rectangle.height - 1);
                    }
                    if (event.height > 13) {
                        event.gc.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 14);
                    }
                }
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    SizeGrip.this.mouseDownOffsetX = event.x;
                    SizeGrip.this.mouseDownOffsetY = event.y;
                    Point point = composite2.getSize();
                    SizeGrip.this.snapBackX = point.x;
                    SizeGrip.this.snapBackY = point.y;
                    SizeGrip.this.cancelled = false;
                } else if (event.button == 3 && (event.stateMask & 0x80000) != 0 && SizeGrip.this.snapBackX > 0 && SizeGrip.this.snapBackY > 0) {
                    composite2.setSize(SizeGrip.this.snapBackX, SizeGrip.this.snapBackY);
                    SizeGrip.this.snapBackX = 0;
                    SizeGrip.this.snapBackY = 0;
                    SizeGrip.this.cancelled = true;
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(final Event event) {
                if (!SizeGrip.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    if (SizeGrip.this.timerTask != null) {
                        SizeGrip.this.timerTask.cancel();
                        SizeGrip.this.timerTask = null;
                    }
                    long l = System.currentTimeMillis();
                    if (SizeGrip.this.lastUpdate + 25L < l) {
                        SizeGrip.this.performResize(event);
                        SizeGrip.this.lastUpdate = l;
                    } else {
                        SizeGrip.this.timerTask = new TimerTask(){

                            public void run() {
                                final 1 var1_1 = this;
                                event.display.asyncExec(new Runnable(){

                                    public void run() {
                                        if (var1_1 != SizeGrip.this.timerTask) {
                                            return;
                                        }
                                        SizeGrip.this.performResize(event);
                                    }
                                });
                            }
                        };
                        SizeGrip.this.timer.schedule(SizeGrip.this.timerTask, 25L);
                    }
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (SizeGrip.this.timerTask != null) {
                    SizeGrip.this.timerTask.cancel();
                    SizeGrip.this.timerTask = null;
                }
                if (!SizeGrip.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    SizeGrip.this.performResize(event);
                }
            }
        });
        Listener listener2 = listener = composite2 instanceof Shell ? new Listener(){

            public void handleEvent(Event event) {
                SizeGrip.this.updateVisibility();
            }
        } : null;
        if (listener != null) {
            composite2.addListener(11, listener);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SizeGrip.this.timer.cancel();
                if (listener != null) {
                    composite2.removeListener(11, listener);
                }
            }
        });
        this.updateVisibility();
    }

    private void performResize(Event event) {
        Rectangle rectangle = this.resizableParent instanceof Shell ? this.getDisplay().getClientArea() : this.getDisplay().map((Control)this.resizableParent.getParent(), null, this.resizableParent.getParent().getClientArea());
        Point point = this.toControl(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        event.x = Math.min(event.x, point.x);
        event.y = Math.min(event.y, point.y);
        Point point2 = this.resizableParent.getSize();
        int n = point2.x + event.x - this.mouseDownOffsetX;
        int n2 = point2.y + event.y - this.mouseDownOffsetY;
        if (this.minSize != null) {
            n = Math.max(this.minSize.x, n);
            n2 = Math.max(this.minSize.y, n2);
        }
        if (n != point2.x || n2 != point2.y) {
            this.resizableParent.setSize(n, n2);
        }
    }

    private void updateVisibility() {
        if (this.resizableParent instanceof Shell) {
            boolean bl;
            boolean bl2 = super.getVisible();
            boolean bl3 = ((Shell)this.resizableParent).getMaximized();
            boolean bl4 = bl = this.userVisible && !bl3;
            if (bl2 != bl) {
                super.setVisible(bl);
            }
        } else if (this.userVisible != super.getVisible()) {
            super.setVisible(this.userVisible);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n == -1) {
            n = 13;
        }
        if (n2 == -1) {
            n2 = 13;
        }
        return new Point(n, n2);
    }

    private static int checkStyle(int n) {
        int n2 = 0x800004;
        return n &= n2;
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    public void setMinimumShellSize(Point point) {
        this.checkWidget();
        this.minSize = point;
    }

    public void setMinimumShellSize(int n, int n2) {
        this.checkWidget();
        this.minSize = new Point(n, n2);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.userVisible;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        this.userVisible = bl;
        this.updateVisibility();
    }
}

