/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SizeBorder
extends Canvas {
    private static final long UPDATE_DELAY = 25L;
    private static final int AREA_NONE = 0;
    private static final int AREA_N = 1;
    private static final int AREA_S = 2;
    private static final int AREA_E = 4;
    private static final int AREA_W = 8;
    private static final int AREA_NW = 9;
    private static final int AREA_NE = 5;
    private static final int AREA_SE = 6;
    private static final int AREA_SW = 10;
    private Rectangle snapBack;
    private boolean cancelled = true;
    private volatile long lastUpdate;
    private Timer timer = new Timer(true);
    private TimerTask timerTask;
    private Composite resizableParent;
    private Point minSize;
    private Point mouseDownOffset;
    private int borderWidth = 4;
    private int cornerSize = 16;
    private Display display;
    private Cursor cursor;
    private Cursor cursorNWSE;
    private Cursor cursorNESW;
    private Cursor cursorWE;
    private Cursor cursorNS;
    private int currentArea;

    public SizeBorder(Composite composite, int n) {
        this(composite, (Composite)composite.getShell(), n);
    }

    public SizeBorder(Composite composite, final Composite composite2, int n) {
        super(composite, SizeBorder.checkStyle(n));
        this.resizableParent = composite2;
        this.display = this.getDisplay();
        this.cursorNWSE = new Cursor((Device)this.getDisplay(), 8);
        this.cursorNESW = new Cursor((Device)this.getDisplay(), 6);
        this.cursorWE = new Cursor((Device)this.getDisplay(), 9);
        this.cursorNS = new Cursor((Device)this.getDisplay(), 7);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SizeBorder.this.cursorNWSE.dispose();
                SizeBorder.this.cursorNESW.dispose();
                SizeBorder.this.cursorWE.dispose();
                SizeBorder.this.cursorNS.dispose();
            }
        });
        if ((n & 0x800) != 0) {
            final Color color = this.display.getSystemColor(20);
            final Color color2 = this.display.getSystemColor(19);
            final Color color3 = this.display.getSystemColor(18);
            final Color color4 = this.display.getSystemColor(17);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle rectangle = SizeBorder.this.getClientArea();
                    if (rectangle.width == 0 || rectangle.height == 0) {
                        return;
                    }
                    SizeBorder.drawBevelRect(event.gc, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color2, color4);
                    SizeBorder.drawBevelRect(event.gc, rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3, color, color3);
                }
            });
        }
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    SizeBorder.this.currentArea = SizeBorder.this.areaAtPoint(event.x, event.y);
                    if (SizeBorder.this.currentArea == 0) {
                        return;
                    }
                    if (composite2 instanceof Shell) {
                        SizeBorder.this.mouseDownOffset = SizeBorder.this.toDisplay(event.x, event.y);
                    } else {
                        SizeBorder.this.mouseDownOffset = SizeBorder.this.display.map((Control)SizeBorder.this, (Control)composite2.getParent(), event.x, event.y);
                    }
                    SizeBorder.this.snapBack = composite2.getBounds();
                    SizeBorder.this.cancelled = false;
                } else if (event.button == 3 && (event.stateMask & 0x80000) != 0 && SizeBorder.this.snapBack != null) {
                    composite2.setBounds(SizeBorder.this.snapBack);
                    SizeBorder.this.snapBack = null;
                    SizeBorder.this.cancelled = true;
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(final Event event) {
                if ((event.stateMask & 0x80000) == 0) {
                    SizeBorder.this.updateCursor(SizeBorder.this.areaAtPoint(event.x, event.y));
                }
                if (!SizeBorder.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    if (SizeBorder.this.timerTask != null) {
                        SizeBorder.this.timerTask.cancel();
                        SizeBorder.this.timerTask = null;
                    }
                    long l = System.currentTimeMillis();
                    if (SizeBorder.this.lastUpdate + 25L < l) {
                        SizeBorder.this.performResize(event);
                        SizeBorder.this.lastUpdate = l;
                    } else {
                        SizeBorder.this.timerTask = new TimerTask(){

                            public void run() {
                                final 1 var1_1 = this;
                                event.display.asyncExec(new Runnable(){

                                    public void run() {
                                        if (var1_1 != SizeBorder.this.timerTask) {
                                            return;
                                        }
                                        SizeBorder.this.performResize(event);
                                    }
                                });
                            }
                        };
                        SizeBorder.this.timer.schedule(SizeBorder.this.timerTask, 25L);
                    }
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (SizeBorder.this.timerTask != null) {
                    SizeBorder.this.timerTask.cancel();
                    SizeBorder.this.timerTask = null;
                }
                if (!SizeBorder.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    SizeBorder.this.performResize(event);
                }
            }
        });
        this.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                Point point = SizeBorder.this.toControl(SizeBorder.this.display.getCursorLocation());
                SizeBorder.this.updateCursor(SizeBorder.this.areaAtPoint(point.x, point.y));
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SizeBorder.this.timer.cancel();
            }
        });
    }

    private static int checkStyle(int n) {
        n = 524288;
        return n;
    }

    private void performResize(Event event) {
        int n;
        int n2;
        Rectangle rectangle = this.resizableParent instanceof Shell ? this.getDisplay().getClientArea() : this.getDisplay().map((Control)this.resizableParent.getParent(), null, this.resizableParent.getParent().getClientArea());
        Point point = this.toControl(rectangle.x, rectangle.y);
        event.x = Math.max(Math.min(event.x, point.x + rectangle.width - 1), point.x);
        event.y = Math.max(Math.min(event.y, point.y + rectangle.height - 1), point.y);
        Point point2 = this.resizableParent instanceof Shell ? this.toDisplay(event.x, event.y) : this.display.map((Control)this, (Control)this.resizableParent.getParent(), event.x, event.y);
        point2.x -= this.mouseDownOffset.x;
        point2.y -= this.mouseDownOffset.y;
        int n3 = this.snapBack.width;
        int n4 = this.snapBack.height;
        int n5 = this.snapBack.x;
        int n6 = this.snapBack.y;
        if ((this.currentArea & 4) != 0) {
            n3 += point2.x;
        } else if ((this.currentArea & 8) != 0) {
            n5 += this.snapBack.width - (n3 -= point2.x);
        }
        if ((this.currentArea & 2) != 0) {
            n4 += point2.y;
        } else if ((this.currentArea & 1) != 0) {
            n6 += this.snapBack.height - (n4 -= point2.y);
        }
        if (this.minSize != null) {
            n2 = this.minSize.x;
            n = this.minSize.y;
        } else {
            n2 = 0;
            n = 0;
        }
        int n7 = this.snapBack.x + this.snapBack.width - n2;
        int n8 = this.snapBack.y + this.snapBack.height - n;
        n3 = Math.max(n2, n3);
        n4 = Math.max(n, n4);
        n5 = Math.min(n7, n5);
        n6 = Math.min(n8, n6);
        this.resizableParent.setBounds(n5, n6, n3, n4);
    }

    private void updateCursor(int n) {
        Cursor cursor = null;
        switch (n) {
            case 1: 
            case 2: {
                cursor = this.cursorNS;
                break;
            }
            case 4: 
            case 8: {
                cursor = this.cursorWE;
                break;
            }
            case 6: 
            case 9: {
                cursor = this.cursorNWSE;
                break;
            }
            case 5: 
            case 10: {
                cursor = this.cursorNESW;
            }
        }
        if (this.cursor == cursor) {
            return;
        }
        this.cursor = cursor;
        this.setCursor(cursor);
    }

    private int areaAtPoint(int n, int n2) {
        Point point = this.getSize();
        if (n < this.borderWidth) {
            if (n2 < this.cornerSize) {
                return 9;
            }
            if (n2 >= point.y - this.cornerSize) {
                return 10;
            }
            return 8;
        }
        if (n >= point.x - this.borderWidth) {
            if (n2 >= point.y - this.cornerSize) {
                return 6;
            }
            if (n2 < this.cornerSize) {
                return 5;
            }
            return 4;
        }
        if (n2 < this.borderWidth) {
            if (n < this.cornerSize) {
                return 9;
            }
            if (n >= point.x - this.cornerSize) {
                return 5;
            }
            return 1;
        }
        if (n2 >= point.y - this.borderWidth) {
            if (n >= point.x - this.cornerSize) {
                return 6;
            }
            if (n < this.cornerSize) {
                return 10;
            }
            return 2;
        }
        return 0;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        return new Point(n, n2);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    public void setMinimumShellSize(Point point) {
        this.checkWidget();
        this.minSize = point;
    }

    public void setMinimumShellSize(int n, int n2) {
        this.checkWidget();
        this.minSize = new Point(n, n2);
    }

    public void setBorderWidth(int n) {
        this.checkWidget();
        this.borderWidth = n;
        Point point = this.toControl(this.display.getCursorLocation());
        this.updateCursor(this.areaAtPoint(point.x, point.y));
    }

    public void setCornerSize(int n) {
        this.checkWidget();
        this.cornerSize = n;
        Point point = this.toControl(this.display.getCursorLocation());
        this.updateCursor(this.areaAtPoint(point.x, point.y));
    }

    private static void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setForeground(color2);
        gC.drawLine(n + n3, n2, n + n3, n2 + n4);
        gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
        gC.setForeground(color);
        gC.drawLine(n, n2, n + n3 - 1, n2);
        gC.drawLine(n, n2, n, n2 + n4 - 1);
    }
}

