/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import org.sf.feeling.swt.win32.internal.extension.util.FlagSet;

public class Shortcut
extends FlagSet {
    private static final int MOD_ALT = 1;
    private static final int MOD_CONTROL = 2;
    private static final int MOD_SHIFT = 4;
    private int keyCode;

    public Shortcut(boolean bl, boolean bl2, boolean bl3, int n) {
        this(n);
        this.setControl(bl);
        this.setShift(bl2);
        this.setAlt(bl3);
    }

    public Shortcut(boolean bl, boolean bl2, boolean bl3, String string) {
        this(Shortcut.parseKeyCode(string));
        this.setControl(bl);
        this.setShift(bl2);
        this.setAlt(bl3);
    }

    private static int parseKeyCode(String string) {
        if (string.equalsIgnoreCase("F1")) {
            return 0x100000A;
        }
        if (string.equalsIgnoreCase("F2")) {
            return 0x100000B;
        }
        if (string.equalsIgnoreCase("F3")) {
            return 0x100000C;
        }
        if (string.equalsIgnoreCase("F4")) {
            return 0x100000D;
        }
        if (string.equalsIgnoreCase("F5")) {
            return 0x100000E;
        }
        if (string.equalsIgnoreCase("F6")) {
            return 0x100000F;
        }
        if (string.equalsIgnoreCase("F7")) {
            return 0x1000010;
        }
        if (string.equalsIgnoreCase("F8")) {
            return 0x1000011;
        }
        if (string.equalsIgnoreCase("F9")) {
            return 0x1000012;
        }
        if (string.equalsIgnoreCase("F10")) {
            return 0x1000013;
        }
        if (string.equalsIgnoreCase("F11")) {
            return 0x1000014;
        }
        if (string.equalsIgnoreCase("F12")) {
            return 0x1000015;
        }
        if (string.equalsIgnoreCase("Ins") || string.equalsIgnoreCase("Insert")) {
            return 0x1000009;
        }
        if (string.equalsIgnoreCase("Del") || string.equalsIgnoreCase("Delete")) {
            return 127;
        }
        if (string.equalsIgnoreCase("Backspace") || string.equalsIgnoreCase("BS")) {
            return 8;
        }
        if (string.equalsIgnoreCase("Esc")) {
            return 27;
        }
        if (string.equalsIgnoreCase("Tab")) {
            return 9;
        }
        if (string.equalsIgnoreCase("Enter")) {
            return 13;
        }
        if (string.equalsIgnoreCase("Home")) {
            return 0x1000007;
        }
        if (string.equalsIgnoreCase("End")) {
            return 0x1000008;
        }
        if (string.equalsIgnoreCase("PageUp")) {
            return 0x1000005;
        }
        if (string.equalsIgnoreCase("PageDown")) {
            return 0x1000006;
        }
        if (string.equalsIgnoreCase("Pause")) {
            return 0x1000055;
        }
        if (string.equalsIgnoreCase("ScrollLock")) {
            return 16777300;
        }
        if (string.equalsIgnoreCase("NumLock")) {
            return 16777299;
        }
        if (string.equalsIgnoreCase("CapsLock")) {
            return 16777298;
        }
        if (string.equalsIgnoreCase("Space")) {
            return 32;
        }
        if (string.length() > 0) {
            return string.charAt(0);
        }
        return 0;
    }

    public Shortcut(boolean bl, boolean bl2, boolean bl3, char c) {
        this(c);
        this.setControl(bl);
        this.setShift(bl2);
        this.setAlt(bl3);
    }

    public Shortcut(int n) {
        this.keyCode = n >= 97 && n <= 122 ? n - 32 : n;
    }

    public Shortcut(String string) {
        String[] stringArray = string.split("\\+");
        if (stringArray.length > 0) {
            String string2 = stringArray[stringArray.length - 1];
            this.keyCode = Shortcut.parseKeyCode(string2);
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if ("Ctrl".equalsIgnoreCase(stringArray[i])) {
                    this.setControl(true);
                    continue;
                }
                if ("Shift".equalsIgnoreCase(stringArray[i])) {
                    this.setShift(true);
                    continue;
                }
                if (!"Alt".equalsIgnoreCase(stringArray[i])) continue;
                this.setAlt(true);
            }
        }
    }

    public void setAlt(boolean bl) {
        this.setupFlag(1, bl);
    }

    public boolean isAlt() {
        return this.contains(1);
    }

    public void setControl(boolean bl) {
        this.setupFlag(2, bl);
    }

    public boolean isControl() {
        return this.contains(2);
    }

    public void setShift(boolean bl) {
        this.setupFlag(4, bl);
    }

    public boolean isShift() {
        return this.contains(4);
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int hashCode() {
        return 5 + this.flag * 7 + this.keyCode * 13;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Shortcut)) {
            return false;
        }
        Shortcut shortcut = (Shortcut)object;
        return shortcut.flag == this.flag && shortcut.keyCode == this.keyCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isControl()) {
            stringBuffer.append("Ctrl+");
        }
        if (this.isShift()) {
            stringBuffer.append("Shift+");
        }
        if (this.isAlt()) {
            stringBuffer.append("Alt+");
        }
        switch (this.keyCode) {
            case 0x100000A: {
                stringBuffer.append("F1");
                break;
            }
            case 0x100000B: {
                stringBuffer.append("F2");
                break;
            }
            case 0x100000C: {
                stringBuffer.append("F3");
                break;
            }
            case 0x100000D: {
                stringBuffer.append("F4");
                break;
            }
            case 0x100000E: {
                stringBuffer.append("F5");
                break;
            }
            case 0x100000F: {
                stringBuffer.append("F6");
                break;
            }
            case 0x1000010: {
                stringBuffer.append("F7");
                break;
            }
            case 0x1000011: {
                stringBuffer.append("F8");
                break;
            }
            case 0x1000012: {
                stringBuffer.append("F9");
                break;
            }
            case 0x1000013: {
                stringBuffer.append("F10");
                break;
            }
            case 0x1000014: {
                stringBuffer.append("F11");
                break;
            }
            case 0x1000015: {
                stringBuffer.append("F12");
                break;
            }
            case 0x1000009: {
                stringBuffer.append("Ins");
                break;
            }
            case 127: {
                stringBuffer.append("Del");
                break;
            }
            case 8: {
                stringBuffer.append("Backspace");
                break;
            }
            case 27: {
                stringBuffer.append("Esc");
                break;
            }
            case 9: {
                stringBuffer.append("Tab");
                break;
            }
            case 13: {
                stringBuffer.append("Enter");
                break;
            }
            case 0x1000007: {
                stringBuffer.append("Home");
                break;
            }
            case 0x1000008: {
                stringBuffer.append("End");
                break;
            }
            case 0x1000005: {
                stringBuffer.append("PageUp");
                break;
            }
            case 0x1000006: {
                stringBuffer.append("PageDown");
                break;
            }
            case 0x1000055: {
                stringBuffer.append("Pause");
                break;
            }
            case 16777300: {
                stringBuffer.append("ScrollLock");
                break;
            }
            case 16777299: {
                stringBuffer.append("NumLock");
                break;
            }
            case 16777298: {
                stringBuffer.append("CapsLock");
                break;
            }
            case 32: {
                stringBuffer.append("Space");
                break;
            }
            case 0: {
                if (stringBuffer.length() <= 0) break;
                stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                break;
            }
            default: {
                stringBuffer.append((char)this.keyCode);
            }
        }
        return stringBuffer.toString().trim();
    }
}

