/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public final class Separator
extends Canvas {
    private int lineSize;
    private int style;

    public Separator(Composite composite, int n) {
        n = Separator.checkStyle(n);
        super(composite, n);
        this.style = n;
        this.lineSize = (n & 4) != 0 || (n & 8) != 0 ? 2 : 1;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Separator.this.onPaint(paintEvent);
            }
        });
    }

    private static int checkStyle(int n) {
        int n2 = 812;
        if (((n &= n2) & 0x2C) == 0) {
            n |= 4;
        }
        if ((n & 0x300) == 0) {
            n |= 0x200;
        }
        return n;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n == -1) {
            n = this.lineSize;
        }
        if (n2 == -1) {
            n2 = this.lineSize;
        }
        return new Point(n, n2);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        boolean bl = (this.style & 0x100) != 0;
        int n = bl ? rectangle.y + rectangle.height / 2 : rectangle.x + rectangle.width / 2;
        Display display = this.getDisplay();
        paintEvent.gc.setLineWidth(1);
        if ((this.style & 4) != 0) {
            Color color = display.getSystemColor(18);
            Color color2 = display.getSystemColor(20);
            paintEvent.gc.setForeground(color);
            if (bl) {
                paintEvent.gc.drawLine(rectangle.x, n - 1, rectangle.x + rectangle.width - 1, n - 1);
            } else {
                paintEvent.gc.drawLine(n - 1, rectangle.y, n - 1, rectangle.y + rectangle.height - 1);
            }
            paintEvent.gc.setForeground(color2);
            if (bl) {
                paintEvent.gc.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
            } else {
                paintEvent.gc.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height - 1);
            }
        } else if ((this.style & 8) != 0) {
            Color color = display.getSystemColor(18);
            Color color3 = display.getSystemColor(20);
            paintEvent.gc.setForeground(color3);
            if (bl) {
                paintEvent.gc.drawLine(rectangle.x, n - 1, rectangle.x + rectangle.width - 1, n - 1);
            } else {
                paintEvent.gc.drawLine(n - 1, rectangle.y, n - 1, rectangle.y + rectangle.height - 1);
            }
            paintEvent.gc.setForeground(color);
            if (bl) {
                paintEvent.gc.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
            } else {
                paintEvent.gc.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height - 1);
            }
        } else {
            paintEvent.gc.setForeground(this.getForeground());
            if (bl) {
                paintEvent.gc.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
            } else {
                paintEvent.gc.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height - 1);
            }
        }
    }
}

