/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.MenuControl;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolder;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolderManager;
import org.sf.feeling.swt.win32.extension.widgets.theme.ThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.VS2005ThemeRender;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class PopupMenu
extends MenuControl
implements MenuHolder {
    private Control control;
    private Listener listener;
    private Callback mouseCallback;
    private int newAddress;
    private int oldAddress;

    public PopupMenu(Control control, ThemeRender themeRender) {
        this(control, themeRender, true);
    }

    public PopupMenu(Control control, ThemeRender themeRender, boolean bl) {
        super(null, themeRender);
        this.holder = this;
        this.control = control;
        this.isPopupMenu = true;
        if (bl) {
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    if (MenuHolderManager.getActiveHolder() != null && MenuHolderManager.getActiveHolder() != PopupMenu.this) {
                        return;
                    }
                    PopupMenu.this.open();
                }
            };
            control.addListener(35, this.listener);
        }
        MenuHolderManager.registerHolder(this);
    }

    public PopupMenu(Control control) {
        this(control, true);
    }

    public PopupMenu(Control control, boolean bl) {
        this(control, new VS2005ThemeRender(), bl);
    }

    public void setMenu(CMenu cMenu) {
        this.menu = cMenu;
        MenuHolderManager.registryShortcut(this);
    }

    public void dispose() {
        this.hideMenu();
        if (!this.control.isDisposed()) {
            this.control.removeListener(35, this.listener);
        }
    }

    public void setLocation(Point point) {
        this.screenPos = point;
    }

    public void hideMenu() {
        super.hideMenu();
        this.screenPos = null;
    }

    public void open() {
        if (this.screenPos == null) {
            this.screenPos = Display.getDefault().getCursorLocation();
        }
        this.leftScreenPos = this.screenPos;
        this.popupRight = true;
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PopupMenu.this.dispose();
            }
        });
        ShellAdapter shellAdapter = new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                PopupMenu.this.hideMenu();
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                PopupMenu.this.hideMenu();
            }

            public void shellIconified(ShellEvent shellEvent) {
                PopupMenu.this.hideMenu();
            }
        };
        this.control.getShell().addShellListener((ShellListener)shellAdapter);
        this.ignoreTaskbar = true;
        Event event = new Event();
        event.data = this;
        event.type = 4096;
        this.menu.fireMenuEvent(event);
        this.createAndShowWindow();
        this.installMouseHook();
        this.shell.addDisposeListener(new DisposeListener((ShellListener)shellAdapter){
            private final /* synthetic */ ShellListener val$shellListener;
            {
                this.val$shellListener = shellListener;
            }

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!PopupMenu.this.control.isDisposed()) {
                    PopupMenu.this.control.getShell().removeShellListener(this.val$shellListener);
                }
            }
        });
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (PopupMenu.this.shell == null || PopupMenu.this.shell.isDisposed()) {
                    Display.getDefault().removeFilter(3, (Listener)this);
                    return;
                }
                if (event.widget == null || event.widget.isDisposed() || PopupMenu.this.checkMouseDownEvent(((Control)event.widget).toDisplay(event.x, event.y))) {
                    PopupMenu.this.hideMenu();
                }
            }
        };
        Display.getDefault().addFilter(3, listener);
        final Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                if (PopupMenu.this.shell == null || PopupMenu.this.shell.isDisposed()) {
                    Display.getDefault().removeFilter(1, (Listener)this);
                    event.doit = false;
                    return;
                }
                KeyEvent keyEvent = new KeyEvent(event);
                if (keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000013) {
                    PopupMenu.this.hideMenu();
                    return;
                }
                PopupMenu.this.getCurrentMenu().dealAltKeyEvent(keyEvent);
                if (keyEvent.keyCode == 0x1000004 && PopupMenu.this.trackItemIndex > -1) {
                    PopupMenu.this.getCurrentMenu().subMenuSelected();
                }
                if (keyEvent.keyCode == 0x1000003 && PopupMenu.this.trackItemIndex > -1) {
                    PopupMenu.this.getCurrentMenu().parentMenuSelected();
                }
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) {
                    if (keyEvent.keyCode == 0x1000002) {
                        PopupMenu.this.getCurrentMenu().downSelected();
                    } else {
                        PopupMenu.this.getCurrentMenu().upSelected();
                    }
                }
                if (keyEvent.keyCode == 27) {
                    if (PopupMenu.this.getCurrentMenu().parentMenu == null) {
                        PopupMenu.this.getCurrentMenu().hideMenu();
                    } else {
                        PopupMenu.this.getCurrentMenu().parentMenuSelected();
                    }
                }
                if (keyEvent.keyCode == 13) {
                    PopupMenu.this.getCurrentMenu().handleSelectedEvent();
                }
            }
        };
        Display.getDefault().addFilter(1, listener2);
        this.shell.addDisposeListener(new DisposeListener((ShellListener)shellAdapter){
            private final /* synthetic */ ShellListener val$shellListener;
            {
                this.val$shellListener = shellListener;
            }

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Display.getDefault().removeFilter(3, listener);
                Display.getDefault().removeFilter(1, listener2);
                PopupMenu.this.getShell().removeShellListener(this.val$shellListener);
            }
        });
    }

    MenuControl getCurrentMenu() {
        if (this.popupMenu != null && this.popupMenu.trackItemIndex != -1) {
            return this.popupMenu.getCurrentMenu();
        }
        return this;
    }

    private void installMouseHook() {
        if (this.mouseCallback == null) {
            this.mouseCallback = new Callback((Object)this, "MouseProc", 3);
            this.newAddress = this.mouseCallback.getAddress();
            if (this.newAddress == 0) {
                SWT.error((int)3);
            }
            int n = Extension.GetCurrentThreadId();
            this.oldAddress = Extension.SetWindowsHookEx((int)7, (int)this.newAddress, (int)0, (int)n);
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (PopupMenu.this.mouseCallback != null) {
                        Extension.UnhookWindowsHookEx((int)PopupMenu.this.oldAddress);
                        PopupMenu.this.mouseCallback.dispose();
                        PopupMenu.this.mouseCallback = null;
                        PopupMenu.this.newAddress = 0;
                    }
                }
            });
        }
    }

    int MouseProc(int n, int n2, int n3) {
        int n4 = Extension.CallNextHookEx((int)this.oldAddress, (int)n, (int)n2, (int)n3);
        if (n < 0) {
            return n4;
        }
        switch (n2) {
            case 161: 
            case 164: {
                this.hideMenu();
            }
        }
        return n4;
    }

    public Shell getShell() {
        if (this.control.isDisposed()) {
            return null;
        }
        if (this.control instanceof Shell) {
            return (Shell)this.control;
        }
        return this.control.getShell();
    }

    public boolean isAcitve() {
        return this.shell != null && !this.shell.isDisposed();
    }
}

