/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROCESS_INFORMATION;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.sf.feeling.swt.win32.extension.Win32;
import org.sf.feeling.swt.win32.extension.hook.Hook;
import org.sf.feeling.swt.win32.extension.hook.data.HookData;
import org.sf.feeling.swt.win32.extension.hook.listener.HookEventListener;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.shell.Windows;
import org.sf.feeling.swt.win32.extension.system.Kernel;
import org.sf.feeling.swt.win32.extension.widgets.listener.NativeControlStatusListener;
import org.sf.feeling.swt.win32.internal.extension.EventObject;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class NativeControl
extends Canvas {
    private static final int EXITED = 3;
    private static final int FAILED = 2;
    private static final int LOADED = 1;
    private static final int STARTED = 0;
    private static final int TERMINATED = 4;
    private static final int TERMINATED_FAILED = 5;
    private boolean autoStart = true;
    private int childInstanceId = 0;
    private int childWnd = 0;
    private EventObject eventObject;
    private boolean isCreatedNative = false;
    private List listeners;
    private PROCESS_INFORMATION lpProcessInformation;
    private STARTUPINFO lpStartupInfo;
    private boolean monitorRefresh = true;
    private int offsetX;
    private int offsetY;
    private boolean removeMenu = true;
    private String startCommand = null;
    private int state = -1;
    private boolean trace = false;
    private String wndClassName = null;
    private int wndIndex = 0;
    private String wndTitle = null;

    public NativeControl(Composite composite, int n) {
        super(composite, n);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (NativeControl.this.autoStart) {
                            NativeControl.this.createNativeWnd();
                        }
                    }
                });
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (NativeControl.this.childWnd != 0) {
                    Extension.SendMessage((int)NativeControl.this.childWnd, (int)16, (int)0, (int)0);
                }
                if (NativeControl.this.childInstanceId != 0) {
                    boolean bl = Kernel.killProcess(NativeControl.this.childInstanceId);
                    if (bl) {
                        NativeControl.this.fireStatusEvent(4);
                    } else {
                        NativeControl.this.fireStatusEvent(5);
                    }
                }
                if (NativeControl.this.eventObject != null) {
                    NativeControl.this.eventObject.notifyEvent();
                    NativeControl.this.eventObject.close();
                }
                if (NativeControl.this.lpProcessInformation != null && ((NativeControl)NativeControl.this).lpProcessInformation.hProcess != 0) {
                    OS.CloseHandle((int)((NativeControl)NativeControl.this).lpProcessInformation.hProcess);
                }
                if (NativeControl.this.lpProcessInformation != null && ((NativeControl)NativeControl.this).lpProcessInformation.hThread != 0) {
                    OS.CloseHandle((int)((NativeControl)NativeControl.this).lpProcessInformation.hThread);
                }
                if (Hook.SHELL.isInstalled((Object)NativeControl.this)) {
                    Hook.SHELL.uninstall((Object)NativeControl.this);
                }
                if (Hook.GETMESSAGE.isInstalled((Object)NativeControl.this)) {
                    Hook.GETMESSAGE.uninstall((Object)NativeControl.this);
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 8: 
                    case 16: {
                        traverseEvent.doit = true;
                    }
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){});
    }

    public void addStatusListener(NativeControlStatusListener nativeControlStatusListener) {
        if (nativeControlStatusListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(nativeControlStatusListener)) {
            this.listeners.add(nativeControlStatusListener);
        }
    }

    private void createNativeWnd() {
        if (this.childWnd == 0 && !this.isCreatedNative) {
            this.isCreatedNative = true;
            Thread thread = new Thread(){

                public void run() {
                    NativeControl.this.childWnd = NativeControl.this.startAndReparent(NativeControl.this.startCommand);
                    if (NativeControl.this.childWnd != 0 && !Display.getDefault().isDisposed()) {
                        Display display = Display.getDefault();
                        display.syncExec(new Runnable(){

                            public void run() {
                                if (NativeControl.this.isDisposed()) {
                                    return;
                                }
                                NativeControl.this.addControlListener((ControlListener)new ControlAdapter(){

                                    public void controlResized(ControlEvent controlEvent) {
                                        Rectangle rectangle = NativeControl.this.getClientArea();
                                        int n = rectangle.width;
                                        int n2 = rectangle.height;
                                        NativeControl.this.removeChildMenu();
                                        Extension.ShowWindow((int)NativeControl.this.childWnd, (int)Win32.SW_RESTORE);
                                        Extension.SetWindowPos((int)NativeControl.this.childWnd, (int)0, (int)(rectangle.x + NativeControl.this.offsetX), (int)(rectangle.y + NativeControl.this.offsetY), (int)n, (int)n2, (int)25684);
                                    }
                                });
                                NativeControl.this.fireStatusEvent(1);
                                if (NativeControl.this.monitorRefresh) {
                                    Thread thread = new Thread(){
                                        Point size = null;

                                        public void run() {
                                            final int[] nArray = new int[]{100};
                                            while (nArray[0] > 0) {
                                                try {
                                                    Thread.sleep(nArray[0]);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    interruptedException.printStackTrace();
                                                }
                                                Display.getDefault().syncExec(new Runnable(){

                                                    public void run() {
                                                        if (NativeControl.this.isDisposed()) {
                                                            nArray[0] = 0;
                                                            return;
                                                        }
                                                        Rectangle rectangle = Windows.getWindowRect(NativeControl.this.childWnd);
                                                        Point point = NativeControl.this.toControl(rectangle.x, rectangle.y);
                                                        Point point2 = new Point(rectangle.width, rectangle.height);
                                                        if (point.x != NativeControl.this.offsetX || point.y != NativeControl.this.offsetY || !point2.equals((Object)size)) {
                                                            size = point2;
                                                            NativeControl.this.refresh();
                                                            nArray[0] = 100;
                                                        } else {
                                                            nArray[0] = 500;
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    };
                                    thread.setDaemon(true);
                                    thread.start();
                                }
                            }
                        });
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    public boolean isCreatedNative() {
        return this.isCreatedNative;
    }

    void fireStatusEvent(int n) {
        this.state = n;
        final Event event = new Event();
        event.type = n;
        event.widget = this;
        event.time = Extension.GetTickCount();
        if (this.listeners != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    block8: for (int i = 0; i < NativeControl.this.listeners.size(); ++i) {
                        NativeControlStatusListener nativeControlStatusListener = (NativeControlStatusListener)NativeControl.this.listeners.get(i);
                        switch (event.type) {
                            case 0: {
                                nativeControlStatusListener.handleStartEvent(event);
                                continue block8;
                            }
                            case 1: {
                                nativeControlStatusListener.handleLoadedEvent(event);
                                continue block8;
                            }
                            case 2: {
                                nativeControlStatusListener.handleFailedEvent(event);
                                continue block8;
                            }
                            case 3: {
                                nativeControlStatusListener.handleExitedEvent(event);
                                continue block8;
                            }
                            case 4: {
                                nativeControlStatusListener.handleTerminatedEvent(event);
                                continue block8;
                            }
                            case 5: {
                                event.detail = NativeControl.this.childInstanceId;
                                nativeControlStatusListener.handleTerminatFailedEvent(event);
                            }
                        }
                    }
                }
            });
        }
    }

    public int getChildeProcessHandle() {
        if (this.lpProcessInformation != null) {
            return this.lpProcessInformation.hProcess;
        }
        return 0;
    }

    public int getChildProcessId() {
        return this.childInstanceId;
    }

    public int getChildWndHandle() {
        return this.childWnd;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isMonitorRefresh() {
        return this.monitorRefresh;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public String getWndClassName() {
        return this.wndClassName;
    }

    public int getWndIndex() {
        return this.wndIndex;
    }

    public String getWndTitle() {
        return this.wndTitle;
    }

    public void monitorRefresh(boolean bl) {
        this.monitorRefresh = bl;
    }

    public void refresh() {
        this.notifyListeners(11, new Event());
    }

    public void removeChildWndMenu(boolean bl) {
        this.removeMenu = bl;
    }

    public void removeStatusListener(NativeControlStatusListener nativeControlStatusListener) {
        if (nativeControlStatusListener == null) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(nativeControlStatusListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public void setChildWndOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    public void setStartCommand(String string, boolean bl) {
        this.startCommand = string;
        this.autoStart = bl;
    }

    public void setStartParameters(String string, String string2, String string3, int n, boolean bl) {
        this.startCommand = string;
        this.wndClassName = string2;
        this.wndTitle = string3;
        this.wndIndex = n;
        this.autoStart = bl;
    }

    public void setWndClassName(String string) {
        this.wndClassName = string;
    }

    public void setWndIndex(int n) {
        this.wndIndex = n;
    }

    public void setWndTitle(String string) {
        this.wndTitle = string;
    }

    public void start() {
        this.createNativeWnd();
    }

    protected int startAndReparent(String string) {
        Pointer pointer;
        if (string == null) {
            return 0;
        }
        this.fireStatusEvent(0);
        final int[] nArray = new int[1];
        try {
            pointer = Pointer.createPointerFromString(string, Extension.IsUnicode);
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
            return 0;
        }
        this.eventObject = new EventObject("NativeControl@" + ((Object)((Object)this)).hashCode());
        this.eventObject.reset();
        Hook.SHELL.addListener((Object)this, new HookEventListener(){
            int index = 0;

            public void acceptHookData(HookData hookData) {
                if (NativeControl.this.childInstanceId != 0 && (hookData.getNCode() == 1 || hookData.getNCode() == 4 || NativeControl.this.state < 1 && hookData.getNCode() == 6)) {
                    int n = hookData.getWParam();
                    int[] nArray2 = new int[1];
                    Extension.GetWindowThreadProcessId((int)n, (int[])nArray2);
                    if (nArray2[0] == NativeControl.this.childInstanceId) {
                        String string = Windows.getClassName(n);
                        if (!(NativeControl.this.wndClassName == null || string != null && string.startsWith(NativeControl.this.wndClassName))) {
                            if (NativeControl.this.trace) {
                                System.out.println("Window Class Name = " + string);
                            }
                            return;
                        }
                        String string2 = Windows.getWindowText(n);
                        if (!(NativeControl.this.wndTitle == null || string2 != null && string2.startsWith(NativeControl.this.wndTitle))) {
                            if (NativeControl.this.trace) {
                                System.out.println("Window Title = " + string2);
                            }
                            return;
                        }
                        if (NativeControl.this.wndIndex > 0) {
                            ++this.index;
                            if (this.index < NativeControl.this.wndIndex) {
                                if (NativeControl.this.trace) {
                                    System.out.println("Index = " + this.index);
                                }
                                return;
                            }
                        }
                        nArray[0] = n;
                        Extension.ShowWindow((int)n, (int)0);
                        if (NativeControl.this.eventObject != null) {
                            Extension.SetEvent(NativeControl.this.eventObject.getEventHandle());
                        }
                    }
                }
            }
        });
        Hook.SHELL.install((Object)this);
        this.lpStartupInfo = new STARTUPINFO();
        this.lpStartupInfo.cb = STARTUPINFO.sizeof;
        this.lpProcessInformation = new PROCESS_INFORMATION();
        this.lpStartupInfo.wShowWindow = 0;
        this.lpStartupInfo.dwFlags = 1;
        this.lpStartupInfo.wShowWindow = (short)2;
        if (!Extension.CreateProcess((int)0, (int)pointer.getPointer(), (int)0, (int)0, (boolean)true, (int)0, (int)0, (int)0, (STARTUPINFO)this.lpStartupInfo, (PROCESS_INFORMATION)this.lpProcessInformation)) {
            System.err.println("ERROR: Cannot launch child process");
            if (Hook.SHELL.isInstalled((Object)this)) {
                Hook.SHELL.uninstall((Object)this);
            }
            if (Hook.GETMESSAGE.isInstalled((Object)this)) {
                Hook.GETMESSAGE.uninstall((Object)this);
            }
            this.fireStatusEvent(2);
            return 0;
        }
        this.childInstanceId = this.lpProcessInformation.dwProcessId;
        Thread thread = new Thread(){

            public void run() {
                if (NativeControl.this.lpProcessInformation != null && ((NativeControl)NativeControl.this).lpProcessInformation.hProcess != 0 && Extension.WaitForSingleObject(((NativeControl)NativeControl.this).lpProcessInformation.hProcess, -1) == 0) {
                    NativeControl.this.fireStatusEvent(3);
                    NativeControl.this.childInstanceId = 0;
                    if (Display.getDefault().isDisposed()) {
                        return;
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (!NativeControl.this.isDisposed()) {
                                NativeControl.this.dispose();
                            }
                        }
                    });
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.eventObject.waitFor(60000);
        if (nArray[0] != 0) {
            RECT rECT = new RECT();
            Extension.GetWindowRect((int)this.handle, (RECT)rECT);
            Extension.ShowWindow((int)nArray[0], (int)0);
            Extension.SetParent((int)nArray[0], (int)this.handle);
            Extension.SetWindowLong((int)nArray[0], (int)-16, (int)Integer.MIN_VALUE);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Extension.ShowWindow((int)nArray[0], (int)Win32.SW_RESTORE);
                    NativeControl.this.removeChildMenu();
                    Rectangle rectangle = NativeControl.this.getClientArea();
                    int n = rectangle.width;
                    int n2 = rectangle.height;
                    Extension.SetWindowLong((int)nArray[0], (int)-16, (int)Integer.MIN_VALUE);
                    Extension.SetWindowPos((int)NativeControl.this.childWnd, (int)0, (int)(rectangle.x + NativeControl.this.offsetX), (int)(rectangle.y + NativeControl.this.offsetY), (int)n, (int)n2, (int)25684);
                }
            });
        }
        return nArray[0];
    }

    public void traceChildWndInfo(boolean bl) {
        this.trace = bl;
    }

    public void forceChildWndActive() {
        if (this.childWnd != 0) {
            Extension.SetForegroundWindow((int)this.childWnd);
            this.getShell().forceFocus();
        }
    }

    private void removeChildMenu() {
        int n;
        if (this.removeMenu && (n = Extension.GetMenu((int)this.childWnd)) != 0) {
            int n2 = Extension.GetMenuItemCount((int)n);
            for (int i = 0; i < n2; ++i) {
                Extension.RemoveMenu((int)n, (int)0, (int)1024);
            }
            Extension.DestroyMenu((int)n);
            Extension.SetMenu((int)this.childWnd, (int)0);
        }
    }
}

