/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.CMenuItem;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolder;
import org.sf.feeling.swt.win32.extension.widgets.Shortcut;
import org.sf.feeling.swt.win32.extension.widgets.ShortcutMap;

public class MenuHolderManager {
    private static Hashtable manager = new Hashtable();
    private static Vector holders = new Vector();

    public static MenuHolder getActiveHolder() {
        for (int i = 0; i < holders.size(); ++i) {
            MenuHolder menuHolder = (MenuHolder)holders.get(i);
            if (menuHolder.getShell() != null && menuHolder.getShell().isDisposed()) {
                holders.remove(menuHolder);
                --i;
                continue;
            }
            if (!menuHolder.isAcitve()) continue;
            return menuHolder;
        }
        return null;
    }

    public static void registryShortcut(MenuHolder menuHolder) {
        MenuHolderManager.registerHolder(menuHolder);
        final Shell shell = menuHolder.getShell();
        if (shell == null || shell.isDisposed() || menuHolder.getMenu() == null) {
            return;
        }
        if (!manager.containsKey(shell)) {
            manager.put(shell, new ShortcutMap());
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (manager.containsKey(shell)) {
                        ((ShortcutMap)manager.get(shell)).dispose();
                        manager.remove(shell);
                    }
                }
            });
        }
        ShortcutMap shortcutMap = (ShortcutMap)manager.get(shell);
        MenuHolderManager.insertShortcut(shortcutMap, menuHolder.getMenu());
    }

    public static void deRegistryShortcut(MenuHolder menuHolder, Shortcut shortcut) {
        Shell shell = menuHolder.getShell();
        if (shell == null || shell.isDisposed() || menuHolder.getMenu() == null) {
            return;
        }
        if (!manager.containsKey(shell)) {
            return;
        }
        ShortcutMap shortcutMap = (ShortcutMap)manager.get(shell);
        shortcutMap.removeShortcut(shortcut);
    }

    public static void registerHolder(MenuHolder menuHolder) {
        if (!holders.contains(menuHolder)) {
            holders.add(menuHolder);
        }
    }

    private static void insertShortcut(ShortcutMap shortcutMap, CMenu cMenu) {
        for (int i = 0; i < cMenu.getItemCount(); ++i) {
            CMenuItem cMenuItem = cMenu.getItem(i);
            if (cMenuItem.getMenu() != null) {
                MenuHolderManager.insertShortcut(shortcutMap, cMenuItem.getMenu());
                continue;
            }
            if (cMenuItem.getShortcut() == null) continue;
            shortcutMap.putShortcut(cMenuItem.getShortcut(), cMenuItem);
        }
    }

    public static void deRegistryShortcut(MenuHolder menuHolder) {
        Shell shell = menuHolder.getShell();
        if (shell == null || shell.isDisposed() || !manager.containsKey(shell)) {
            return;
        }
        ShortcutMap shortcutMap = (ShortcutMap)manager.get(shell);
        MenuHolderManager.removeShortcut(shortcutMap, menuHolder.getMenu());
    }

    private static void removeShortcut(ShortcutMap shortcutMap, CMenu cMenu) {
        for (int i = 0; i < cMenu.getItemCount(); ++i) {
            CMenuItem cMenuItem = cMenu.getItem(i);
            if (cMenuItem.getMenu() != null) {
                MenuHolderManager.removeShortcut(shortcutMap, cMenuItem.getMenu());
                continue;
            }
            if (cMenuItem.getShortcut() == null) continue;
            shortcutMap.removeShortcut(cMenuItem.getShortcut());
        }
    }

    static {
        Display.getDefault().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                MenuHolder menuHolder;
                for (int i = 0; i < holders.size(); ++i) {
                    menuHolder = (MenuHolder)holders.get(i);
                    if (menuHolder.getShell() != null && menuHolder.getShell().isDisposed()) {
                        holders.remove(menuHolder);
                        --i;
                        continue;
                    }
                    if (!menuHolder.isAcitve()) continue;
                    return;
                }
                Shortcut shortcut = new Shortcut(event.keyCode);
                shortcut.setControl((event.stateMask & 0x40000) != 0);
                shortcut.setShift((event.stateMask & 0x20000) != 0);
                shortcut.setAlt((event.stateMask & 0x10000) != 0);
                menuHolder = Display.getDefault().getActiveShell();
                ShortcutMap shortcutMap = (ShortcutMap)manager.get(menuHolder);
                if (shortcutMap != null && shortcutMap.contains(shortcut)) {
                    event.data = shortcutMap.getMenuItem(shortcut);
                    if (shortcutMap.getMenuItem(shortcut).isEnabled()) {
                        shortcutMap.getMenuItem(shortcut).fireSelectionEvent(event);
                    }
                }
            }
        });
    }
}

