/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.system;

import java.util.ArrayList;
import java.util.Iterator;
import org.sf.feeling.swt.win32.extension.registry.RegistryKey;
import org.sf.feeling.swt.win32.extension.registry.RegistryValue;
import org.sf.feeling.swt.win32.extension.registry.RootKey;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class SystemVariables {
    private static final String SYSTEM_ENVIRONMENT = "System\\CurrentControlSet\\Control\\Session Manager\\Environment";
    private static final int HWND_BROADCAST = 65535;
    private RegistryKey registryKey = new RegistryKey(RootKey.HKEY_LOCAL_MACHINE, "System\\CurrentControlSet\\Control\\Session Manager\\Environment");
    private static SystemVariables systemVariables = null;

    private SystemVariables() {
        if (!this.registryKey.exists()) {
            throw new UnsupportedOperationException();
        }
    }

    public static SystemVariables getInstance() {
        if (systemVariables == null) {
            systemVariables = new SystemVariables();
        }
        return systemVariables;
    }

    public String getValue(String string) {
        if (!this.registryKey.exists()) {
            throw new UnsupportedOperationException();
        }
        if (this.registryKey.hasValue(string)) {
            return (String)this.registryKey.getValue(string).getData();
        }
        return null;
    }

    public void setVariable(String string, String string2) {
        if (!this.registryKey.exists()) {
            throw new UnsupportedOperationException();
        }
        this.registryKey.setValue(new RegistryValue(string, string2));
        this.fireSettingChanged();
    }

    private void fireSettingChanged() {
        Extension.SendMessage((int)65535, (int)26, (int)0, (int)0);
    }

    public boolean contains(String string) {
        if (!this.registryKey.exists()) {
            throw new UnsupportedOperationException();
        }
        return this.registryKey.hasValue(string);
    }

    public void removeVariable(String string) {
        if (!this.registryKey.exists()) {
            throw new UnsupportedOperationException();
        }
        if (this.contains(string)) {
            this.registryKey.deleteValue(string);
        }
    }

    public String[] getVariableNames() {
        if (!this.registryKey.exists()) {
            throw new UnsupportedOperationException();
        }
        if (this.registryKey.hasValues()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.registryKey.values();
            while (iterator.hasNext()) {
                RegistryValue registryValue = (RegistryValue)iterator.next();
                arrayList.add(registryValue.getName());
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }
}

