/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.system;

import java.util.List;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.HANDLE;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.win32.Kernel32;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.PROCESSENTRY32;
import org.sf.feeling.swt.win32.extension.system.ModuleEntry;
import org.sf.feeling.swt.win32.extension.system.ProcessEntry;
import org.sf.feeling.swt.win32.extension.system.ThreadEntry;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.Extension2;

public class Kernel {
    public static final int PROCESS_ALL_ACCESS = 0x1F0FFF;
    public static final int PROCESS_CREATE_THREAD = 2;
    public static final int PROCESS_DUP_HANDLE = 64;
    public static final int PROCESS_QUERY_INFORMATION = 1024;
    public static final int PROCESS_SET_INFORMATION = 512;
    public static final int PROCESS_TERMINATE = 1;
    public static final int PROCESS_VM_OPERATION = 8;
    public static final int PROCESS_VM_READ = 16;
    public static final int PROCESS_VM_WRITE = 32;
    public static final int SYNCHRONIZE = 0x100000;
    public static final int SE_BACKUP_PRIVILEGE = 17;
    public static final int SE_RESTORE_PRIVILEGE = 18;
    public static final int SE_SHUTDOWN_PRIVILEGE = 19;
    public static final int SE_DEBUG_PRIVILEGE = 20;
    public static final int PAGE_NOACCESS = 1;
    public static final int PAGE_READONLY = 2;
    public static final int PAGE_READWRITE = 4;
    public static final int PAGE_WRITECOPY = 8;
    public static final int PAGE_EXECUTE = 16;
    public static final int PAGE_EXECUTE_READ = 32;
    public static final int PAGE_EXECUTE_READWRITE = 64;
    public static final int PAGE_EXECUTE_WRITECOPY = 128;
    public static final int PAGE_GUARD = 256;
    public static final int PAGE_NOCACHE = 512;
    public static final int PAGE_WRITECOMBINE = 1024;

    public static int openProcess(int n, boolean bl, int n2) {
        return Extension2.OpenProcess(n, bl, n2);
    }

    public static int openProcess(int n) {
        return Kernel.openProcess(0x1F0FFF, false, n);
    }

    public static boolean enablePrivilege(int n) {
        return Kernel.enablePrivilege(n, true, false);
    }

    public static boolean enablePrivilege(int n, boolean bl, boolean bl2) {
        return Extension2.EnablePrivilege(n, bl, bl2);
    }

    public static boolean killProcess(int n) {
        if (Kernel.enablePrivilege(20)) {
            int n2 = Kernel.openProcess(1, false, n);
            if (n2 == 0) {
                return false;
            }
            boolean bl = Extension2.TerminateProcess(n2, 0);
            Extension.CloseHandle((int)n2);
            return bl;
        }
        return false;
    }

    public static boolean writeProcessMemory(int n, int n2, int n3, int n4) {
        return Extension2.WriteProcessMemory(n, n2, n3, n4);
    }

    public static boolean readProcessMemory(int n, int n2, int n3, int n4) {
        return Extension2.ReadProcessMemory(n, n2, n3, n4);
    }

    public static boolean virtualProtectEx(int n, int n2, int n3, int n4) {
        return Extension2.VirtualProtectEx(n, n2, n3, n4);
    }

    public static ProcessEntry[] getSystemProcessesSnap() {
        List list = Extension.GetSystemProcessesSnap();
        return list.toArray(new ProcessEntry[0]);
    }

    public static ModuleEntry[] getProcessModulesSnap(int n) {
        List list = Extension.GetProcessModulesSnap(n);
        return list.toArray(new ModuleEntry[0]);
    }

    public static ThreadEntry[] getProcessThreadsSnap(int n) {
        List list = Extension.GetProcessThreadsSnap(n);
        return list.toArray(new ThreadEntry[0]);
    }

    public static boolean setProcessPriority(String string, int n) throws NativeException, IllegalAccessException {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        int n2 = Kernel.getProcessId(string);
        if (n2 != 0) {
            HANDLE hANDLE = Kernel32.OpenProcess(0x1F0FFF, false, n2);
            if (hANDLE.getValue() != 0) {
                bl = Kernel32.SetPriorityClass(hANDLE, new DWORD(n));
            }
            Kernel32.CloseHandle(hANDLE);
        }
        return bl;
    }

    public static final int getProcessId(String string) throws NativeException, IllegalAccessException {
        if (string != null) {
            PROCESSENTRY32 pROCESSENTRY32 = new PROCESSENTRY32();
            HANDLE hANDLE = Kernel32.CreateToolhelp32Snapshot(15, 0);
            if (hANDLE.getValue() != 0 && Kernel32.Process32First(hANDLE, pROCESSENTRY32)) {
                do {
                    if (pROCESSENTRY32.getValue().szExeFile.equalsIgnoreCase(string)) {
                        return pROCESSENTRY32.th32ProcessID.getValue();
                    }
                    pROCESSENTRY32.resetPointer();
                } while (Kernel32.Process32Next(hANDLE, pROCESSENTRY32));
            }
            Kernel32.CloseHandle(hANDLE);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean attachDllToProcess(String string, String string2) throws NativeException, IllegalAccessException {
        block9: {
            int n = Kernel.getProcessId(string2);
            if (n != 0) {
                HANDLE hANDLE = Kernel32.OpenProcess(0x1F0FFF, false, n);
                try {
                    int n2;
                    if (hANDLE.getValue() == 0 || !Kernel32.WriteProcessMemory(hANDLE, n2 = Kernel32.VirtualAllocEx(hANDLE, 0, string.length(), new DWORD(4096), new DWORD(4)), Pointer.createPointerFromString(string), string.length())) break block9;
                    HANDLE hANDLE2 = Kernel32.CreateRemoteThread(hANDLE, null, 0, Kernel32.GetProcAddress(new HANDLE(Kernel32.GetModuleHandle("Kernel32")), "LoadLibraryA"), n2, new DWORD(0), new DWORD(0));
                    try {
                        if (hANDLE2.getValue() != 0) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    finally {
                        Kernel32.VirtualFreeEx(hANDLE, n2, 0, new DWORD(32768));
                        Kernel32.CloseHandle(hANDLE2);
                    }
                }
                finally {
                    Kernel32.CloseHandle(hANDLE);
                }
            }
        }
        return false;
    }
}

