/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.sound;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.sound.Mixer;
import org.sf.feeling.swt.win32.extension.sound.hook.MixerMsgHook;

public class VolumeControl {
    private static final int deviceId = 0;
    public static final int MAX_VOL_VALUE = 65535;
    private static MixerMsgHook hook;

    public static boolean openControl(Shell shell) {
        boolean bl = Mixer.mixerOpen(shell.handle, 0);
        hook = new MixerMsgHook(shell);
        hook.installHook();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                VolumeControl.colseControl();
            }
        });
        return bl;
    }

    public static boolean isControlOpened() {
        return Mixer.getMixerHandle(0) != 0;
    }

    public static void addChangeListener(Listener listener) {
        if (hook != null) {
            hook.addChangeListener(listener);
        }
    }

    public static void removeChangeListener(Listener listener) {
        if (hook != null) {
            hook.removeChangeListener(listener);
        }
    }

    public static boolean colseControl() {
        if (hook != null) {
            hook.unInstallHook();
        }
        return Mixer.mixerClose(0);
    }

    public static int getVolume() {
        return Mixer.getMasterVolume(0);
    }

    public static boolean setVolume(int n) {
        return Mixer.setMasterVolume(0, n);
    }

    public static float getBalance() {
        return Mixer.getMasterBalance(0);
    }

    public static boolean setBalance(float f) {
        return Mixer.setMasterBalance(0, f);
    }

    public static float getLeftChannelVolume() {
        return Mixer.getMasterLeftChannelVolume(0);
    }

    public static boolean setLeftChannelVolume(int n) {
        return Mixer.setMasterLeftChannelVolume(0, n);
    }

    public static float getRightChannelVolume() {
        return Mixer.getMasterRightChannelVolume(0);
    }

    public static boolean setRightChannelVolume(int n) {
        return Mixer.setMasterRightChannelVolume(0, n);
    }

    public static boolean isMono() {
        return Mixer.isPlaybackMixerMono(0);
    }

    public static boolean isMute() {
        return Mixer.isMasterMute(0);
    }

    public static boolean setMute(boolean bl) {
        return Mixer.setMasterMute(0, bl);
    }

    public static int getMicrophoneVolume() {
        return Mixer.getMicrophoneVolume(0);
    }

    public static boolean setMicrophoneVolume(int n) {
        return Mixer.setMicrophoneVolume(0, n);
    }

    public static boolean isMicrophoneMute() {
        return Mixer.isMicrophoneMute(0);
    }

    public static boolean setMicrophoneMute(boolean bl) {
        return Mixer.setMicrophoneMute(0, bl);
    }
}

