/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.sound;

import java.util.HashMap;
import org.sf.feeling.swt.win32.extension.sound.MixerCaps;
import org.sf.feeling.swt.win32.extension.sound.MixerLine;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.MIXERCAPS;
import org.sf.feeling.swt.win32.internal.extension.MIXERCAPSA;
import org.sf.feeling.swt.win32.internal.extension.MIXERCAPSW;
import org.sf.feeling.swt.win32.internal.extension.MIXERHANDLE;
import org.sf.feeling.swt.win32.internal.extension.MIXERLINEA;
import org.sf.feeling.swt.win32.internal.extension.MIXERLINEW;
import org.sf.feeling.swt.win32.internal.extension.MIXERVOLUME;

public class Mixer {
    public static final int MMSYSERR_NOERROR = 0;
    public static final int CALLBACK_WINDOW = 65536;
    public static final int MIXER_OBJECTF_MIXER = 0;
    public static final int MIXERLINE_COMPONENTTYPE_DST_FIRST = 0;
    public static final int MIXERLINE_COMPONENTTYPE_SRC_FIRST = 4096;
    private static final int MIXERLINE_COMPONENTTYPE_SRC_LAST = 4106;
    public static final int NO_SOURCE = 4107;
    public static final int MIXERLINE_COMPONENTTYPE_DST_SPEAKERS = 4;
    public static final int MIXERLINE_COMPONENTTYPE_DST_WAVEIN = 7;
    public static final int MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE = 4099;
    public static final int MIXERLINE_COMPONENTTYPE_SRC_LINE = 4098;
    public static final int MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC = 4101;
    public static final int MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER = 4100;
    public static final int MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT = 4104;
    public static final int TYPE_VOLUMECONTROL = 4;
    public static final int TYPE_WAVE = 4104;
    public static final int TYPE_MIDI = 4100;
    public static final int TYPE_CDPLAYER = 4101;
    public static final int TYPE_MICROPHONE = 4099;
    public static final int TYPE_LINEIN = 4098;
    public static final int MIXER_OBJECTF_HANDLE = Integer.MIN_VALUE;
    public static final int MIXER_OBJECTF_HMIXER = Integer.MIN_VALUE;
    public static final int MIXER_GETLINEINFOF_DESTINATION = 0;
    public static final int MIXER_GETLINEINFOF_SOURCE = 1;
    public static final int MIXER_GETLINEINFOF_LINEID = 2;
    public static final int MIXER_GETLINEINFOF_COMPONENTTYPE = 3;
    public static final int MIXER_GETLINEINFOF_TARGETTYPE = 4;
    public static final int MAX_VOL_VALUE = 65535;
    private static HashMap mixerMap = new HashMap();

    public static int mixerGetNumDevs() {
        return Extension.MixerGetNumDevs();
    }

    public static boolean mixerOpen(int n, int n2) {
        MIXERHANDLE mIXERHANDLE;
        boolean bl;
        int n3 = 0;
        if (n != 0) {
            n3 |= 0x10000;
        }
        boolean bl2 = bl = Extension.MixerOpen(mIXERHANDLE = new MIXERHANDLE(), n2, n, 0, n3) == 0;
        if (bl) {
            mixerMap.put(new Integer(n2), new Integer(mIXERHANDLE.hMixer));
        }
        return bl;
    }

    public static boolean mixerClose(int n) {
        if (mixerMap.containsKey(new Integer(n))) {
            boolean bl;
            int n2 = (Integer)mixerMap.get(new Integer(n));
            boolean bl2 = bl = Extension.MixerClose(n2) == 0;
            if (bl) {
                mixerMap.remove(new Integer(n));
            }
            return bl;
        }
        return false;
    }

    public static int getMixerHandle(int n) {
        if (mixerMap.containsKey(new Integer(n))) {
            return (Integer)mixerMap.get(new Integer(n));
        }
        return 0;
    }

    private static boolean mixerGetDevCaps(int n, MIXERCAPS mIXERCAPS) {
        int n2 = Mixer.getMixerHandle(n);
        if (n2 == 0) {
            return false;
        }
        boolean bl = false;
        bl = Extension.IsUnicode ? Extension.MixerGetDevCapsW(n, (MIXERCAPSW)mIXERCAPS) == 0 : Extension.MixerGetDevCapsA(n, (MIXERCAPSA)mIXERCAPS) == 0;
        return bl;
    }

    private static boolean mixerGetLineInfo(int n, MixerLine mixerLine, int n2) {
        int n3 = Mixer.getMixerHandle(n);
        if (n3 == 0) {
            return false;
        }
        boolean bl = false;
        bl = Extension.IsUnicode ? Extension.MixerGetLineInfoW(n, (MIXERLINEW)mixerLine.mixerLine, n2) == 0 : Extension.MixerGetLineInfoA(n, (MIXERLINEA)mixerLine.mixerLine, n2) == 0;
        return bl;
    }

    public static MixerCaps getMixerCaps(int n) {
        MIXERCAPS mIXERCAPS = null;
        mIXERCAPS = Extension.IsUnicode ? new MIXERCAPSW() : new MIXERCAPSA();
        if (Mixer.mixerGetDevCaps(n, mIXERCAPS)) {
            return new MixerCaps(mIXERCAPS);
        }
        return null;
    }

    public static boolean getMixerLine(int n, MixerLine mixerLine, int n2) {
        return Mixer.mixerGetLineInfo(n, mixerLine, n2);
    }

    public static MixerLine getPlaybackMixerLine(int n) {
        MixerLine mixerLine = new MixerLine();
        mixerLine.setCbStruct(MixerLine.sizeof);
        mixerLine.setDwComponentType(4);
        if (Mixer.getMixerLine(n, mixerLine, -2147483645)) {
            return mixerLine;
        }
        return null;
    }

    public static boolean isPlaybackDevice(int n) {
        return Mixer.getPlaybackMixerLine(n) != null;
    }

    public static MixerLine getRecordingMixerLine(int n) {
        MixerLine mixerLine = new MixerLine();
        mixerLine.setCbStruct(MixerLine.sizeof);
        mixerLine.setDwComponentType(7);
        if (Mixer.getMixerLine(n, mixerLine, -2147483645)) {
            return mixerLine;
        }
        return null;
    }

    public static boolean isRecordingDevice(int n) {
        return Mixer.getRecordingMixerLine(n) != null;
    }

    public static int getNumDestinationLine(int n) {
        MixerCaps mixerCaps = Mixer.getMixerCaps(n);
        if (mixerCaps != null) {
            return mixerCaps.getCDestinations();
        }
        return 0;
    }

    public static int getMasterVolume(int n) {
        if (!Mixer.isPlaybackMixerMono(n)) {
            return Math.max(Mixer.getMasterRightChannelVolume(n), Mixer.getMasterLeftChannelVolume(n));
        }
        return Mixer.getMasterLeftChannelVolume(n);
    }

    public static boolean setMasterVolume(int n, int n2) {
        return Mixer.setMixerVolume(n, n2, 4);
    }

    public static boolean setMixerVolume(int n, int n2, int n3) {
        if (!Mixer.isScrTypeMono(n, 4, n3)) {
            float f = Mixer.getPlaybackVolumeBalance(n, n3);
            if (f > 0.0f) {
                return Mixer.setPlaybackVolume(n, (int)((float)n2 * (1.0f - f)), n2, n3, false);
            }
            return Mixer.setPlaybackVolume(n, n2, (int)((float)n2 * (1.0f + f)), n3, false);
        }
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = n2;
        return Extension.SetPlaybackVolume(n, n3, mIXERVOLUME, true);
    }

    public static int getMixerVolume(int n, int n2) {
        if (!Mixer.isScrTypeMono(n, 4, n2)) {
            return Math.max(Mixer.getRightChannelVolume(n, n2), Mixer.getLeftChannelVolume(n, n2));
        }
        return Mixer.getLeftChannelVolume(n, n2);
    }

    public static boolean isPlaybackMixerMono(int n) {
        MixerLine mixerLine = Mixer.getPlaybackMixerLine(n);
        if (mixerLine == null) {
            return true;
        }
        return mixerLine.getCChannels() <= 1;
    }

    public static boolean isRecordingMixerMono(int n) {
        MixerLine mixerLine = Mixer.getRecordingMixerLine(n);
        if (mixerLine == null) {
            return true;
        }
        return mixerLine.getCChannels() <= 1;
    }

    public static boolean isScrTypeMono(int n, int n2, int n3) {
        return Mixer.getMixerLineChannels(n, n2, n3) < 2;
    }

    public static int getMasterLeftChannelVolume(int n) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        if (Extension.GetPlaybackVolume(n, 4, mIXERVOLUME, Mixer.isPlaybackMixerMono(n))) {
            return mIXERVOLUME.leftChannelVolume;
        }
        return 0;
    }

    public static int getMasterRightChannelVolume(int n) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        if (Extension.GetPlaybackVolume(n, 4, mIXERVOLUME, Mixer.isPlaybackMixerMono(n))) {
            return mIXERVOLUME.rightChannelVolume;
        }
        return 0;
    }

    public static int getLeftChannelVolume(int n, int n2) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        if (Extension.GetPlaybackVolume(n, n2, mIXERVOLUME, Mixer.isPlaybackMixerMono(n))) {
            return mIXERVOLUME.leftChannelVolume;
        }
        return 0;
    }

    public static int getRightChannelVolume(int n, int n2) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        if (Extension.GetPlaybackVolume(n, n2, mIXERVOLUME, Mixer.isPlaybackMixerMono(n))) {
            return mIXERVOLUME.rightChannelVolume;
        }
        return 0;
    }

    public static int[] getPlaybackVolume(int n, int n2, boolean bl) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        if (Extension.GetPlaybackVolume(n, n2, mIXERVOLUME, bl)) {
            return new int[]{mIXERVOLUME.leftChannelVolume, mIXERVOLUME.rightChannelVolume};
        }
        return new int[0];
    }

    public static float getMasterBalance(int n) {
        return Mixer.getPlaybackVolumeBalance(n, 4);
    }

    public static boolean setMasterBalance(int n, float f) {
        return Mixer.setPlaybackVolumeBalance(n, 4, f);
    }

    public static float getPlaybackVolumeBalance(int n, int n2) {
        int[] nArray = Mixer.getPlaybackVolume(n, n2, false);
        if (nArray.length < 2) {
            return 0.0f;
        }
        if (nArray[0] == 0 && nArray[1] == 0) {
            return 0.0f;
        }
        int n3 = nArray[0] < nArray[1] ? nArray[1] : nArray[0];
        return ((float)nArray[1] - (float)nArray[0]) / (float)n3;
    }

    public static float getRecordingVolumeBalance(int n, int n2) {
        int[] nArray = Mixer.getRecordingVolume(n, n2, Mixer.isRecordingMixerMono(n));
        if (nArray.length < 2) {
            return 0.0f;
        }
        if (nArray[0] == 0 && nArray[1] == 0) {
            return 0.0f;
        }
        int n3 = nArray[0] < nArray[1] ? nArray[1] : nArray[0];
        return ((float)nArray[1] - (float)nArray[0]) / (float)n3;
    }

    public static boolean setPlaybackVolumeBalance(int n, int n2, float f) {
        if (Mixer.getMixerHandle(n) == 0) {
            return false;
        }
        int[] nArray = Mixer.getPlaybackVolume(n, n2, true);
        if (nArray.length < 2) {
            return false;
        }
        int[] nArray2 = Mixer.computingBalance(nArray[0], nArray[1], f);
        return Mixer.setPlaybackVolume(n, nArray2[0], nArray2[1], n2, Mixer.isPlaybackMixerMono(n));
    }

    public static boolean setRecordingVolumeBalance(int n, int n2, float f) {
        if (Mixer.getMixerHandle(n) == 0) {
            return false;
        }
        int[] nArray = Mixer.getRecordingVolume(n, n2, Mixer.isRecordingMixerMono(n));
        if (nArray.length < 2) {
            return false;
        }
        int[] nArray2 = Mixer.computingBalance(nArray[0], nArray[1], f);
        return Mixer.setRecordingVolume(n, nArray2[0], nArray2[1], n2, Mixer.isRecordingMixerMono(n));
    }

    private static int[] computingBalance(int n, int n2, float f) {
        int n3 = n < n2 ? n2 : n;
        if (f > 0.0f) {
            n2 = n3;
            n = (int)((float)n3 * (1.0f - f));
        } else if (f < 0.0f) {
            n = n3;
            n2 = (int)((float)n3 * (1.0f + f));
        } else {
            n = n3;
            n2 = n3;
        }
        return new int[]{n, n2};
    }

    public static boolean setMasterLeftChannelVolume(int n, int n2) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = n2;
        mIXERVOLUME.rightChannelVolume = Mixer.getMasterRightChannelVolume(n);
        return Extension.SetPlaybackVolume(n, 4, mIXERVOLUME, Mixer.isPlaybackMixerMono(n));
    }

    public static boolean setMasterRightChannelVolume(int n, int n2) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = Mixer.getMasterLeftChannelVolume(n);
        mIXERVOLUME.rightChannelVolume = n2;
        return Extension.SetPlaybackVolume(n, 4, mIXERVOLUME, Mixer.isPlaybackMixerMono(n));
    }

    public static boolean setLeftChannelVolume(int n, int n2, int n3) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = n3;
        mIXERVOLUME.rightChannelVolume = Mixer.getMasterRightChannelVolume(n);
        return Extension.SetPlaybackVolume(n, n2, mIXERVOLUME, Mixer.isPlaybackMixerMono(n));
    }

    public static boolean setRightChannelVolume(int n, int n2, int n3) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = Mixer.getMasterLeftChannelVolume(n);
        mIXERVOLUME.rightChannelVolume = n3;
        return Extension.SetPlaybackVolume(n, n2, mIXERVOLUME, Mixer.isPlaybackMixerMono(n));
    }

    public static boolean setPlaybackVolume(int n, int n2, int n3, int n4, boolean bl) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = n2;
        mIXERVOLUME.rightChannelVolume = n3;
        return Extension.SetPlaybackVolume(n, n4, mIXERVOLUME, bl);
    }

    public static boolean setMicrophoneVolume(int n, int n2) {
        return Mixer.setPlaybackVolume(n, 4099, n2, 0, Mixer.isPlaybackMixerMono(n));
    }

    public static int getMicrophoneVolume(int n) {
        int[] nArray = Mixer.getPlaybackVolume(n, 4099, Mixer.isPlaybackMixerMono(n));
        if (nArray.length == 0) {
            return 0;
        }
        return nArray[0];
    }

    public static boolean setMicrophoneRecordingVolume(int n, int n2) {
        return Mixer.setRecordingVolume(n, 4099, n2, 0, Mixer.isRecordingMixerMono(n));
    }

    public static boolean setRecordingVolume(int n, int n2, int n3, int n4, boolean bl) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        mIXERVOLUME.leftChannelVolume = n2;
        mIXERVOLUME.rightChannelVolume = n3;
        return Extension.SetRecordingVolume(n, n4, mIXERVOLUME, bl);
    }

    public static int getMicrophoneRecordingVolume(int n) {
        int[] nArray = Mixer.getRecordingVolume(n, 4099, Mixer.isRecordingMixerMono(n));
        if (nArray.length == 0) {
            return 0;
        }
        return nArray[0];
    }

    public static int[] getRecordingVolume(int n, int n2, boolean bl) {
        MIXERVOLUME mIXERVOLUME = new MIXERVOLUME();
        if (Extension.GetRecordingVolume(n, n2, mIXERVOLUME, bl)) {
            return new int[]{mIXERVOLUME.leftChannelVolume, mIXERVOLUME.rightChannelVolume};
        }
        return new int[0];
    }

    public static boolean setPlaybackMute(int n, int n2, boolean bl) {
        return Extension.SetMixerMute(n, 4, n2, bl);
    }

    public static boolean setMasterMute(int n, boolean bl) {
        return Extension.SetMixerMasterMute(Mixer.getMixerHandle(n), bl);
    }

    public static boolean isMasterMute(int n) {
        return Extension.IsMixerMasterMute(Mixer.getMixerHandle(n));
    }

    public static boolean isPlaybackMute(int n, int n2) {
        return Extension.IsMixerMute(n, 4, n2);
    }

    public static boolean setVolumePlaybackMute(int n, boolean bl) {
        return Mixer.setPlaybackMute(n, 4, bl);
    }

    public static boolean isVolumeMute(int n) {
        return Mixer.isPlaybackMute(n, 4);
    }

    public static boolean setMicrophoneMute(int n, boolean bl) {
        return Mixer.setPlaybackMute(n, 4099, bl);
    }

    public static boolean isMicrophoneMute(int n) {
        return Mixer.isPlaybackMute(n, 4099);
    }

    public static int getDestinLineIndex(int n, MixerLine mixerLine, int n2) {
        MixerCaps mixerCaps = Mixer.getMixerCaps(n);
        if (mixerCaps == null) {
            return -1;
        }
        int n3 = mixerCaps.getCDestinations();
        for (int i = 0; i < n3; ++i) {
            mixerLine.setCbStruct(MixerLine.sizeof);
            mixerLine.setDwSource(0);
            mixerLine.setDwDestination(i);
            if (!Mixer.mixerGetLineInfo(n, mixerLine, 0)) {
                return -1;
            }
            if (mixerLine.getDwComponentType() != n2) continue;
            return i;
        }
        return -1;
    }

    public static int getSourceLineIndex(int n, MixerLine mixerLine, int n2) {
        int n3 = mixerLine.getCConnections();
        int n4 = mixerLine.getDwDestination();
        for (int i = 0; i < n3; ++i) {
            mixerLine.setCbStruct(MixerLine.sizeof);
            mixerLine.setDwSource(i);
            mixerLine.setDwDestination(n4);
            if (!Mixer.mixerGetLineInfo(n, mixerLine, 1)) {
                return -1;
            }
            if (mixerLine.getDwComponentType() != n2) continue;
            return i;
        }
        return -1;
    }

    public static int getMixerLineChannels(int n, int n2, int n3) {
        MixerLine mixerLine = new MixerLine();
        if (Mixer.getDestinLineIndex(n, mixerLine, n2) > -1 && (n3 == 4 || Mixer.getSourceLineIndex(n, mixerLine, n3) > -1)) {
            return mixerLine.getCChannels();
        }
        return 0;
    }

    public static boolean containControlType(int n, int n2, int n3) {
        MixerLine mixerLine = new MixerLine();
        return Mixer.getDestinLineIndex(n, mixerLine, n2) != -1 && Mixer.getSourceLineIndex(n, mixerLine, n3) != -1;
    }
}

