/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.registry;

import java.util.Iterator;
import org.sf.feeling.swt.win32.extension.registry.KeyIterator;
import org.sf.feeling.swt.win32.extension.registry.RegistryValue;
import org.sf.feeling.swt.win32.extension.registry.RootKey;
import org.sf.feeling.swt.win32.extension.registry.ValueIterator;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class RegistryKey {
    private RootKey root = RootKey.HKEY_CURRENT_USER;
    private String path = "";

    public RegistryKey() {
    }

    public RegistryKey(RootKey rootKey) {
        this.root = rootKey;
    }

    public RegistryKey(String string) {
        this.path = string;
    }

    public RegistryKey(RootKey rootKey, String string) {
        this.root = rootKey;
        this.path = string;
    }

    public RootKey getRootKey() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.path.substring(1 + this.path.lastIndexOf("\\"));
    }

    public boolean exists() {
        return this.ExistsKey();
    }

    private native boolean ExistsKey();

    public void create() {
        this.CreateKey();
    }

    private native void CreateKey();

    public RegistryKey createSubkey(String string) {
        RegistryKey registryKey = new RegistryKey(this.root, this.path + "\\" + string);
        registryKey.create();
        return registryKey;
    }

    public void delete() {
        this.DeleteKey();
    }

    private native void DeleteKey();

    public boolean hasSubkeys() {
        return this.HasSubkeys();
    }

    private native boolean HasSubkeys();

    public boolean hasSubkey(String string) {
        RegistryKey registryKey = new RegistryKey(this.root, this.path + "\\" + string);
        return registryKey.exists();
    }

    public Iterator subkeys() {
        return new KeyIterator(this);
    }

    public RegistryKey getSubkey(String string) {
        if (this.hasSubkey(string)) {
            Iterator iterator = this.subkeys();
            while (iterator.hasNext()) {
                RegistryKey registryKey = (RegistryKey)iterator.next();
                if (!string.equals(registryKey.getName())) continue;
                return registryKey;
            }
        }
        return null;
    }

    public Iterator values() {
        return new ValueIterator(this);
    }

    public boolean hasValue(String string) {
        return this.HasKeyValue(string);
    }

    private native boolean HasKeyValue(String var1);

    public boolean hasValues() {
        return this.HasKeyValues();
    }

    private native boolean HasKeyValues();

    public RegistryValue getValue(String string) {
        return this.GetKeyValue(string);
    }

    private native RegistryValue GetKeyValue(String var1);

    public void setValue(RegistryValue registryValue) {
        this.SetKeyValue(registryValue);
    }

    private native void SetKeyValue(RegistryValue var1);

    public void deleteValue(String string) {
        this.DeleteKeyValue(string);
    }

    private native void DeleteKeyValue(String var1);

    public String toString() {
        return this.root.toString() + "\\" + this.path;
    }

    static {
        Extension.loadNativeLibrary("swt-extension-win32");
    }
}

