/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.ole.mediaplayer;

import java.io.File;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.widgets.Composite;
import org.sf.feeling.swt.win32.extension.ole.OleContainer;
import org.sf.feeling.swt.win32.extension.ole.OleHookInterceptor;
import org.sf.feeling.swt.win32.extension.ole.OleMsgHook;
import org.sf.feeling.swt.win32.extension.ole.mediaplayer.WMPMediaState;
import org.sf.feeling.swt.win32.extension.ole.mediaplayer.WMPPlaylistChangeEventType;
import org.sf.feeling.swt.win32.extension.ole.mediaplayer.listener.MediaPlayerEventListener;
import org.sf.feeling.swt.win32.extension.registry.RegistryKey;
import org.sf.feeling.swt.win32.extension.registry.RootKey;
import org.sf.feeling.swt.win32.internal.extension.util.ColorCache;

public class MediaPlayer
extends OleContainer {
    static final int WMPCOREEVENT_BASE = 5000;
    static final int DISPID_WMPCOREEVENT_OPENSTATECHANGE = 5001;
    static final int DISPID_WMPCOREEVENT_STATUSCHANGE = 5002;
    static final int WMPCOREEVENT_CONTROL_BASE = 5100;
    static final int DISPID_WMPCOREEVENT_PLAYSTATECHANGE = 5101;
    static final int DISPID_WMPCOREEVENT_AUDIOLANGUAGECHANGE = 5102;
    static final int WMPCOREEVENT_SEEK_BASE = 5200;
    static final int DISPID_WMPCOREEVENT_ENDOFSTREAM = 5201;
    static final int DISPID_WMPCOREEVENT_POSITIONCHANGE = 5202;
    static final int DISPID_WMPCOREEVENT_MARKERHIT = 5203;
    static final int DISPID_WMPCOREEVENT_DURATIONUNITCHANGE = 5204;
    static final int WMPCOREEVENT_CONTENT_BASE = 5300;
    static final int DISPID_WMPCOREEVENT_SCRIPTCOMMAND = 5301;
    static final int WMPCOREEVENT_NETWORK_BASE = 5400;
    static final int DISPID_WMPCOREEVENT_DISCONNECT = 5401;
    static final int DISPID_WMPCOREEVENT_BUFFERING = 5402;
    static final int DISPID_WMPCOREEVENT_NEWSTREAM = 5403;
    static final int WMPCOREEVENT_ERROR_BASE = 5500;
    static final int DISPID_WMPCOREEVENT_ERROR = 5501;
    static final int WMPCOREEVENT_WARNING_BASE = 5600;
    static final int DISPID_WMPCOREEVENT_WARNING = 5601;
    static final int WMPCOREEVENT_CDROM_BASE = 5700;
    static final int DISPID_WMPCOREEVENT_CDROMMEDIACHANGE = 5701;
    static final int WMPCOREEVENT_PLAYLIST_BASE = 5800;
    static final int DISPID_WMPCOREEVENT_PLAYLISTCHANGE = 5801;
    static final int DISPID_WMPCOREEVENT_MEDIACHANGE = 5802;
    static final int DISPID_WMPCOREEVENT_CURRENTMEDIAITEMAVAILABLE = 5803;
    static final int DISPID_WMPCOREEVENT_CURRENTPLAYLISTCHANGE = 5804;
    static final int DISPID_WMPCOREEVENT_CURRENTPLAYLISTITEMAVAILABLE = 5805;
    static final int DISPID_WMPCOREEVENT_CURRENTITEMCHANGE = 5806;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONCHANGE = 5807;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONATTRIBUTESTRINGADDED = 5808;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONATTRIBUTESTRINGREMOVED = 5809;
    static final int DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONCHANGE = 5810;
    static final int DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONPLAYLISTADDED = 5811;
    static final int DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONPLAYLISTREMOVED = 5812;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONCONTENTSCANADDEDITEM = 5813;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONCONTENTSCANPROGRESS = 5814;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONSEARCHFOUNDITEM = 5815;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONSEARCHPROGRESS = 5816;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONSEARCHCOMPLETE = 5817;
    static final int DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONPLAYLISTSETASDELETED = 5818;
    static final int DISPID_WMPCOREEVENT_MODECHANGE = 5819;
    static final int DISPID_WMPCOREEVENT_MEDIACOLLECTIONATTRIBUTESTRINGCHANGED = 5820;
    static final int DISPID_WMPCOREEVENT_MEDIAERROR = 5821;
    static final int DISPID_WMPCOREEVENT_DOMAINCHANGE = 5822;
    static final int DISPID_WMPCOREEVENT_OPENPLAYLISTSWITCH = 5823;
    static final int WMPOCXEVENT_BASE = 6500;
    static final int DISPID_WMPOCXEVENT_SWITCHEDTOPLAYERAPPLICATION = 6501;
    static final int DISPID_WMPOCXEVENT_SWITCHEDTOCONTROL = 6502;
    static final int DISPID_WMPOCXEVENT_PLAYERDOCKEDSTATECHANGE = 6503;
    static final int DISPID_WMPOCXEVENT_PLAYERRECONNECT = 6504;
    static final int DISPID_WMPOCXEVENT_CLICK = 6505;
    static final int DISPID_WMPOCXEVENT_DOUBLECLICK = 6506;
    static final int DISPID_WMPOCXEVENT_KEYDOWN = 6507;
    static final int DISPID_WMPOCXEVENT_KEYPRESS = 6508;
    static final int DISPID_WMPOCXEVENT_KEYUP = 6509;
    static final int DISPID_WMPOCXEVENT_MOUSEDOWN = 6510;
    static final int DISPID_WMPOCXEVENT_MOUSEMOVE = 6511;
    static final int DISPID_WMPOCXEVENT_MOUSEUP = 6512;
    static final int DISPID_WMPOCXEVENT_DEVICECONNECT = 6513;
    static final int DISPID_WMPOCXEVENT_DEVICEDISCONNECT = 6514;
    static final int DISPID_WMPOCXEVENT_DEVICESTATUSCHANGE = 6515;
    static final int DISPID_WMPOCXEVENT_DEVICESYNCSTATECHANGE = 6516;
    static final int DISPID_WMPOCXEVENT_DEVICESYNCERROR = 6517;
    static final int DISPID_WMPOCXEVENT_CREATEPARTNERSHIPCOMPLETE = 6518;
    protected OleFrame oleFrame = new OleFrame(this.container, 0);
    protected OleControlSite oleControlSite;
    protected boolean created = false;
    protected boolean activated = false;
    private CLabel errorLabel;
    private OleHookInterceptor interceptor;

    public static boolean canCreate() {
        RegistryKey registryKey = new RegistryKey(RootKey.HKEY_CLASSES_ROOT, "WMPlayer.OCX");
        if (!registryKey.exists()) {
            return false;
        }
        return registryKey.hasSubkey("CurVer");
    }

    public MediaPlayer(Composite composite) {
        this(composite, 262144, null);
    }

    public MediaPlayer(Composite composite, int n) {
        this(composite, n, null);
    }

    public MediaPlayer(Composite composite, int n, final MediaPlayerEventListener mediaPlayerEventListener) {
        super(composite, n);
        this.oleFrame.setLayoutData((Object)new GridData(1808));
        try {
            this.oleControlSite = new OleControlSite((Composite)this.oleFrame, 0, "WMPlayer.OCX");
            this.created = true;
            this.activate();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.oleFrame != null && !this.oleFrame.isDisposed()) {
                this.oleFrame.setVisible(false);
                ((GridData)this.oleFrame.getLayoutData()).exclude = true;
            }
            this.errorLabel = new CLabel(this.container, 0x1000000);
            this.errorLabel.setForeground(ColorCache.getInstance().getColor(255, 0, 0));
            this.errorLabel.setText("Create Media Player control failed.");
            this.errorLabel.setLayoutData((Object)new GridData(1808));
            this.container.layout();
            return;
        }
        final OleMsgHook oleMsgHook = new OleMsgHook(this);
        this.oleControlSite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                oleMsgHook.unInstallHook();
            }
        });
        oleMsgHook.installHook();
        if (mediaPlayerEventListener != null) {
            OleListener oleListener = new OleListener(){

                public void handleEvent(OleEvent oleEvent) {
                    switch (oleEvent.type) {
                        case 5001: {
                            mediaPlayerEventListener.openStateChange(WMPMediaState.getMediaState(oleEvent.arguments[0].getInt()));
                            break;
                        }
                        case 5101: {
                            mediaPlayerEventListener.playStateChange(WMPMediaState.getMediaState(oleEvent.arguments[0].getInt()));
                            break;
                        }
                        case 5102: {
                            mediaPlayerEventListener.audioLanguageChange(oleEvent.arguments[0].getInt());
                            break;
                        }
                        case 5002: {
                            mediaPlayerEventListener.statusChange();
                            break;
                        }
                        case 5301: {
                            mediaPlayerEventListener.scriptCommand(oleEvent.arguments[0].getString(), oleEvent.arguments[1].getString());
                            break;
                        }
                        case 5403: {
                            mediaPlayerEventListener.newStream();
                            break;
                        }
                        case 5401: {
                            mediaPlayerEventListener.disconnect(oleEvent.arguments[0].getInt());
                            break;
                        }
                        case 5402: {
                            mediaPlayerEventListener.buffering(oleEvent.arguments[0].getBoolean());
                            break;
                        }
                        case 5501: {
                            mediaPlayerEventListener.error();
                            break;
                        }
                        case 5601: {
                            mediaPlayerEventListener.warning(oleEvent.arguments[2].getInt(), oleEvent.arguments[0].getInt(), oleEvent.arguments[1].getString());
                            break;
                        }
                        case 5201: {
                            mediaPlayerEventListener.endOfStream(oleEvent.arguments[0].getInt());
                            break;
                        }
                        case 5202: {
                            mediaPlayerEventListener.positionChange(oleEvent.arguments[0].getDouble(), oleEvent.arguments[1].getDouble());
                            break;
                        }
                        case 5203: {
                            mediaPlayerEventListener.markerHit(oleEvent.arguments[0].getInt());
                            break;
                        }
                        case 5204: {
                            mediaPlayerEventListener.durationUnitChange(oleEvent.arguments[0].getInt());
                            break;
                        }
                        case 5701: {
                            mediaPlayerEventListener.cdromMediaChange(oleEvent.arguments[0].getInt());
                            break;
                        }
                        case 5801: {
                            mediaPlayerEventListener.playlistChange(oleEvent.arguments[0].getAutomation(), WMPPlaylistChangeEventType.getEventType(oleEvent.arguments[1].getInt()));
                            break;
                        }
                        case 5804: {
                            mediaPlayerEventListener.currentPlaylistChange(WMPPlaylistChangeEventType.getEventType(oleEvent.arguments[0].getInt()));
                            break;
                        }
                        case 5805: {
                            mediaPlayerEventListener.currentPlaylistItemAvailable(oleEvent.arguments[0].getString());
                            break;
                        }
                        case 5802: {
                            mediaPlayerEventListener.mediaChange(oleEvent.arguments[0].getAutomation());
                            break;
                        }
                        case 5803: {
                            mediaPlayerEventListener.currentMediaItemAvailable(oleEvent.arguments[0].getString());
                            break;
                        }
                        case 5806: {
                            mediaPlayerEventListener.currentItemChange(oleEvent.arguments[0].getAutomation());
                            break;
                        }
                        case 5807: {
                            mediaPlayerEventListener.mediaCollectionChange();
                            break;
                        }
                        case 5808: {
                            mediaPlayerEventListener.mediaCollectionAttributeStringAdded(oleEvent.arguments[0].getString(), oleEvent.arguments[1].getString());
                            break;
                        }
                        case 5809: {
                            mediaPlayerEventListener.mediaCollectionAttributeStringRemoved(oleEvent.arguments[0].getString(), oleEvent.arguments[1].getString());
                            break;
                        }
                        case 5820: {
                            mediaPlayerEventListener.mediaCollectionAttributeStringChanged(oleEvent.arguments[0].getString(), oleEvent.arguments[1].getString(), oleEvent.arguments[2].getString());
                            break;
                        }
                        case 5810: {
                            mediaPlayerEventListener.playlistCollectionChange();
                            break;
                        }
                        case 5811: {
                            mediaPlayerEventListener.playlistCollectionPlaylistAdded(oleEvent.arguments[0].getString());
                            break;
                        }
                        case 5812: {
                            mediaPlayerEventListener.playlistCollectionPlaylistRemoved(oleEvent.arguments[0].getString());
                            break;
                        }
                        case 5818: {
                            mediaPlayerEventListener.playlistCollectionPlaylistSetAsDeleted(oleEvent.arguments[0].getString(), oleEvent.arguments[1].getBoolean());
                            break;
                        }
                        case 5819: {
                            mediaPlayerEventListener.modeChange(oleEvent.arguments[0].getString(), oleEvent.arguments[1].getBoolean());
                            break;
                        }
                        case 5821: {
                            mediaPlayerEventListener.mediaError(oleEvent.arguments[0].getAutomation());
                            break;
                        }
                        case 5823: {
                            mediaPlayerEventListener.openPlaylistSwitch(oleEvent.arguments[0].getAutomation());
                            break;
                        }
                        case 5822: {
                            mediaPlayerEventListener.domainChange(oleEvent.arguments[0].getString());
                            break;
                        }
                        case 6501: {
                            mediaPlayerEventListener.switchedToPlayerApplication();
                            break;
                        }
                        case 6502: {
                            mediaPlayerEventListener.switchedToControl();
                            break;
                        }
                        case 6503: {
                            mediaPlayerEventListener.playerDockedStateChange();
                            break;
                        }
                        case 6504: {
                            mediaPlayerEventListener.playerReconnect();
                            break;
                        }
                        case 6505: {
                            mediaPlayerEventListener.click(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort(), oleEvent.arguments[2].getInt(), oleEvent.arguments[3].getInt());
                            break;
                        }
                        case 6506: {
                            mediaPlayerEventListener.doubleClick(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort(), oleEvent.arguments[2].getInt(), oleEvent.arguments[3].getInt());
                            break;
                        }
                        case 6507: {
                            mediaPlayerEventListener.keyDown(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort());
                            break;
                        }
                        case 6508: {
                            mediaPlayerEventListener.keyPress(oleEvent.arguments[0].getShort());
                            break;
                        }
                        case 6509: {
                            mediaPlayerEventListener.keyUp(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort());
                            break;
                        }
                        case 6510: {
                            mediaPlayerEventListener.mouseDown(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort(), oleEvent.arguments[2].getInt(), oleEvent.arguments[3].getInt());
                            break;
                        }
                        case 6511: {
                            mediaPlayerEventListener.mouseMove(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort(), oleEvent.arguments[2].getInt(), oleEvent.arguments[3].getInt());
                            break;
                        }
                        case 6512: {
                            mediaPlayerEventListener.mouseUp(oleEvent.arguments[0].getShort(), oleEvent.arguments[1].getShort(), oleEvent.arguments[2].getInt(), oleEvent.arguments[3].getInt());
                        }
                    }
                }
            };
            this.oleControlSite.addEventListener(5001, oleListener);
            this.oleControlSite.addEventListener(5101, oleListener);
            this.oleControlSite.addEventListener(5102, oleListener);
            this.oleControlSite.addEventListener(5002, oleListener);
            this.oleControlSite.addEventListener(5301, oleListener);
            this.oleControlSite.addEventListener(5403, oleListener);
            this.oleControlSite.addEventListener(5401, oleListener);
            this.oleControlSite.addEventListener(5402, oleListener);
            this.oleControlSite.addEventListener(5402, oleListener);
            this.oleControlSite.addEventListener(5402, oleListener);
            this.oleControlSite.addEventListener(5402, oleListener);
            this.oleControlSite.addEventListener(5501, oleListener);
            this.oleControlSite.addEventListener(5601, oleListener);
            this.oleControlSite.addEventListener(5201, oleListener);
            this.oleControlSite.addEventListener(5202, oleListener);
            this.oleControlSite.addEventListener(5203, oleListener);
            this.oleControlSite.addEventListener(5204, oleListener);
            this.oleControlSite.addEventListener(5701, oleListener);
            this.oleControlSite.addEventListener(5801, oleListener);
            this.oleControlSite.addEventListener(5804, oleListener);
            this.oleControlSite.addEventListener(5805, oleListener);
            this.oleControlSite.addEventListener(5802, oleListener);
            this.oleControlSite.addEventListener(5803, oleListener);
            this.oleControlSite.addEventListener(5806, oleListener);
            this.oleControlSite.addEventListener(5807, oleListener);
            this.oleControlSite.addEventListener(5808, oleListener);
            this.oleControlSite.addEventListener(5809, oleListener);
            this.oleControlSite.addEventListener(5820, oleListener);
            this.oleControlSite.addEventListener(5810, oleListener);
            this.oleControlSite.addEventListener(5811, oleListener);
            this.oleControlSite.addEventListener(5812, oleListener);
            this.oleControlSite.addEventListener(5818, oleListener);
            this.oleControlSite.addEventListener(5819, oleListener);
            this.oleControlSite.addEventListener(5821, oleListener);
            this.oleControlSite.addEventListener(5823, oleListener);
            this.oleControlSite.addEventListener(5822, oleListener);
            this.oleControlSite.addEventListener(6501, oleListener);
            this.oleControlSite.addEventListener(6502, oleListener);
            this.oleControlSite.addEventListener(6503, oleListener);
            this.oleControlSite.addEventListener(6504, oleListener);
            this.oleControlSite.addEventListener(6505, oleListener);
            this.oleControlSite.addEventListener(6506, oleListener);
            this.oleControlSite.addEventListener(6507, oleListener);
            this.oleControlSite.addEventListener(6508, oleListener);
            this.oleControlSite.addEventListener(6509, oleListener);
            this.oleControlSite.addEventListener(6510, oleListener);
            this.oleControlSite.addEventListener(6511, oleListener);
            this.oleControlSite.addEventListener(6512, oleListener);
        }
    }

    public boolean activate() {
        if (!this.created) {
            return false;
        }
        this.activated = this.oleControlSite.doVerb(-5) == 0;
        return this.activated;
    }

    public void addHookInterceptor(OleHookInterceptor oleHookInterceptor) {
        this.interceptor = oleHookInterceptor;
    }

    public void addPlayList(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            this.invokeOleFunction(new String[]{"currentPlaylist", "appendItem", "newMedia"}, (Object)fileArray[i].getAbsolutePath());
        }
    }

    public void closeMedia() {
        this.invokeOleFunction("close");
    }

    public void dispose() {
        if (this.activated) {
            this.oleControlSite.deactivateInPlaceClient();
            this.activated = false;
        }
        this.container.dispose();
    }

    public String getCurrentMediaSourceURL() {
        return (String)this.getOleProperty(new String[]{"currentMedia", "sourceURL"});
    }

    public String getCurrentMediaName() {
        return (String)this.getOleProperty(new String[]{"currentMedia", "name"});
    }

    public int getAbsolutePosition() {
        try {
            return (int)Math.round((Double)this.getOleProperty(new String[]{"controls", "currentPosition"}) * 1000.0);
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getDuration() {
        try {
            return (int)Math.round((Double)this.getOleProperty(new String[]{"currentMedia", "duration"}) * 1000.0);
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public OleHookInterceptor getHookInterceptor() {
        return this.interceptor;
    }

    public WMPMediaState getMediaState() {
        return WMPMediaState.getMediaState((Integer)this.getOleProperty("playState"));
    }

    public OleControlSite getOleControlSite() {
        if (!this.isActivated()) {
            return null;
        }
        return this.oleControlSite;
    }

    public OleFrame getOleFrame() {
        if (!this.isActivated()) {
            return null;
        }
        return this.oleFrame;
    }

    public int getPlayCount() {
        try {
            return (Integer)this.getOleProperty(new String[]{"settings", "playCount"});
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public float getPlaySpeedFactor() {
        try {
            return ((Double)this.getOleProperty(new String[]{"settings", "rate"})).floatValue();
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            return Float.NaN;
        }
    }

    public int getStereoBalance() {
        try {
            return (Integer)this.getOleProperty(new String[]{"settings", "balance"});
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getVolume() {
        try {
            return (Integer)this.getOleProperty(new String[]{"settings", "volume"});
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isAutoStart() {
        return Boolean.TRUE.equals(this.getOleProperty(new String[]{"settings", "autoStart"}));
    }

    public boolean isControlBarVisible() {
        return Boolean.TRUE.booleanValue() == "full".equals(this.getOleProperty("uiMode"));
    }

    public boolean isFullScreen() {
        return Boolean.TRUE.equals(this.getOleProperty("fullScreen"));
    }

    public boolean isMute() {
        return Boolean.TRUE.equals(this.getOleProperty(new String[]{"settings", "mute"}));
    }

    public boolean isPauseEnabled() {
        return Boolean.TRUE.equals(this.getOleProperty(new String[]{"controls", "isAvailable"}, (Object)"Pause"));
    }

    public boolean isPlayEnabled() {
        return Boolean.TRUE.equals(this.getOleProperty(new String[]{"controls", "isAvailable"}, (Object)"Play"));
    }

    public boolean isStopEnabled() {
        return Boolean.TRUE.equals(this.getOleProperty(new String[]{"controls", "isAvailable"}, (Object)"Stop"));
    }

    public boolean isStretchToFit() {
        return Boolean.TRUE.equals(this.getOleProperty("stretchToFit"));
    }

    public void load(String string) {
        this.setOleProperty("url", (Object)(string == null ? "" : string));
    }

    public void pause() {
        this.invokeOleFunction(new String[]{"controls", "Pause"});
    }

    public void play() {
        this.invokeOleFunction(new String[]{"controls", "Play"});
    }

    public void play(String string) {
        Object object = this.invokeOleFunctionWithResult("newMedia", (Object)string);
        this.setOleProperty("currentMedia", object);
        this.play();
    }

    public void playList(File[] fileArray) {
        this.addPlayList(fileArray);
        this.setMode("loop", true);
        this.play();
    }

    public void setAbsolutePosition(int n) {
        this.setOleProperty(new String[]{"controls", "currentPosition"}, (Object)new Double((double)n / 1000.0));
    }

    public void setAutoStart(boolean bl) {
        this.setOleProperty(new String[]{"settings", "autoStart"}, (Object)bl);
    }

    public void setControlBarVisible(boolean bl) {
        this.setOleProperty("uiMode", (Object)(bl ? "full" : "none"));
    }

    void setErrorDialogsEnabled(boolean bl) {
        this.setOleProperty(new String[]{"settings", "enableErrorDialogs"}, (Object)bl);
    }

    public void setFullScreen(boolean bl) {
        this.setOleProperty("fullScreen", (Object)bl);
    }

    public void setMode(String string, boolean bl) {
        this.invokeOleFunction(new String[]{"settings", "setMode"}, new Object[]{string, bl});
    }

    public void setMute(boolean bl) {
        this.setOleProperty(new String[]{"settings", "mute"}, (Object)bl);
    }

    public void setPlayCount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The play count must be strictly greater than 0");
        }
        this.setOleProperty(new String[]{"settings", "playCount"}, (Object)new Integer(n));
    }

    public void setPlaySpeedFactor(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("The rate must be strictly greater than 0!");
        }
        this.setOleProperty(new String[]{"settings", "rate"}, (Object)new Double(f));
    }

    public void setStereoBalance(int n) {
        if (n < 100 || n > 100) {
            throw new IllegalArgumentException("The stereo balance must be between -100 and 100");
        }
        this.setOleProperty(new String[]{"settings", "balance"}, (Object)new Integer(n));
    }

    public void setStretchToFit(boolean bl) {
        this.setOleProperty("stretchToFit", (Object)bl);
    }

    public void setVolume(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("The volume must be between 0 and 100");
        }
        this.setOleProperty(new String[]{"settings", "volume"}, (Object)new Integer(n));
    }

    public void stop() {
        this.invokeOleFunction(new String[]{"controls", "Stop"});
    }

    public void setErrorInfo(String string) {
        if (this.errorLabel != null && !this.errorLabel.isDisposed()) {
            this.errorLabel.setText(string);
        }
    }

    public void setErrorImage(Image image) {
        if (this.errorLabel != null && !this.errorLabel.isDisposed()) {
            this.errorLabel.setImage(image);
        }
    }

    public void setErrorFont(Font font) {
        if (this.errorLabel != null && !this.errorLabel.isDisposed()) {
            this.errorLabel.setFont(font);
        }
    }

    public void setErrorForeground(Color color) {
        if (this.errorLabel != null && !this.errorLabel.isDisposed()) {
            this.errorLabel.setForeground(color);
        }
    }

    public void setErrorBackground(Color color) {
        if (this.errorLabel != null && !this.errorLabel.isDisposed()) {
            this.errorLabel.setBackground(color);
        }
    }
}

