/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.ole;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleParameterDescription;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.sf.feeling.swt.win32.extension.ole.IOleComponent;
import org.sf.feeling.swt.win32.extension.ole.OleHookInterceptor;

public abstract class OleContainer
implements IOleComponent {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Composite container;
    private Map oleTypeToDescriptionMap;

    protected static Variant createVariant(Object object) {
        if (object instanceof Boolean) {
            return new Variant(((Boolean)object).booleanValue());
        }
        if (object instanceof Byte) {
            return new Variant((short)((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return new Variant(((Short)object).shortValue());
        }
        if (object instanceof Character) {
            return new Variant((int)((Character)object).charValue());
        }
        if (object instanceof Integer) {
            return new Variant(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new Variant(((Long)object).intValue());
        }
        if (object instanceof Float) {
            return new Variant(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return new Variant(((Double)object).doubleValue());
        }
        if (object instanceof String || object == null) {
            return new Variant((String)object);
        }
        if (object instanceof OleAutomation) {
            return new Variant((OleAutomation)object);
        }
        if (object instanceof Variant) {
            return (Variant)object;
        }
        throw new IllegalArgumentException("The value could not be converted to a Variant: " + object);
    }

    private static void dispose(Variant variant) {
        if (variant == null) {
            return;
        }
        variant.dispose();
    }

    protected static Object getVariantValue(Variant variant) {
        if (variant == null) {
            return null;
        }
        if ((variant.getType() & 0x4000) == 16384) {
            return variant;
        }
        switch (variant.getType()) {
            case 11: {
                return variant.getBoolean();
            }
            case 16: {
                return new Byte(variant.getByte());
            }
            case 2: {
                return new Short(variant.getShort());
            }
            case 18: {
                return new Character(variant.getChar());
            }
            case 3: {
                return new Integer(variant.getInt());
            }
            case 20: {
                return new Long(variant.getLong());
            }
            case 4: {
                return new Float(variant.getFloat());
            }
            case 5: {
                return new Double(variant.getDouble());
            }
            case 8: {
                return variant.getString();
            }
            case 9: {
                return variant.getAutomation();
            }
        }
        return variant;
    }

    public OleContainer(Composite composite, int n) {
        this.container = new Composite(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.container.setLayout((Layout)gridLayout);
    }

    public abstract void addHookInterceptor(OleHookInterceptor var1);

    public StringBuffer dumpOleInterfaceDefinitions() {
        Object object;
        this.oleTypeToDescriptionMap = new HashMap();
        Field[] fieldArray = OLE.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            object = fieldArray[i];
            String string = ((Field)object).getName();
            Short s = null;
            if (string.startsWith("VT_")) {
                try {
                    s = (Short)((Field)object).get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (s == null) continue;
            String string2 = string.substring("VT_".length()).toLowerCase(Locale.ENGLISH);
            this.oleTypeToDescriptionMap.put(s, string2);
        }
        OleAutomation oleAutomation = new OleAutomation((OleClientSite)this.getOleControlSite());
        object = new StringBuffer();
        this.dumpOleInterfaceDefinitions((StringBuffer)object, oleAutomation, 0);
        oleAutomation.dispose();
        return object;
    }

    private void dumpOleInterfaceDefinitions(StringBuffer stringBuffer, OleAutomation oleAutomation, int n) {
        String string;
        OleParameterDescription oleParameterDescription;
        OleFunctionDescription oleFunctionDescription;
        ArrayList<OleFunctionDescription> arrayList = new ArrayList<OleFunctionDescription>();
        int n2 = 0;
        while ((oleFunctionDescription = oleAutomation.getFunctionDescription(n2)) != null) {
            arrayList.add(oleFunctionDescription);
            ++n2;
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((OleFunctionDescription)object).name.toLowerCase(Locale.ENGLISH).compareTo(((OleFunctionDescription)object2).name.toLowerCase(Locale.ENGLISH));
            }
        });
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            int n3;
            oleFunctionDescription = (OleFunctionDescription)arrayList.get(n2);
            for (n3 = 0; n3 < n; ++n3) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(oleFunctionDescription.name).append("(");
            for (n3 = 0; n3 < oleFunctionDescription.args.length; ++n3) {
                oleParameterDescription = oleFunctionDescription.args[n3];
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getTypeDescription(oleParameterDescription.type)).append(' ').append(oleParameterDescription.name == null ? "arg" + n3 : oleParameterDescription.name);
            }
            stringBuffer.append("): ").append(this.getTypeDescription(oleFunctionDescription.returnType)).append(LINE_SEPARATOR);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n4 = 1;
        while ((string = oleAutomation.getName(n4)) != null) {
            arrayList2.add(string);
            ++n4;
        }
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().toLowerCase(Locale.ENGLISH).compareTo(object2.toString().toLowerCase(Locale.ENGLISH));
            }
        });
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            string = (String)arrayList2.get(n4);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(string).append(LINE_SEPARATOR);
            oleParameterDescription = oleAutomation.getProperty(oleAutomation.getIDsOfNames(new String[]{string})[0]);
            if (oleParameterDescription != null && oleParameterDescription.getType() == 9) {
                OleAutomation oleAutomation2 = oleParameterDescription.getAutomation();
                this.dumpOleInterfaceDefinitions(stringBuffer, oleAutomation2, n + 1);
                oleAutomation2.dispose();
            }
            OleContainer.dispose((Variant)oleParameterDescription);
        }
    }

    public Control getControl() {
        return this.container;
    }

    public abstract OleHookInterceptor getHookInterceptor();

    public abstract OleControlSite getOleControlSite();

    public abstract boolean isActivated();

    public Object getOleProperty(String string) {
        return this.getOleProperty(new String[]{string}, new Object[0]);
    }

    public Object getOleProperty(String string, Object object) {
        return this.getOleProperty(new String[]{string}, new Object[]{object});
    }

    public Object getOleProperty(String string, Object[] objectArray) {
        return this.getOleProperty(new String[]{string}, objectArray);
    }

    public Object getOleProperty(String[] stringArray) {
        return this.getOleProperty(stringArray, new Object[0]);
    }

    public Object getOleProperty(String[] stringArray, Object object) {
        return this.getOleProperty(stringArray, new Object[]{object});
    }

    public Object getOleProperty(String[] stringArray, Object[] objectArray) {
        if (!this.isActivated()) {
            return null;
        }
        OleAutomation oleAutomation = new OleAutomation((OleClientSite)this.getOleControlSite());
        for (int i = 0; i < stringArray.length; ++i) {
            Variant variant;
            int[] nArray = oleAutomation.getIDsOfNames(new String[]{stringArray[i]});
            if (nArray == null) {
                oleAutomation.dispose();
                return null;
            }
            if (i == stringArray.length - 1) {
                variant = new Variant[objectArray.length];
                for (int j = 0; j < objectArray.length; ++j) {
                    variant[j] = OleContainer.createVariant(objectArray[j]);
                }
                Variant variant2 = oleAutomation.getProperty(nArray[0], (Variant[])variant);
                for (int j = 0; j < ((Variant)variant).length; ++j) {
                    Variant variant3 = variant[j];
                    OleContainer.dispose(variant3);
                }
                Object object = OleContainer.getVariantValue(variant2);
                OleContainer.dispose(variant2);
                oleAutomation.dispose();
                return object;
            }
            variant = oleAutomation.getProperty(nArray[0]);
            OleAutomation oleAutomation2 = variant.getAutomation();
            variant.dispose();
            oleAutomation.dispose();
            oleAutomation = oleAutomation2;
        }
        oleAutomation.dispose();
        return null;
    }

    private String getTypeDescription(short s) {
        String string = (String)this.oleTypeToDescriptionMap.get(new Short(s));
        if (string == null) {
            string = "Unknown[" + String.valueOf(s) + ']';
        }
        return string;
    }

    public void invokeOleFunction(String string) {
        this.invokeOleFunction(new String[]{string}, new Object[0], false);
    }

    public void invokeOleFunction(String string, Object object) {
        this.invokeOleFunction(new String[]{string}, new Object[]{object}, false);
    }

    public void invokeOleFunction(String string, Object[] objectArray) {
        this.invokeOleFunction(new String[]{string}, objectArray, false);
    }

    public void invokeOleFunction(String[] stringArray) {
        this.invokeOleFunction(stringArray, new Object[0], false);
    }

    public void invokeOleFunction(String[] stringArray, Object object) {
        this.invokeOleFunction(stringArray, new Object[]{object}, false);
    }

    public void invokeOleFunction(String[] stringArray, Object[] objectArray) {
        if (!this.isActivated()) {
            return;
        }
        this.invokeOleFunction(stringArray, objectArray, false);
    }

    protected Object invokeOleFunction(String[] stringArray, Object[] objectArray, boolean bl) {
        if (!this.isActivated()) {
            return null;
        }
        OleAutomation oleAutomation = new OleAutomation((OleClientSite)this.getOleControlSite());
        for (int i = 0; i < stringArray.length; ++i) {
            Variant variant;
            int[] nArray = oleAutomation.getIDsOfNames(new String[]{stringArray[i]});
            if (nArray == null) {
                oleAutomation.dispose();
                return null;
            }
            if (i == stringArray.length - 1) {
                Object object;
                variant = new Variant[objectArray.length];
                for (int j = 0; j < objectArray.length; ++j) {
                    variant[j] = OleContainer.createVariant(objectArray[j]);
                }
                if (bl) {
                    Variant variant2 = oleAutomation.invoke(nArray[0], (Variant[])variant);
                    object = OleContainer.getVariantValue(variant2);
                    OleContainer.dispose(variant2);
                } else {
                    object = null;
                    oleAutomation.invokeNoReply(nArray[0], (Variant[])variant);
                }
                for (int j = 0; j < ((Variant)variant).length; ++j) {
                    Variant variant3 = variant[j];
                    OleContainer.dispose(variant3);
                }
                oleAutomation.dispose();
                return object;
            }
            variant = oleAutomation.getProperty(nArray[0]);
            OleAutomation oleAutomation2 = variant.getAutomation();
            variant.dispose();
            oleAutomation.dispose();
            oleAutomation = oleAutomation2;
        }
        oleAutomation.dispose();
        return null;
    }

    public Object invokeOleFunctionWithResult(String string) {
        return this.invokeOleFunction(new String[]{string}, new Object[0], true);
    }

    public Object invokeOleFunctionWithResult(String string, Object object) {
        return this.invokeOleFunction(new String[]{string}, new Object[]{object}, true);
    }

    public Object invokeOleFunctionWithResult(String string, Object[] objectArray) {
        return this.invokeOleFunction(new String[]{string}, objectArray, true);
    }

    public Object invokeOleFunctionWithResult(String[] stringArray) {
        return this.invokeOleFunction(stringArray, new Object[0], true);
    }

    public Object invokeOleFunctionWithResult(String[] stringArray, Object object) {
        return this.invokeOleFunction(stringArray, new Object[]{object}, true);
    }

    public Object invokeOleFunctionWithResult(String[] stringArray, Object[] objectArray) {
        return this.invokeOleFunction(stringArray, objectArray, true);
    }

    public boolean setOleProperty(String string, Object object) {
        return this.setOleProperty(new String[]{string}, new Object[]{object});
    }

    public boolean setOleProperty(String string, Object[] objectArray) {
        return this.setOleProperty(new String[]{string}, objectArray);
    }

    public boolean setOleProperty(String[] stringArray, Object object) {
        return this.setOleProperty(stringArray, new Object[]{object});
    }

    public boolean setOleProperty(String[] stringArray, Object[] objectArray) {
        if (!this.isActivated()) {
            return false;
        }
        OleAutomation oleAutomation = new OleAutomation((OleClientSite)this.getOleControlSite());
        for (int i = 0; i < stringArray.length; ++i) {
            Variant variant;
            int[] nArray = oleAutomation.getIDsOfNames(new String[]{stringArray[i]});
            if (nArray == null) {
                oleAutomation.dispose();
                return false;
            }
            if (i == stringArray.length - 1) {
                boolean bl;
                variant = new Variant[objectArray.length];
                for (bl = false; bl < objectArray.length; bl += 1) {
                    variant[bl] = OleContainer.createVariant(objectArray[bl]);
                }
                bl = oleAutomation.setProperty(nArray[0], (Variant[])variant);
                for (int j = 0; j < ((Variant)variant).length; ++j) {
                    Variant variant2 = variant[j];
                    OleContainer.dispose(variant2);
                }
                oleAutomation.dispose();
                return bl;
            }
            variant = oleAutomation.getProperty(nArray[0]);
            OleAutomation oleAutomation2 = variant.getAutomation();
            variant.dispose();
            oleAutomation.dispose();
            oleAutomation = oleAutomation2;
        }
        oleAutomation.dispose();
        return false;
    }
}

