/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;

public class PROCESSENTRY32
extends Structure {
    public DWORD dwSize = new DWORD(PROCESSENTRY32.sizeOf());
    public DWORD cntUsage = new DWORD(0);
    public DWORD th32ProcessID = new DWORD(0);
    public LONG th32DefaultHeapID = new LONG(0);
    public DWORD th32ModuleID = new DWORD(0);
    public DWORD cntThreads = new DWORD(0);
    public DWORD th32ParentProcessID = new DWORD(0);
    public LONG pcPriClassBase = new LONG(0);
    public DWORD dwFlags = new DWORD(0);
    public String szExeFile = "";

    public PROCESSENTRY32() throws NativeException {
        this.createPointer();
        this.resetPointer();
    }

    public PROCESSENTRY32(int n) throws NativeException {
        this();
        this.pointer.setMemory(Native.getMemory(n, PROCESSENTRY32.sizeOf()));
        this.getValueFromPointer();
    }

    public void resetPointer() throws NativeException {
        this.pointer.zeroMemory();
        this.pointer.setIntAt(0, this.dwSize.getValue());
    }

    public PROCESSENTRY32 getValue() {
        try {
            this.pointer.zeroMemory();
            int n = -4;
            this.pointer.setIntAt(n += 4, this.dwSize.getValue());
            this.pointer.setIntAt(n += 4, this.cntUsage.getValue());
            this.pointer.setIntAt(n += 4, this.th32ProcessID.getValue());
            this.pointer.setIntAt(n += 4, this.th32DefaultHeapID.getValue());
            this.pointer.setIntAt(n += 4, this.th32ModuleID.getValue());
            this.pointer.setIntAt(n += 4, this.cntThreads.getValue());
            this.pointer.setIntAt(n += 4, this.th32ParentProcessID.getValue());
            this.pointer.setIntAt(n += 4, this.pcPriClassBase.getValue());
            this.pointer.setIntAt(n += 4, this.dwFlags.getValue());
            this.pointer.setStringAt(n += 4, this.szExeFile);
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
        }
        return this;
    }

    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = Pointer.createPointer(PROCESSENTRY32.sizeOf());
        }
        return this.pointer;
    }

    public int getSizeOf() {
        return PROCESSENTRY32.sizeOf();
    }

    public Object getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.dwSize = new DWORD(this.getNextInt());
        this.cntUsage = new DWORD(this.getNextInt());
        this.th32ProcessID = new DWORD(this.getNextInt());
        this.th32DefaultHeapID = new LONG(this.getNextInt());
        this.th32ModuleID = new DWORD(this.getNextInt());
        this.cntThreads = new DWORD(this.getNextInt());
        this.th32ParentProcessID = new DWORD(this.getNextInt());
        this.pcPriClassBase = new LONG(this.getNextInt());
        this.dwFlags = new DWORD(this.getNextInt());
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.getNextByte();
            if (byArray[i] == 0) break;
        }
        this.szExeFile = new String(byArray).trim();
        this.offset = 0;
        return this;
    }

    public static int sizeOf() {
        return 296;
    }
}

