/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.GlobalMemoryBlock;

public class MemoryStatusEx
extends Structure {
    public int dwLength;
    public int dwMemoryLoad;
    public long ullTotalPhys;
    public long ullAvailPhys;
    public long ullTotalPageFile;
    public long ullAvailPageFile;
    public long ullTotalVirtual;
    public long ullAvailVirtual;
    public long ullAvailExtendedVirtual;

    public Object getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.dwLength = this.getNextInt();
        this.dwMemoryLoad = this.getNextInt();
        this.ullTotalPhys = this.getNextLong();
        this.ullAvailPhys = this.getNextLong();
        this.ullTotalPageFile = this.getNextLong();
        this.ullAvailPageFile = this.getNextLong();
        this.ullTotalVirtual = this.getNextLong();
        this.ullAvailVirtual = this.getNextLong();
        this.ullAvailExtendedVirtual = this.getNextLong();
        return this;
    }

    public MemoryStatusEx getValue() throws NativeException {
        return (MemoryStatusEx)this.getValueFromPointer();
    }

    public int getSizeOf() {
        return MemoryStatusEx.sizeOf();
    }

    public static int sizeOf() {
        return 64;
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(new GlobalMemoryBlock(MemoryStatusEx.sizeOf()));
        this.pointer.setIntAt(0, MemoryStatusEx.sizeOf());
        return this.pointer;
    }

    public String toString() {
        return "dwLength : " + this.dwLength + "\ndwMemoryLoad : " + this.dwMemoryLoad + "\nullTotalPhys : " + this.ullTotalPhys + "\nullAvailPhys : " + this.ullAvailPhys + "\nullTotalPageFile : " + this.ullTotalPageFile + "\nullAvailPageFile : " + this.ullAvailPageFile + "\nullTotalVirtual : " + this.ullTotalVirtual + "\nullAvailVirtual : " + this.ullAvailVirtual + "\nullAvailExtendedVirtual : " + this.ullAvailExtendedVirtual;
    }
}

