/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import java.util.LinkedList;
import org.sf.feeling.swt.win32.extension.jna.datatype.AbstractBasicData;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.NativeMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.IP_ADDR_STRING;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.TIME_T;

public class IP_ADAPTER_INFO
extends AbstractBasicData {
    public static final int MAX_ADAPTER_ADDRESS_LENGTH = 8;
    public static final int MAX_ADAPTER_DESCRIPTION_LENGTH = 128;
    public static final int MAX_ADAPTER_NAME_LENGTH = 256;
    private int Next;
    private DWORD ComboIndex = new DWORD(0);
    private String AdapterName;
    private String Description;
    private int AddressLength;
    private byte[] Address = new byte[8];
    private DWORD Index = new DWORD(0);
    private int Type;
    private int DhcpEnabled;
    private final Pointer CurrentIpAddress = NullPointer.NULL;
    private IP_ADDR_STRING IpAddressList;
    private IP_ADDR_STRING GatewayList;
    private IP_ADDR_STRING DhcpServer;
    private boolean HaveWins;
    private IP_ADDR_STRING PrimaryWinsServer;
    private IP_ADDR_STRING SecondaryWinsServer;
    private TIME_T LeaseObtained = new TIME_T(0);
    private TIME_T LeaseExpires = new TIME_T(0);

    public IP_ADAPTER_INFO() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    private IP_ADAPTER_INFO(int n) {
        super(null);
        this.pointer = new Pointer(new NativeMemoryBlock(n, this.getSizeOf()));
    }

    public static IP_ADAPTER_INFO fromAddress(int n) throws NativeException {
        return new IP_ADAPTER_INFO(n).getValue();
    }

    private IP_ADAPTER_INFO(boolean bl) {
        super(null);
        if (bl) {
            throw new IllegalArgumentException("Dummy must be false, AH! Ah! AH!");
        }
    }

    public static Pointer reserveMemoryOf_IP_ADAPTER_INFO(int n) throws NativeException {
        if (n < 1) {
            return NullPointer.NULL;
        }
        return new Pointer(MemoryBlockFactory.createMemoryBlock(n * new IP_ADAPTER_INFO(false).getSizeOf()));
    }

    public static IP_ADAPTER_INFO[] getListOf_IP_ADAPTER_INFO(Pointer pointer) throws NativeException {
        IP_ADAPTER_INFO iP_ADAPTER_INFO = new IP_ADAPTER_INFO(false);
        int n = pointer.getSize() / iP_ADAPTER_INFO.getSizeOf();
        if (n * iP_ADAPTER_INFO.getSizeOf() != pointer.getSize()) {
            throw new IllegalArgumentException("The pointer passed in has not a IP_ADAPTER_INFO size boundary " + pointer.getSize() + " vs. " + iP_ADAPTER_INFO.getSizeOf() + ". Call the other method if you are sure of what you are doing.");
        }
        return IP_ADAPTER_INFO.getListOf_IP_ADAPTER_INFO(pointer, n);
    }

    public static IP_ADAPTER_INFO[] getListOf_IP_ADAPTER_INFO(Pointer pointer, int n) throws NativeException {
        IP_ADAPTER_INFO iP_ADAPTER_INFO = new IP_ADAPTER_INFO(false);
        int n2 = n * iP_ADAPTER_INFO.getSizeOf();
        if (pointer.getSize() < n2) {
            throw new IllegalArgumentException("This pointer is addressing a too small memory region, size is " + pointer.getSize() + ", needed size is " + n2);
        }
        LinkedList<IP_ADAPTER_INFO> linkedList = new LinkedList<IP_ADAPTER_INFO>();
        int n3 = pointer.getPointer();
        for (int i = 0; n3 != 0 && i < n; ++i) {
            iP_ADAPTER_INFO = IP_ADAPTER_INFO.fromAddress(n3);
            linkedList.add(iP_ADAPTER_INFO);
            n3 = iP_ADAPTER_INFO.Next;
        }
        return linkedList.toArray(new IP_ADAPTER_INFO[0]);
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public int getSizeOf() {
        return 640;
    }

    private String getString(byte[] byArray, int n, int n2) {
        String string = new String(byArray, n, n2);
        int n3 = string.indexOf(0);
        if (n != -1) {
            string = string.substring(0, n3);
        }
        return string;
    }

    public Object getValueFromPointer() throws NativeException {
        int n = 0;
        byte[] byArray = this.pointer.getMemory();
        this.Next = this.pointer.getAsInt(n);
        this.ComboIndex.setValue(this.pointer.getAsInt(n += 4));
        this.AdapterName = this.getString(byArray, n += 4, 260);
        this.Description = this.getString(byArray, n += 260, 132);
        this.AddressLength = this.pointer.getAsInt(n += 132);
        System.arraycopy(byArray, n += 4, this.Address, 0, this.AddressLength);
        this.Index.setValue(this.pointer.getAsInt(n += 8));
        this.Type = this.pointer.getAsInt(n += 4);
        this.DhcpEnabled = this.pointer.getAsInt(n += 4);
        n += 4;
        this.IpAddressList = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (n += 4));
        this.GatewayList = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (n += this.IpAddressList.getSizeOf()));
        this.DhcpServer = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (n += this.GatewayList.getSizeOf()));
        this.HaveWins = this.pointer.getAsInt(n += this.DhcpServer.getSizeOf()) != 0;
        this.PrimaryWinsServer = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (n += 4));
        this.SecondaryWinsServer = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (n += this.PrimaryWinsServer.getSizeOf()));
        this.LeaseObtained = new TIME_T(this.pointer.getAsInt(n += this.SecondaryWinsServer.getSizeOf()));
        this.LeaseExpires = new TIME_T(this.pointer.getAsInt(n += 4));
        return this;
    }

    public IP_ADAPTER_INFO getValue() throws NativeException {
        return (IP_ADAPTER_INFO)this.getValueFromPointer();
    }

    public int getNext() {
        return this.Next;
    }

    public DWORD getComboIndex() {
        return this.ComboIndex;
    }

    public String getAdapterName() {
        return this.AdapterName;
    }

    public String getDescription() {
        return this.Description;
    }

    public int getAddressLength() {
        return this.AddressLength;
    }

    private String getHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        if (string.length() > n2) {
            return string.substring(string.length() - n2);
        }
        if (string.length() < n2) {
            int n3 = n2 - string.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return string;
    }

    public String getAddressAsWindowsFormat() {
        return (this.getHexString(this.Address[0], 2) + "-" + this.getHexString(this.Address[1], 2) + "-" + this.getHexString(this.Address[2], 2) + "-" + this.getHexString(this.Address[3], 2) + "-" + this.getHexString(this.Address[4], 2) + "-" + this.getHexString(this.Address[5], 2)).toUpperCase();
    }

    public String getAddressAsUnixFormat() {
        return (this.getHexString(this.Address[0], 2) + ":" + this.getHexString(this.Address[1], 2) + ":" + this.getHexString(this.Address[2], 2) + ":" + this.getHexString(this.Address[3], 2) + ":" + this.getHexString(this.Address[4], 2) + ":" + this.getHexString(this.Address[5], 2)).toUpperCase();
    }

    public byte[] getAddress() {
        return this.Address;
    }

    public DWORD getIndex() {
        return this.Index;
    }

    public int getType() {
        return this.Type;
    }

    public int getDhcpEnabled() {
        return this.DhcpEnabled;
    }

    public Pointer getCurrentIpAddress() {
        return this.CurrentIpAddress;
    }

    public IP_ADDR_STRING getIpAddressList() {
        return this.IpAddressList;
    }

    public IP_ADDR_STRING getGatewayList() {
        return this.GatewayList;
    }

    public IP_ADDR_STRING getDhcpServer() {
        return this.DhcpServer;
    }

    public boolean isHaveWins() {
        return this.HaveWins;
    }

    public IP_ADDR_STRING getPrimaryWinsServer() {
        return this.PrimaryWinsServer;
    }

    public IP_ADDR_STRING getSecondaryWinsServer() {
        return this.SecondaryWinsServer;
    }

    public TIME_T getLeaseObtained() {
        return this.LeaseObtained;
    }

    public TIME_T getLeaseExpires() {
        return this.LeaseExpires;
    }
}

