/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import java.util.StringTokenizer;
import org.sf.feeling.swt.win32.extension.jna.datatype.SHORT;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class GUID
extends Structure {
    public static final GUID GUID_IO_MEDIA_ARRIVAL = new GUID("A5DCBF10-6530-11D2-901F-00C04FB951ED");
    private DWORD data1 = new DWORD(0);
    private SHORT data2 = new SHORT(0);
    private SHORT data3 = new SHORT(0);
    private byte[] data4 = new byte[8];

    private String getHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        if (string.length() > n2) {
            return string.substring(string.length() - n2);
        }
        if (string.length() < n2) {
            int n3 = n2 - string.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        return (this.getHexString(this.data1.getValue(), 8) + "-" + this.getHexString(this.data2.getValue(), 4) + "-" + this.getHexString(this.data3.getValue(), 4) + "-" + this.getHexString(this.data4[0], 2) + this.getHexString(this.data4[1], 2) + "-" + this.getHexString(this.data4[2], 2) + this.getHexString(this.data4[3], 2) + this.getHexString(this.data4[4], 2) + this.getHexString(this.data4[5], 2) + this.getHexString(this.data4[6], 2) + this.getHexString(this.data4[7], 2)).toUpperCase();
    }

    public GUID() {
        this((GUID)null);
    }

    public GUID(String string) throws NumberFormatException {
        try {
            this.createPointer();
            if (string.matches("\\{[\\-0-9a-fA-F]+\\}")) {
                string = string.substring(1, string.length() - 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            this.data1.setValue((int)Long.parseLong(stringTokenizer.nextToken(), 16));
            this.data2.setValue(Short.parseShort(stringTokenizer.nextToken(), 16));
            this.data3.setValue(Short.parseShort(stringTokenizer.nextToken(), 16));
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.data4[0] = (byte)Short.parseShort(string2.substring(0, 2), 16);
            this.data4[1] = (byte)Short.parseShort(string2.substring(2), 16);
            for (int i = 0; i < 6; ++i) {
                this.data4[i + 2] = (byte)Short.parseShort(string3.substring(2 * i, 2 * i + 2), 16);
            }
            this.setValue(this);
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public GUID(GUID gUID) {
        super(gUID);
        try {
            this.createPointer();
            if (gUID != null) {
                this.data1.setValue(gUID.data1.getValue());
                this.data2.setValue(gUID.data2.getValue());
                this.data3.setValue(gUID.data3.getValue());
                System.arraycopy(gUID.data4, 0, this.data4, 0, 8);
                this.setValue(this);
            }
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public int getSizeOf() {
        return GUID.sizeOf();
    }

    public static int sizeOf() {
        return 16;
    }

    public Object getValueFromPointer() throws NativeException {
        this.data1.setValue(this.getNextInt());
        this.data2.setValue(this.getNextShort());
        this.data3.setValue(this.getNextShort());
        System.arraycopy(this.pointer.getMemory(), this.offset, this.data4, 0, 8);
        return this;
    }

    public GUID getValue() throws NativeException {
        return (GUID)this.getValueFromPointer();
    }

    public void setValue(GUID gUID) throws NativeException {
        int n = 0;
        n += this.pointer.setIntAt(n, gUID.data1.getValue());
        n += this.pointer.setShortAt(n, gUID.data2.getValue());
        n += this.pointer.setShortAt(n, gUID.data3.getValue());
        for (int i = 0; i < 8; ++i) {
            n += this.pointer.setByteAt(n, gUID.data4[i]);
        }
    }

    public void setValue(byte[] byArray, int n) throws NativeException {
        byte[] byArray2 = this.pointer.getMemory();
        System.arraycopy(byArray, n, byArray2, 0, 16);
        this.pointer.setMemory(byArray2);
        this.getValueFromPointer();
    }

    public static GUID fromPointer(Pointer pointer) throws NativeException {
        GUID gUID = new GUID();
        gUID.pointer = pointer;
        return gUID.getValue();
    }
}

