/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.HANDLE;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.DEV_BROADCAST_HDR;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.GUID;

public class DEV_BROADCAST_HANDLE
extends DEV_BROADCAST_HDR {
    private HANDLE dbch_handle = new HANDLE(0);
    private HANDLE dbch_hdevnotify = new HANDLE(0);
    private LONG dbch_nameoffset = new LONG(0);
    private GUID dbch_eventguid = new GUID();
    private LONG dbch_data = new LONG(0);

    public DEV_BROADCAST_HANDLE(Pointer pointer) {
        super(pointer);
        try {
            this.dbch_eventguid = new GUID();
            this.getValueFromPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public DEV_BROADCAST_HANDLE(int n, GUID gUID) {
        this.dbch_devicetype = new DWORD(n);
        this.dbch_eventguid = new GUID(gUID);
        try {
            this.createPointer();
            int n2 = 0;
            n2 += this.pointer.setIntAt(n2, this.dbch_size.getValue());
            n2 += this.pointer.setIntAt(n2, this.dbch_devicetype.getValue());
            n2 += this.pointer.setIntAt(n2, this.dbch_reserved.getValue());
            n2 += this.pointer.setIntAt(n2, this.dbch_handle.getValue());
            n2 += this.pointer.setIntAt(n2, this.dbch_hdevnotify.getValue());
            Pointer pointer = this.dbch_eventguid.getPointer();
            for (int i = 0; i < 16; ++i) {
                byte by = pointer.getAsByte(i);
                this.pointer.setByteAt(n2++, by);
            }
            n2 += this.pointer.setIntAt(n2, this.dbch_nameoffset.getValue());
            n2 += this.pointer.setByteAt(n2, ((Integer)this.dbch_data.getValueFromPointer()).byteValue());
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
        }
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public static int getSize() {
        return 41;
    }

    public int getSizeOf() {
        return this.dbch_size.getValue();
    }

    public Object getValueFromPointer() throws NativeException {
        this.offset = 0;
        super.getValueFromPointer();
        this.dbch_handle.setValue(this.getNextInt());
        this.dbch_hdevnotify.setValue(this.getNextInt());
        this.dbch_eventguid.setValue(this.pointer.getMemory(), this.offset);
        this.offset += 16;
        this.dbch_nameoffset.setValue(this.getNextInt());
        this.dbch_data.setValue(this.getNextByte());
        return this;
    }

    public DEV_BROADCAST_HANDLE getValue() throws NativeException {
        return (DEV_BROADCAST_HANDLE)this.getValueFromPointer();
    }

    public HANDLE getDbch_handle() {
        return this.dbch_handle;
    }

    public HANDLE getDbch_hdevnotify() {
        return this.dbch_hdevnotify;
    }

    public GUID getDbch_eventguid() {
        return this.dbch_eventguid;
    }

    public LONG getDbch_nameoffset() {
        return this.dbch_nameoffset;
    }

    public LONG getDbch_data() {
        return this.dbch_data;
    }
}

