/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32;

import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.win32.Kernel32;

public class WindowVersion {
    private static DWORD dword = null;
    private static boolean m_bSupportsUnicode = false;
    private static boolean m_bSupportsNewVersion = false;

    public String toString() {
        String string = "Windows Version Info:\n";
        try {
            string = string + "Major Version: " + WindowVersion.getMajorVersion() + "\n";
            string = string + "Minor Version: " + WindowVersion.getMinorVersion() + "\n";
            string = string + "Build: " + WindowVersion.getBuild() + "\n";
            string = string + "NT: " + WindowVersion.isNT() + "\n";
            string = string + "Supports Unicode: " + WindowVersion.supportsUnicode() + "\n";
            string = string + "Supports new version: " + WindowVersion.supportsNewVersion() + "\n";
            return string;
        }
        catch (NativeException nativeException) {
            return nativeException.toString();
        }
    }

    public static boolean supportsUnicode() {
        return m_bSupportsUnicode;
    }

    public static boolean supportsNewVersion() {
        return m_bSupportsNewVersion;
    }

    public static boolean isNT() throws NativeException {
        return (WindowVersion.getBuild() & Integer.MIN_VALUE) == 0;
    }

    public static int getMajorVersion() throws NativeException {
        if (dword != null) {
            return dword.getPointer().getAsByte(0);
        }
        return -1;
    }

    public static int getMinorVersion() throws NativeException {
        if (dword != null) {
            return dword.getPointer().getAsByte(1);
        }
        return -1;
    }

    public static int getBuild() throws NativeException {
        if (dword != null) {
            return dword.getPointer().getAsShort(2);
        }
        return -1;
    }

    static {
        try {
            dword = Kernel32.GetVersion();
            if (WindowVersion.isNT()) {
                m_bSupportsUnicode = true;
                if (WindowVersion.getMajorVersion() >= 5) {
                    m_bSupportsNewVersion = true;
                }
            } else if (WindowVersion.getMajorVersion() == 4 && WindowVersion.getMinorVersion() == 90) {
                m_bSupportsNewVersion = true;
            }
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }
}

