/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32;

import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.Type;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.HANDLE;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class PsAPI {
    public static final String DLL_NAME = "PSAPI.DLL";

    public static boolean EnumProcesses(int n, DWORD dWORD, DWORD dWORD2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "EnumProcesses");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n);
        native_.setParameter(1, dWORD.getValue());
        native_.setParameter(2, dWORD2.getPointer().getPointer());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static int[] EnumProcess(int n) throws NativeException, IllegalAccessException {
        if (n < 4) {
            n = 4;
        }
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(n));
        DWORD dWORD = new DWORD(0);
        if (!PsAPI.EnumProcesses(pointer.getPointer(), new DWORD(n), dWORD)) {
            return null;
        }
        int n2 = dWORD.getValue();
        if (n2 >= n) {
            System.err.println(n + " is to low, will recall with " + (n2 + 1024));
            return PsAPI.EnumProcess(n2 + 1024);
        }
        int n3 = dWORD.getValue() / 4;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = pointer.getAsInt(i * 4);
        }
        pointer.dispose();
        return nArray;
    }

    public static Pointer EnumProcessModules(HANDLE hANDLE, int n) throws NativeException, IllegalAccessException {
        if (n < 4) {
            n = 4;
        }
        Native native_ = new Native(DLL_NAME, "EnumProcessModules");
        native_.setRetVal(Type.INT);
        LONG lONG = new LONG(0);
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(n));
        native_.setParameter(0, hANDLE.getValue());
        native_.setParameter(1, pointer);
        native_.setParameter(2, n);
        native_.setParameter(3, lONG.getPointer());
        native_.invoke();
        int n2 = lONG.getValue();
        if (native_.getRetValAsInt() == 0) {
            pointer.dispose();
            return NullPointer.NULL;
        }
        if (n2 > n) {
            pointer.dispose();
            System.err.println(n + " is to low, will recall with " + n2);
            return PsAPI.EnumProcessModules(hANDLE, n2);
        }
        return pointer;
    }

    public static String GetModuleBaseName(HANDLE hANDLE, int n, int n2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetModuleBaseNameA");
        native_.setRetVal(Type.INT);
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(n2 + 1));
        native_.setParameter(0, hANDLE.getValue());
        native_.setParameter(1, n);
        native_.setParameter(2, pointer);
        native_.setParameter(3, n2);
        native_.invoke();
        String string = null;
        if (native_.getRetValAsInt() != 0) {
            string = pointer.getAsString();
        }
        pointer.dispose();
        return string;
    }
}

