/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32;

import org.sf.feeling.swt.win32.extension.jna.Callback;
import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.Type;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONGLONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.HANDLE;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.HeapMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.MemoryStatusEx;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.PROCESSENTRY32;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.SECURITY_ATTRIBUTES;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.SYSTEMTIME;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.SYSTEM_INFO;
import org.sf.feeling.swt.win32.internal.extension.DISKFREESPACE;

public class Kernel32 {
    public static final String DLL_NAME = "Kernel32.dll";
    public static final DWORD IOCTL_STORAGE_EJECT_MEDIA = new DWORD(2967560);
    public static final int TH32CS_SNAPHEAPLIST = 1;
    public static final int TH32CS_SNAPPROCESS = 2;
    public static final int TH32CS_SNAPTHREAD = 4;
    public static final int TH32CS_SNAPMODULE = 8;
    public static final int TH32CS_SNAPALL = 15;
    public static final int PAGE_NOACCESS = 1;
    public static final int PAGE_EXECUTE_READ = 32;
    public static final int PAGE_EXECUTE_READWRITE = 64;
    public static final int MEM_COMMIT = 4096;
    public static final int MEM_RESERVE = 8192;
    public static final int MEM_RELEASE = 32768;
    public static final int PAGE_READONLY = 2;
    public static final int PAGE_READWRITE = 4;
    public static final int PAGE_WRITECOPY = 8;
    public static final int PAGE_EXECUTE = 16;
    public static final int PAGE_EXECUTE_WRITECOPY = 128;
    public static final int PAGE_GUARD = 256;
    public static final int PAGE_NOCACHE = 512;
    private static Native WaitForSingleObjectEx = null;
    private static Native WaitForMultipleObjectsEx = null;
    public static final int DELETE = 65536;
    public static final int READ_CONTROL = 131072;
    public static final int SYNCHRONIZE = 0x100000;
    public static final int WRITE_DAC = 262144;
    public static final int WRITE_OWNER = 524288;
    public static final int PROCESS_ALL_ACCESS = 0x1F0FFF;
    public static final int PROCESS_CREATE_PROCESS = 128;
    public static final int PROCESS_CREATE_THREAD = 2;
    public static final int PROCESS_DUP_HANDLE = 64;
    public static final int PROCESS_QUERY_INFORMATION = 1024;
    public static final int PROCESS_QUERY_LIMITED_INFORMATION = 4096;
    public static final int PROCESS_SET_QUOTA = 256;
    public static final int PROCESS_SET_INFORMATION = 512;
    public static final int PROCESS_SUSPEND_RESUME = 2048;
    public static final int PROCESS_TERMINATE = 1;
    public static final int PROCESS_VM_OPERATION = 8;
    public static final int PROCESS_VM_READ = 16;
    public static final int PROCESS_VM_WRITE = 32;

    public static boolean SetFileAttributes(String string, DWORD dWORD) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "SetFileAttributesA");
        int n = 0;
        native_.setRetVal(Type.INT);
        Pointer pointer = Pointer.createPointerFromString(string);
        native_.setParameter(n++, pointer.getPointer());
        native_.setParameter(n++, dWORD.getValue());
        native_.invoke();
        pointer.dispose();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean VirtualProtect(int n, int n2, DWORD dWORD, DWORD dWORD2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "VirtualProtect");
        int n3 = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n3++, n);
        native_.setParameter(n3++, n2);
        native_.setParameter(n3++, dWORD.getValue());
        native_.setParameter(n3++, dWORD2.getPointer());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean VirtualFreeEx(HANDLE hANDLE, int n, int n2, DWORD dWORD) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "VirtualFreeEx");
        int n3 = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n3++, hANDLE.getValue());
        native_.setParameter(n3++, n);
        native_.setParameter(n3++, n2);
        native_.setParameter(n3++, dWORD.getValue());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean GetExitCodeThread(HANDLE hANDLE, DWORD dWORD) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetExitCodeThread");
        int n = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n++, hANDLE.getValue());
        native_.setParameter(n++, dWORD.getPointer());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean Process32Next(HANDLE hANDLE, PROCESSENTRY32 pROCESSENTRY32) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "Process32Next");
        int n = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n++, hANDLE.getValue());
        native_.setParameter(n++, pROCESSENTRY32.getPointer().getPointer());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean Process32First(HANDLE hANDLE, PROCESSENTRY32 pROCESSENTRY32) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "Process32First");
        int n = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n++, hANDLE.getValue());
        native_.setParameter(n++, pROCESSENTRY32.getPointer().getPointer());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static HANDLE CreateToolhelp32Snapshot(int n, int n2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "CreateToolhelp32Snapshot");
        int n3 = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n3++, n);
        native_.setParameter(n3++, n2);
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static int VirtualQuery(int n, int n2, int n3) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "VirtualQuery");
        int n4 = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n4++, n);
        native_.setParameter(n4++, n2);
        native_.setParameter(n4++, n3);
        native_.invoke();
        return native_.getRetValAsInt();
    }

    public static int GetProcAddress(HANDLE hANDLE, String string) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetProcAddress");
        int n = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n++, hANDLE.getValue());
        native_.setParameter(n++, string);
        native_.invoke();
        return native_.getRetValAsInt();
    }

    public static int VirtualAllocEx(HANDLE hANDLE, int n, int n2, DWORD dWORD, DWORD dWORD2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "VirtualAllocEx");
        int n3 = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n3++, hANDLE.getValue());
        native_.setParameter(n3++, n);
        native_.setParameter(n3++, n2);
        native_.setParameter(n3++, dWORD.getValue());
        native_.setParameter(n3++, dWORD2.getValue());
        native_.invoke();
        return native_.getRetValAsInt();
    }

    public static HANDLE CreateRemoteThread(HANDLE hANDLE, SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES, int n, int n2, int n3, DWORD dWORD, DWORD dWORD2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "CreateRemoteThread");
        int n4 = 0;
        native_.setRetVal(Type.INT);
        native_.setParameter(n4++, hANDLE.getValue());
        native_.setParameter(n4++, sECURITY_ATTRIBUTES == null ? NullPointer.NULL : sECURITY_ATTRIBUTES.getPointer());
        native_.setParameter(n4++, n);
        native_.setParameter(n4++, n2);
        native_.setParameter(n4++, n3);
        native_.setParameter(n4++, dWORD.getValue());
        native_.setParameter(n4++, dWORD2.getPointer().getPointer());
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static HANDLE LoadLibrary(String string) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "LoadLibraryA");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, string);
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static boolean SetPriorityClass(HANDLE hANDLE, DWORD dWORD) throws NativeException, IllegalAccessException {
        Native native_ = null;
        native_ = new Native(DLL_NAME, "SetPriorityClass");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.setParameter(1, dWORD.getValue());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean Beep(DWORD dWORD, DWORD dWORD2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "Beep");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, dWORD.getValue());
        native_.setParameter(1, dWORD2.getValue());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static void RtlMoveMemory(int n, int n2, int n3) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "RtlMoveMemory");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n);
        native_.setParameter(1, n2);
        native_.setParameter(2, n3);
        native_.invoke();
    }

    public static int GlobalFree(int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalFree");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n);
        native_.invoke();
        return native_.getRetValAsInt();
    }

    public static int GlobalAlloc(int n, int n2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalAlloc");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n2);
        native_.setParameter(1, n);
        native_.invoke();
        return native_.getRetValAsInt();
    }

    public static int GlobalLock(int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalLock");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n);
        native_.invoke();
        int n2 = native_.getRetValAsInt();
        return n2;
    }

    public static boolean GlobalUnlock(int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalUnlock");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n);
        native_.invoke();
        int n2 = native_.getRetValAsInt();
        return n2 != 0;
    }

    public static int GetModuleHandle(String string) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetModuleHandleA");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, string);
        native_.invoke();
        int n = native_.getRetValAsInt();
        return n;
    }

    public static DWORD GetCurrentThreadId() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetCurrentThreadId");
        native_.setRetVal(Type.INT);
        native_.invoke();
        int n = native_.getRetValAsInt();
        return new DWORD(n);
    }

    public static boolean DeviceIoControl(HANDLE hANDLE, DWORD dWORD, Pointer pointer, DWORD dWORD2, Pointer pointer2, DWORD dWORD3, Pointer pointer3, Pointer pointer4) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "DeviceIoControl");
        native_.setRetVal(Type.INT);
        int n = 0;
        Pointer pointer5 = null;
        native_.setParameter(n++, hANDLE.getValue());
        native_.setParameter(n++, dWORD.getValue());
        native_.setParameter(n++, pointer);
        native_.setParameter(n++, dWORD2.getValue());
        native_.setParameter(n++, pointer2);
        native_.setParameter(n++, dWORD3.getValue());
        if (pointer4 instanceof NullPointer && pointer3 instanceof NullPointer) {
            System.err.println("lpOverlapped is NullPointer, lpBytesReturned must not be NullPointer!");
            pointer5 = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
            native_.setParameter(n++, pointer5);
        } else {
            native_.setParameter(n++, pointer3);
        }
        native_.setParameter(n++, pointer4);
        native_.invoke();
        n = native_.getRetValAsInt();
        if (pointer5 != null) {
            pointer5.dispose();
        }
        return n != 0;
    }

    public static int GlobalDeleteAtom(int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalDeleteAtom");
        native_.setRetVal(Type.INT);
        int n2 = 0;
        native_.setParameter(n2++, n);
        native_.invoke();
        n2 = native_.getRetValAsInt();
        return n2;
    }

    public static int GlobalAddAtom(String string) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalAddAtomA");
        native_.setRetVal(Type.INT);
        int n = 0;
        native_.setParameter(n++, string);
        native_.invoke();
        n = native_.getRetValAsInt();
        return n;
    }

    public static DWORD GetVersion() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetVersion");
        native_.setRetVal(Type.INT);
        native_.invoke();
        return new DWORD(native_.getRetValAsInt());
    }

    public static HANDLE GetCurrentProcess() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetCurrentProcess");
        native_.setRetVal(Type.INT);
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static boolean ReadProcessMemory(HANDLE hANDLE, int n, Pointer pointer, int n2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "ReadProcessMemory");
        native_.setRetVal(Type.INT);
        int n3 = 0;
        native_.setParameter(n3++, hANDLE.getValue());
        native_.setParameter(n3++, n);
        native_.setParameter(n3++, pointer);
        native_.setParameter(n3++, n2);
        native_.setParameter(n3++, 0);
        native_.invoke();
        n3 = native_.getRetValAsInt();
        return n3 != 0;
    }

    public static boolean WriteProcessMemory(HANDLE hANDLE, int n, Pointer pointer, int n2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "WriteProcessMemory");
        native_.setRetVal(Type.INT);
        int n3 = 0;
        native_.setParameter(n3++, hANDLE.getValue());
        native_.setParameter(n3++, n);
        native_.setParameter(n3++, pointer);
        native_.setParameter(n3++, n2);
        native_.setParameter(n3++, 0);
        native_.invoke();
        n3 = native_.getRetValAsInt();
        return n3 != 0;
    }

    public static final MemoryStatusEx GlobalMemoryStatusEx() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GlobalMemoryStatusEx");
        native_.setRetVal(Type.INT);
        MemoryStatusEx memoryStatusEx = new MemoryStatusEx();
        native_.setParameter(0, memoryStatusEx.createPointer());
        native_.invoke();
        if (native_.getRetValAsInt() == 0) {
            throw new NativeException("The function call has failed. To get extended error information, call GetLastError.");
        }
        return memoryStatusEx.getValue();
    }

    public static final boolean SetFilePointerEx(HANDLE hANDLE, LONGLONG lONGLONG, LONGLONG lONGLONG2, MoveMode moveMode) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "SetFilePointerEx");
        native_.setRetVal(Type.INT);
        int n = 0;
        native_.setParameter(n++, hANDLE.getValue());
        native_.setParameter(n++, Type.LONG, "" + lONGLONG.getValue());
        native_.setParameter(n++, lONGLONG2.getPointer());
        native_.setParameter(n++, moveMode.getValue());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static final boolean ReadFile(HANDLE hANDLE, Pointer pointer, int n, DWORD dWORD, Pointer pointer2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "ReadFile");
        native_.setRetVal(Type.INT);
        int n2 = 0;
        native_.setParameter(n2++, hANDLE.getValue());
        native_.setParameter(n2++, pointer);
        native_.setParameter(n2++, n);
        native_.setParameter(n2++, dWORD.getPointer());
        native_.setParameter(n2++, pointer2);
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static final boolean WriteFile(HANDLE hANDLE, Pointer pointer, int n, DWORD dWORD, Pointer pointer2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "WriteFile");
        native_.setRetVal(Type.INT);
        int n2 = 0;
        native_.setParameter(n2++, hANDLE.getValue());
        native_.setParameter(n2++, pointer);
        native_.setParameter(n2++, n);
        native_.setParameter(n2++, dWORD.getPointer());
        native_.setParameter(n2++, pointer2);
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static final HANDLE CreateFile(String string, int n, int n2, SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES, int n3, int n4, int n5) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "CreateFileA");
        native_.setRetVal(Type.INT);
        int n6 = 0;
        native_.setParameter(n6++, Type.STRING, string);
        native_.setParameter(n6++, Type.INT, "" + n);
        native_.setParameter(n6++, Type.INT, "" + n2);
        native_.setParameter(n6++, sECURITY_ATTRIBUTES == null ? NullPointer.NULL : sECURITY_ATTRIBUTES.getPointer());
        native_.setParameter(n6++, Type.INT, "" + n3);
        native_.setParameter(n6++, Type.INT, "" + n4);
        native_.setParameter(n6++, Type.INT, "" + n5);
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static final HANDLE CreateFile(String string, AccessMask accessMask, ShareMode shareMode, SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES, CreationDisposition creationDisposition, FileAttribute fileAttribute, int n) throws NativeException, IllegalAccessException {
        return Kernel32.CreateFile(string, accessMask.getValue(), shareMode.getValue(), sECURITY_ATTRIBUTES, creationDisposition.getValue(), fileAttribute.getValue(), n);
    }

    public static final int GetLastError() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetLastError");
        native_.setRetVal(Type.INT);
        native_.invoke();
        return native_.getRetValAsInt();
    }

    public static final SYSTEM_INFO GetNativeSystemInfo() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetNativeSystemInfo");
        Pointer pointer = new Pointer(new HeapMemoryBlock(36));
        native_.setParameter(0, pointer);
        native_.invoke();
        SYSTEM_INFO sYSTEM_INFO = new SYSTEM_INFO(pointer);
        pointer.dispose();
        return sYSTEM_INFO;
    }

    public static final String GetComputerName() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetComputerNameA");
        int n = 0;
        native_.setRetVal(Type.INT);
        Pointer pointer = new Pointer(new HeapMemoryBlock(1024));
        LONG lONG = new LONG(1024);
        native_.setParameter(n++, pointer);
        native_.setParameter(n++, lONG.createPointer());
        native_.invoke();
        int n2 = native_.getRetValAsInt();
        if (n2 == 0) {
            throw new NativeException("GetComputerNameA failed call GetLastError()");
        }
        String string = pointer.getAsString().substring(0, lONG.getValue());
        pointer.dispose();
        return string;
    }

    public static final String GetShortPathName(String string) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetShortPathNameA");
        native_.setRetVal(Type.INT);
        int n = 0;
        Pointer pointer = new Pointer(new HeapMemoryBlock(1024));
        LONG lONG = new LONG(1024);
        native_.setParameter(n++, Type.STRING, string);
        native_.setParameter(n++, pointer);
        native_.setParameter(n++, lONG.createPointer());
        native_.invoke();
        int n2 = native_.getRetValAsInt();
        if (n2 == 0) {
            throw new NativeException("GetShortPathNameA failed call GetLastError()");
        }
        String string2 = pointer.getAsString();
        pointer.dispose();
        return string2;
    }

    public static final DISKFREESPACE GetDiskFreeSpaceEx(String string) throws NativeException, IllegalAccessException {
        if (string == null) {
            throw new NullPointerException("The drive name cannot be null !");
        }
        LONGLONG lONGLONG = new LONGLONG(0L);
        LONGLONG lONGLONG2 = new LONGLONG(0L);
        LONGLONG lONGLONG3 = new LONGLONG(0L);
        int n = 0;
        Native native_ = new Native(DLL_NAME, "GetDiskFreeSpaceExA");
        native_.setRetVal(Type.INT);
        native_.setParameter(n++, Type.STRING, string);
        native_.setParameter(n++, lONGLONG.createPointer());
        native_.setParameter(n++, lONGLONG2.createPointer());
        native_.setParameter(n++, lONGLONG3.createPointer());
        native_.invoke();
        DISKFREESPACE dISKFREESPACE = new DISKFREESPACE();
        dISKFREESPACE.freeBytesAvailable = lONGLONG.getValue();
        dISKFREESPACE.totalNumberOfBytes = lONGLONG2.getValue();
        dISKFREESPACE.totalNumberOfFreeBytes = lONGLONG3.getValue();
        return dISKFREESPACE;
    }

    public static HANDLE OpenProcess(int n, boolean bl, int n2) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "OpenProcess");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, n);
        native_.setParameter(1, bl ? 1 : 0);
        native_.setParameter(2, n2);
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static boolean CloseHandle(HANDLE hANDLE) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "CloseHandle");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static boolean TerminateProcess(HANDLE hANDLE, int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "TerminateProcess");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.setParameter(1, n);
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static void SetLastError(int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "SetLastError");
        native_.setParameter(0, n);
        native_.invoke();
    }

    public static HANDLE CreateFileMapping(HANDLE hANDLE, SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES, PageAccess pageAccess, DWORD dWORD, DWORD dWORD2, String string) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "CreateFileMappingA");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.setParameter(1, sECURITY_ATTRIBUTES == null ? NullPointer.NULL : sECURITY_ATTRIBUTES.getPointer());
        native_.setParameter(2, pageAccess.getValue());
        native_.setParameter(3, dWORD.getValue());
        native_.setParameter(4, dWORD2.getValue());
        native_.setParameter(5, string);
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static LONG MapViewOfFileEx(HANDLE hANDLE, FileMap fileMap, DWORD dWORD, DWORD dWORD2, DWORD dWORD3, LONG lONG) throws IllegalAccessException, NativeException {
        Native native_ = new Native(DLL_NAME, "MapViewOfFileEx");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.setParameter(1, fileMap.getValue());
        native_.setParameter(2, dWORD.getValue());
        native_.setParameter(3, dWORD2.getValue());
        native_.setParameter(4, dWORD3.getValue());
        native_.setParameter(5, lONG.getValue());
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static boolean IsBadReadPtr(Pointer pointer) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "IsBadReadPtr");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, pointer.getPointer());
        native_.setParameter(1, pointer.getSize());
        native_.invoke();
        return native_.getRetValAsInt() == 0;
    }

    public static boolean UnmapViewOfFile(LONG lONG) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "UnmapViewOfFile");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, lONG.getValue());
        native_.invoke();
        return !"0".equals(native_.getRetVal());
    }

    public static boolean SetConsoleCtrlHandler(Callback callback, boolean bl) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "SetConsoleCtrlHandler");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, callback.getCallbackAddress());
        native_.setParameter(1, bl ? "1" : "0");
        native_.invoke();
        return native_.getRetValAsInt() != 0;
    }

    public static final HANDLE FindFirstChangeNotification(String string, boolean bl, DWORD dWORD) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "FindFirstChangeNotificationA");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, string);
        native_.setParameter(1, bl ? -1 : 0);
        native_.setParameter(2, dWORD.getValue());
        native_.invoke();
        return new HANDLE(native_.getRetValAsInt());
    }

    public static final boolean FindNextChangeNotification(HANDLE hANDLE) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "FindNextChangeNotification");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.invoke();
        return native_.getRetValAsInt() == 0;
    }

    public static final boolean FindCloseChangeNotification(HANDLE hANDLE) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "FindCloseChangeNotification");
        native_.setRetVal(Type.INT);
        native_.setParameter(0, hANDLE.getValue());
        native_.invoke();
        return native_.getRetValAsInt() == 0;
    }

    public static final int WaitForSingleObjectEx(HANDLE hANDLE, DWORD dWORD, boolean bl) throws NativeException, IllegalAccessException {
        if (WaitForSingleObjectEx == null) {
            WaitForSingleObjectEx = new Native(DLL_NAME, "WaitForSingleObjectEx");
            WaitForSingleObjectEx.setRetVal(Type.INT);
        }
        WaitForSingleObjectEx.setParameter(0, hANDLE.getValue());
        WaitForSingleObjectEx.setParameter(1, dWORD.getValue());
        WaitForSingleObjectEx.setParameter(2, bl ? -1 : 0);
        WaitForSingleObjectEx.invoke();
        return WaitForSingleObjectEx.getRetValAsInt();
    }

    public static final int WaitForMultipleObjectsEx(DWORD dWORD, HANDLE[] hANDLEArray, boolean bl, DWORD dWORD2, boolean bl2) throws NativeException, IllegalAccessException {
        if (WaitForMultipleObjectsEx == null) {
            WaitForMultipleObjectsEx = new Native(DLL_NAME, "WaitForMultipleObjectsEx");
            WaitForMultipleObjectsEx.setRetVal(Type.INT);
        }
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(4 * hANDLEArray.length));
        for (int i = 0; i < hANDLEArray.length; ++i) {
            pointer.setIntAt(i * 4, hANDLEArray[i].getValue());
        }
        WaitForMultipleObjectsEx.setParameter(0, dWORD.getValue());
        WaitForMultipleObjectsEx.setParameter(1, pointer);
        WaitForMultipleObjectsEx.setParameter(2, bl ? -1 : 0);
        WaitForMultipleObjectsEx.setParameter(3, dWORD2.getValue());
        WaitForMultipleObjectsEx.setParameter(4, bl2 ? -1 : 0);
        WaitForMultipleObjectsEx.invoke();
        pointer.dispose();
        return WaitForMultipleObjectsEx.getRetValAsInt();
    }

    public static SYSTEMTIME GetSystemTime() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetSystemTime");
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        native_.setParameter(0, sYSTEMTIME.getPointer());
        native_.invoke();
        return sYSTEMTIME.getValue();
    }

    public static boolean SetLocaleTime(SYSTEMTIME sYSTEMTIME) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "SetLocalTime");
        sYSTEMTIME.setValueToPointer();
        native_.setParameter(0, sYSTEMTIME.getPointer());
        native_.invoke();
        return !"0".equals(native_.getRetVal());
    }

    public static SYSTEMTIME GetLocalTime() throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetLocalTime");
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        native_.setParameter(0, sYSTEMTIME.getPointer());
        native_.invoke();
        return sYSTEMTIME.getValue();
    }

    public static class CodePage {
        public static CodePage FCP_ACP = new CodePage(0);
        public static CodePage FCP_OEMCP = new CodePage(1);
        public static CodePage FCP_MACCP = new CodePage(2);
        public static CodePage FCP_THREAD_ACP = new CodePage(3);
        public static CodePage FCP_SYMBOL = new CodePage(42);
        public static CodePage FCP_UTF7 = new CodePage(65000);
        public static CodePage FCP_UTF8 = new CodePage(65001);
        private final int value;

        private CodePage(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class FileFlags {
        public static FileFlags FILE_FLAG_DELETE_ON_CLOSE = new FileFlags(0x4000000);
        public static FileFlags FILE_FLAG_NO_BUFFERING = new FileFlags(0x20000000);
        public static FileFlags FILE_FLAG_OVERLAPPED = new FileFlags(0x40000000);
        public static FileFlags FILE_FLAG_POSIX_SEMANTICS = new FileFlags(0x1000000);
        public static FileFlags FILE_FLAG_RANDOM_ACCESS = new FileFlags(0x10000000);
        public static FileFlags FILE_FLAG_SEQUENTIAL_SCAN = new FileFlags(0x8000000);
        public static FileFlags FILE_FLAG_WRITE_THROUGH = new FileFlags(Integer.MIN_VALUE);
        int value;

        private FileFlags(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class FileAttribute {
        public static FileAttribute FILE_ATTRIBUTE_READONLY = new FileAttribute(1);
        public static FileAttribute FILE_ATTRIBUTE_HIDDEN = new FileAttribute(2);
        public static FileAttribute FILE_ATTRIBUTE_SYSTEM = new FileAttribute(4);
        public static FileAttribute FILE_ATTRIBUTE_DIRECTORY = new FileAttribute(16);
        public static FileAttribute FILE_ATTRIBUTE_ARCHIVE = new FileAttribute(32);
        public static FileAttribute FILE_ATTRIBUTE_DEVICE = new FileAttribute(64);
        public static FileAttribute FILE_ATTRIBUTE_NORMAL = new FileAttribute(128);
        public static FileAttribute FILE_ATTRIBUTE_TEMPORARY = new FileAttribute(256);
        public static FileAttribute FILE_ATTRIBUTE_SPARSE_FILE = new FileAttribute(512);
        public static FileAttribute FILE_ATTRIBUTE_REPARSE_POINT = new FileAttribute(1024);
        public static FileAttribute FILE_ATTRIBUTE_COMPRESSED = new FileAttribute(2048);
        public static FileAttribute FILE_ATTRIBUTE_OFFLINE = new FileAttribute(4096);
        public static FileAttribute FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = new FileAttribute(8192);
        public static FileAttribute FILE_ATTRIBUTE_ENCRYPTED = new FileAttribute(16384);
        public static FileAttribute FILE_ATTRIBUTE_VALID_FLAGS = new FileAttribute(32695);
        public static FileAttribute FILE_ATTRIBUTE_VALID_SET_FLAGS = new FileAttribute(12711);
        private int fileAttribute;

        private FileAttribute(int n) {
            this.fileAttribute = n;
        }

        public int getValue() {
            return this.fileAttribute;
        }
    }

    public static class PageAccess {
        public static PageAccess PAGE_NOACCESS = new PageAccess(1);
        public static PageAccess PAGE_READONLY = new PageAccess(2);
        public static PageAccess PAGE_READWRITE = new PageAccess(4);
        public static PageAccess PAGE_WRITECOPY = new PageAccess(8);
        public static PageAccess PAGE_EXECUTE = new PageAccess(16);
        public static PageAccess PAGE_EXECUTE_READ = new PageAccess(32);
        public static PageAccess PAGE_EXECUTE_READWRITE = new PageAccess(64);
        public static PageAccess PAGE_EXECUTE_WRITECOPY = new PageAccess(128);
        public static PageAccess PAGE_GUARD = new PageAccess(256);
        public static PageAccess PAGE_NOCACHE = new PageAccess(512);
        public static PageAccess PAGE_WRITECOMBINE = new PageAccess(1024);
        int value;
        private int pageAccess;

        private PageAccess(int n) {
            this.pageAccess = n;
        }

        public int getValue() {
            return this.pageAccess;
        }
    }

    public static class CreationDisposition {
        public static CreationDisposition CREATE_NEW = new CreationDisposition(1);
        public static CreationDisposition CREATE_ALWAYS = new CreationDisposition(2);
        public static CreationDisposition OPEN_EXISTING = new CreationDisposition(3);
        public static CreationDisposition OPEN_ALWAYS = new CreationDisposition(4);
        public static CreationDisposition TRUNCATE_EXISTING = new CreationDisposition(5);
        int value;
        private int creationDisposition;

        private CreationDisposition(int n) {
            this.creationDisposition = n;
        }

        public int getValue() {
            return this.creationDisposition;
        }
    }

    public static class MoveMode {
        public static MoveMode FILE_BEGIN = new MoveMode(0);
        public static MoveMode FILE_CURRENT = new MoveMode(1);
        public static MoveMode FILE_END = new MoveMode(2);
        int value;
        private int moveMode;

        private MoveMode(int n) {
            this.moveMode = n;
        }

        public int getValue() {
            return this.moveMode;
        }
    }

    public static class ShareMode {
        private int shareMode;
        public static ShareMode FILE_SHARE_READ = new ShareMode(1);
        public static ShareMode FILE_SHARE_WRITE = new ShareMode(2);
        public static ShareMode FILE_SHARE_DELETE = new ShareMode(4);
        public static ShareMode FILE_SHARE_VALID_FLAGS = new ShareMode(7);

        private ShareMode(int n) {
            this.shareMode = n;
        }

        public int getValue() {
            return this.shareMode;
        }
    }

    public static class AccessMask {
        private int accessMask;
        public static AccessMask FILE_READ_DATA = new AccessMask(1);
        public static AccessMask FILE_LIST_DIRECTORY = new AccessMask(1);
        public static AccessMask FILE_WRITE_DATA = new AccessMask(2);
        public static AccessMask FILE_ADD_FILE = new AccessMask(2);
        public static AccessMask FILE_APPEND_DATA = new AccessMask(4);
        public static AccessMask FILE_ADD_SUBDIRECTORY = new AccessMask(4);
        public static AccessMask FILE_READ_EA = new AccessMask(8);
        public static AccessMask FILE_WRITE_EA = new AccessMask(16);
        public static AccessMask FILE_EXECUTE = new AccessMask(32);
        public static AccessMask FILE_TRAVERSE = new AccessMask(32);
        public static AccessMask FILE_DELETE_CHILD = new AccessMask(64);
        public static AccessMask FILE_READ_ATTRIBUTES = new AccessMask(128);
        public static AccessMask FILE_WRITE_ATTRIBUTES = new AccessMask(256);
        public static AccessMask DELETE = new AccessMask(65536);
        public static AccessMask READ_CONTROL = new AccessMask(131072);
        public static AccessMask WRITE_DAC = new AccessMask(262144);
        public static AccessMask WRITE_OWNER = new AccessMask(524288);
        public static AccessMask SYNCHRONIZE = new AccessMask(0x100000);
        public static AccessMask STANDARD_RIGHTS_READ = new AccessMask(131072);
        public static AccessMask STANDARD_RIGHTS_WRITE = new AccessMask(131072);
        public static AccessMask STANDARD_RIGHTS_EXECUTE = new AccessMask(131072);
        public static AccessMask STANDARD_RIGHTS_REQUIRED = new AccessMask(983040);
        public static AccessMask STANDARD_RIGHTS_ALL = new AccessMask(0x1F0000);
        public static AccessMask ACCESS_SYSTEM_SECURITY = new AccessMask(0x1000000);
        public static AccessMask MAXIMUM_ALLOWED = new AccessMask(0x2000000);
        public static AccessMask GENERIC_ALL = new AccessMask(0x10000000);
        public static AccessMask GENERIC_EXECUTE = new AccessMask(0x20000000);
        public static AccessMask GENERIC_WRITE = new AccessMask(0x40000000);
        public static AccessMask GENERIC_READ = new AccessMask(Integer.MIN_VALUE);

        private AccessMask(int n) {
            this.accessMask = n;
        }

        public int getValue() {
            return this.accessMask;
        }
    }

    public static class FileMap {
        public static FileMap FILE_MAP_ALL_ACCESS = new FileMap(983071);
        public static FileMap FILE_MAP_READ = new FileMap(4);
        public static FileMap FILE_MAP_WRITE = new FileMap(2);
        public static FileMap FILE_MAP_COPY = new FileMap(1);
        private final int value;

        private FileMap(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }
    }
}

