/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32;

import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.Type;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.IP_ADAPTER_INFO;

public class Iphlpapi {
    public static final String DLL_NAME = "Iphlpapi.dll";

    public static IP_ADAPTER_INFO[] GetAdaptersInfo(int n) throws NativeException, IllegalAccessException {
        Native native_ = new Native(DLL_NAME, "GetAdaptersInfo");
        native_.setRetVal(Type.INT);
        if (n < 1) {
            return null;
        }
        Pointer pointer = IP_ADAPTER_INFO.reserveMemoryOf_IP_ADAPTER_INFO(n);
        native_.setParameter(0, pointer);
        LONG lONG = new LONG(pointer.getSize());
        native_.setParameter(1, lONG.getPointer());
        native_.invoke();
        int n2 = native_.getRetValAsInt();
        switch (n2) {
            case 0: {
                break;
            }
            case 111: {
                throw new NativeException("ERROR_BUFFER_OVERFLOW: need a buffer of _" + lONG.getValue() + "Bytes");
            }
            case 13: {
                throw new NativeException("ERROR_INVALID_DATA: Invalid adapter information was retrieved.");
            }
            case 87: {
                throw new NativeException("ERROR_INVALID_PARAMETER: One of the parameters is invalid. This error is returned if the pOutBufLen parameter is a NULL pointer, or the calling process does not have read/write access to the memory pointed to by pOutBufLen or the calling process does not have write access to the memory pointed to by the pAdapterInfo parameter.");
            }
            case 232: {
                throw new NativeException("ERROR_NO_DATA: No adapter information exists for the local computer.");
            }
            case 50: {
                throw new RuntimeException("ERROR_NOT_SUPPORTED: The GetAdaptersInfo function is not supported by the operating system running on the local computer.");
            }
            default: {
                System.err.println("Unknown return code " + lONG.getValue() + "  " + pointer.getSize());
                throw new RuntimeException("Unknown return code " + n2);
            }
        }
        if (lONG.getValue() != pointer.getSize()) {
            System.err.println("GetAdaptersInfo : Not enougth size ?");
        }
        return IP_ADAPTER_INFO.getListOf_IP_ADAPTER_INFO(pointer);
    }

    public static interface Error {
        public static final int ERROR_SUCCESS = 0;
        public static final int ERROR_BUFFER_OVERFLOW = 111;
        public static final int ERROR_INVALID_DATA = 13;
        public static final int ERROR_INVALID_PARAMETER = 87;
        public static final int ERROR_NO_DATA = 232;
        public static final int ERROR_NOT_SUPPORTED = 50;
    }
}

