/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna;

public class StructConverter {
    private StructConverter() {
    }

    public static long parseLong(String string) {
        return StructConverter.parseHex(string, 16);
    }

    public static int parseInt(String string) {
        return (int)StructConverter.parseHex(string, 8);
    }

    public static short parseShort(String string) {
        return (short)StructConverter.parseHex(string, 4);
    }

    private static long parseHex(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            throw new NumberFormatException("unable to parse: '" + string + "' (too many digits)");
        }
        int n3 = 0;
        long l = 0L;
        for (int i = n2 - 1; i >= 0; --i) {
            int n4 = Character.digit(string.charAt(i), 16);
            if (n4 < 0) {
                throw new NumberFormatException("unable to parse: '" + string + "' (invalid char at pos: " + i + ")");
            }
            l += (long)n4 << n3;
            n3 += 4;
        }
        return l;
    }

    public static long bytesIntoLong(byte[] byArray, int n) {
        int n2 = StructConverter.bytesIntoInt(byArray, n);
        int n3 = StructConverter.bytesIntoInt(byArray, n + 4);
        return ((long)n3 << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    public static double bytesIntoDouble(byte[] byArray, int n) {
        double d = Double.longBitsToDouble(StructConverter.bytesIntoLong(byArray, n));
        return d;
    }

    public static float bytesIntoFloat(byte[] byArray, int n) {
        float f = Float.intBitsToFloat(StructConverter.bytesIntoInt(byArray, n));
        return f;
    }

    public static boolean bytesIntoBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static int bytesIntoInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        return n2;
    }

    public static short bytesIntoShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        return (short)n2;
    }

    public static int longIntoBytes(long l, byte[] byArray, int n) {
        byArray[n++] = (byte)l;
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 56);
        return n;
    }

    public static int floatIntoBytes(float f, byte[] byArray, int n) {
        int n2 = Float.floatToIntBits(f);
        byArray[n++] = (byte)n2;
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 24);
        return n;
    }

    public static int doubleIntoBytes(double d, byte[] byArray, int n) {
        long l = Double.doubleToLongBits(d);
        byArray[n++] = (byte)l;
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 56);
        return n;
    }

    public static int intIntoBytes(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 24);
        return n2;
    }

    public static final byte[] getBytes(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        return byArray;
    }

    public static int shortIntoBytes(short s, byte[] byArray, int n) {
        byArray[n++] = (byte)s;
        byArray[n++] = (byte)(s >>> 8);
        return n;
    }

    public static int byteArrayIntoBytes(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return n + byArray.length;
    }

    public static short swapShort(short s) {
        return (short)((s & 0xFF) << 8 | (s & 0xFF00) >>> 8);
    }

    public static int swapInt(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int swapByte(byte by) {
        return by & 0xFF;
    }
}

