/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.Constants;
import org.apache.commons.csv.Quote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final char delimiter;
    private final Character quoteChar;
    private final Quote quotePolicy;
    private final Character commentStart;
    private final Character escape;
    private final boolean ignoreSurroundingSpaces;
    private final boolean ignoreEmptyLines;
    private final String recordSeparator;
    private final String nullToString;
    private final String[] header;
    public static final CSVFormat RFC4180 = CSVFormat.newBuilder().withIgnoreEmptyLines(false).build();
    public static final CSVFormat DEFAULT = CSVFormat.newBuilder().build();
    public static final CSVFormat EXCEL = CSVFormat.newBuilder().withIgnoreEmptyLines(false).build();
    public static final CSVFormat TDF = CSVFormat.newBuilder().withDelimiter('\t').withIgnoreSurroundingSpaces(true).build();
    public static final CSVFormat MYSQL = CSVFormat.newBuilder().withDelimiter('\t').withQuoteChar(null).withEscape('\\').withIgnoreEmptyLines(false).withRecordSeparator('\n').build();

    static boolean isLineBreak(Character c) {
        return c != null && CSVFormat.isLineBreak(c.charValue());
    }

    public static CSVFormatBuilder newBuilder() {
        return new CSVFormatBuilder(',', Constants.DOUBLE_QUOTE_CHAR, null, null, null, false, true, "\r\n", "", null);
    }

    static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    public static CSVFormatBuilder newBuilder(char delimiter) {
        return new CSVFormatBuilder(delimiter);
    }

    public static CSVFormatBuilder newBuilder(CSVFormat format) {
        return new CSVFormatBuilder(format);
    }

    CSVFormat(char delimiter, Character quoteChar, Quote quotePolicy, Character commentStart, Character escape, boolean ignoreSurroundingSpaces, boolean ignoreEmptyLines, String recordSeparator, String nullToString, String[] header) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        this.delimiter = delimiter;
        this.quoteChar = quoteChar;
        this.quotePolicy = quotePolicy;
        this.commentStart = commentStart;
        this.escape = escape;
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.recordSeparator = recordSeparator;
        this.nullToString = nullToString;
        this.header = header == null ? null : (String[])header.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVFormat other = (CSVFormat)obj;
        if (this.delimiter != other.delimiter) {
            return false;
        }
        if (this.quotePolicy != other.quotePolicy) {
            return false;
        }
        if (this.quoteChar == null ? other.quoteChar != null : !this.quoteChar.equals(other.quoteChar)) {
            return false;
        }
        if (this.commentStart == null ? other.commentStart != null : !this.commentStart.equals(other.commentStart)) {
            return false;
        }
        if (this.escape == null ? other.escape != null : !this.escape.equals(other.escape)) {
            return false;
        }
        if (!Arrays.equals(this.header, other.header)) {
            return false;
        }
        if (this.ignoreSurroundingSpaces != other.ignoreSurroundingSpaces) {
            return false;
        }
        if (this.ignoreEmptyLines != other.ignoreEmptyLines) {
            return false;
        }
        return !(this.recordSeparator == null ? other.recordSeparator != null : !this.recordSeparator.equals(other.recordSeparator));
    }

    public String format(Object ... values) {
        StringWriter out = new StringWriter();
        try {
            new CSVPrinter(out, this).printRecord(values);
            return out.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Character getCommentStart() {
        return this.commentStart;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Character getEscape() {
        return this.escape;
    }

    String[] getHeader() {
        return this.header;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public String getNullToString() {
        return this.nullToString;
    }

    public Character getQuoteChar() {
        return this.quoteChar;
    }

    public Quote getQuotePolicy() {
        return this.quotePolicy;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delimiter;
        result = 31 * result + (this.quotePolicy == null ? 0 : this.quotePolicy.hashCode());
        result = 31 * result + (this.quoteChar == null ? 0 : this.quoteChar.hashCode());
        result = 31 * result + (this.commentStart == null ? 0 : this.commentStart.hashCode());
        result = 31 * result + (this.escape == null ? 0 : this.escape.hashCode());
        result = 31 * result + (this.ignoreSurroundingSpaces ? 1231 : 1237);
        result = 31 * result + (this.ignoreEmptyLines ? 1231 : 1237);
        result = 31 * result + (this.recordSeparator == null ? 0 : this.recordSeparator.hashCode());
        result = 31 * result + Arrays.hashCode(this.header);
        return result;
    }

    public boolean isCommentingEnabled() {
        return this.commentStart != null;
    }

    public boolean isEscaping() {
        return this.escape != null;
    }

    public boolean isQuoting() {
        return this.quoteChar != null;
    }

    public Iterable<CSVRecord> parse(Reader in) throws IOException {
        return new CSVParser(in, this);
    }

    public CSVFormatBuilder toBuilder() {
        return new CSVFormatBuilder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delimiter=<").append(this.delimiter).append('>');
        if (this.isEscaping()) {
            sb.append(' ');
            sb.append("Escape=<").append(this.escape).append('>');
        }
        if (this.isQuoting()) {
            sb.append(' ');
            sb.append("QuoteChar=<").append(this.quoteChar).append('>');
        }
        if (this.isCommentingEnabled()) {
            sb.append(' ');
            sb.append("CommentStart=<").append(this.commentStart).append('>');
        }
        if (this.getIgnoreEmptyLines()) {
            sb.append(" EmptyLines:ignored");
        }
        if (this.getIgnoreSurroundingSpaces()) {
            sb.append(" SurroundingSpaces:ignored");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CSVFormatBuilder {
        private char delimiter;
        private Character quoteChar;
        private Quote quotePolicy;
        private Character commentStart;
        private Character escape;
        private boolean ignoreSurroundingSpaces;
        private boolean ignoreEmptyLines;
        private String recordSeparator;
        private String nullToString;
        private String[] header;

        CSVFormatBuilder(char delimiter) {
            this(delimiter, null, null, null, null, false, false, null, "", null);
        }

        CSVFormatBuilder(char delimiter, Character quoteChar, Quote quotePolicy, Character commentStart, Character escape, boolean ignoreSurroundingSpaces, boolean ignoreEmptyLines, String recordSeparator, String nullToString, String[] header) {
            if (CSVFormat.isLineBreak(delimiter)) {
                throw new IllegalArgumentException("The delimiter cannot be a line break");
            }
            this.delimiter = delimiter;
            this.quoteChar = quoteChar;
            this.quotePolicy = quotePolicy;
            this.commentStart = commentStart;
            this.escape = escape;
            this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
            this.ignoreEmptyLines = ignoreEmptyLines;
            this.recordSeparator = recordSeparator;
            this.nullToString = nullToString;
            this.header = header;
        }

        CSVFormatBuilder(CSVFormat format) {
            this(format.delimiter, format.quoteChar, format.quotePolicy, format.commentStart, format.escape, format.ignoreSurroundingSpaces, format.ignoreEmptyLines, format.recordSeparator, format.nullToString, format.header);
        }

        public CSVFormat build() {
            this.validate();
            return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullToString, this.header);
        }

        public Iterable<CSVRecord> parse(Reader in) throws IOException {
            return this.build().parse(in);
        }

        private void validate() throws IllegalStateException {
            if (this.quoteChar != null && this.delimiter == this.quoteChar.charValue()) {
                throw new IllegalStateException("The quoteChar character and the delimiter cannot be the same ('" + this.quoteChar + "')");
            }
            if (this.escape != null && this.delimiter == this.escape.charValue()) {
                throw new IllegalStateException("The escape character and the delimiter cannot be the same ('" + this.escape + "')");
            }
            if (this.commentStart != null && this.delimiter == this.commentStart.charValue()) {
                throw new IllegalStateException("The comment start character and the delimiter cannot be the same ('" + this.commentStart + "')");
            }
            if (this.quoteChar != null && this.quoteChar.equals(this.commentStart)) {
                throw new IllegalStateException("The comment start character and the quoteChar cannot be the same ('" + this.commentStart + "')");
            }
            if (this.escape != null && this.escape.equals(this.commentStart)) {
                throw new IllegalStateException("The comment start and the escape character cannot be the same ('" + this.commentStart + "')");
            }
            if (this.escape == null && this.quotePolicy == Quote.NONE) {
                throw new IllegalStateException("No quotes mode set but no escape character is set");
            }
        }

        public CSVFormatBuilder withCommentStart(char commentStart) {
            return this.withCommentStart(Character.valueOf(commentStart));
        }

        public CSVFormatBuilder withCommentStart(Character commentStart) {
            if (CSVFormat.isLineBreak(commentStart)) {
                throw new IllegalArgumentException("The comment start character cannot be a line break");
            }
            this.commentStart = commentStart;
            return this;
        }

        public CSVFormatBuilder withDelimiter(char delimiter) {
            if (CSVFormat.isLineBreak(delimiter)) {
                throw new IllegalArgumentException("The delimiter cannot be a line break");
            }
            this.delimiter = delimiter;
            return this;
        }

        public CSVFormatBuilder withEscape(char escape) {
            return this.withEscape(Character.valueOf(escape));
        }

        public CSVFormatBuilder withEscape(Character escape) {
            if (CSVFormat.isLineBreak(escape)) {
                throw new IllegalArgumentException("The escape character cannot be a line break");
            }
            this.escape = escape;
            return this;
        }

        public CSVFormatBuilder withHeader(String ... header) {
            this.header = header;
            return this;
        }

        public CSVFormatBuilder withIgnoreEmptyLines(boolean ignoreEmptyLines) {
            this.ignoreEmptyLines = ignoreEmptyLines;
            return this;
        }

        public CSVFormatBuilder withIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
            this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
            return this;
        }

        public CSVFormatBuilder withNullToString(String nullToString) {
            this.nullToString = nullToString;
            return this;
        }

        public CSVFormatBuilder withQuoteChar(char quoteChar) {
            return this.withQuoteChar(Character.valueOf(quoteChar));
        }

        public CSVFormatBuilder withQuoteChar(Character quoteChar) {
            if (CSVFormat.isLineBreak(quoteChar)) {
                throw new IllegalArgumentException("The quoteChar cannot be a line break");
            }
            this.quoteChar = quoteChar;
            return this;
        }

        public CSVFormatBuilder withQuotePolicy(Quote quotePolicy) {
            this.quotePolicy = quotePolicy;
            return this;
        }

        public CSVFormatBuilder withRecordSeparator(char recordSeparator) {
            return this.withRecordSeparator(String.valueOf(recordSeparator));
        }

        public CSVFormatBuilder withRecordSeparator(String recordSeparator) {
            this.recordSeparator = recordSeparator;
            return this;
        }
    }
}

