/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVReadProc;
import au.com.bytecode.opencsv.CSVRuntimeException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
implements Closeable {
    private BufferedReader br;
    private boolean hasNext = true;
    private CSVParser parser;
    private int skipLines;
    private boolean linesSkiped;
    public static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"', '\\');
    }

    public CSVReader(Reader reader, char c) {
        this(reader, c, '\"', '\\');
    }

    public CSVReader(Reader reader, char c, char c2) {
        this(reader, c, c2, '\\', 0, false);
    }

    public CSVReader(Reader reader, char c, char c2, boolean bl) {
        this(reader, c, c2, '\\', 0, bl);
    }

    public CSVReader(Reader reader, char c, char c2, char c3) {
        this(reader, c, c2, c3, 0, false);
    }

    public CSVReader(Reader reader, char c, char c2, int n) {
        this(reader, c, c2, '\\', n, false);
    }

    public CSVReader(Reader reader, char c, char c2, char c3, int n) {
        this(reader, c, c2, c3, n, false);
    }

    public CSVReader(Reader reader, char c, char c2, char c3, int n, boolean bl) {
        this(reader, c, c2, c3, n, bl, true);
    }

    public CSVReader(Reader reader, char c, char c2, char c3, int n, boolean bl, boolean bl2) {
        this.br = new BufferedReader(reader);
        this.parser = new CSVParser(c, c2, c3, bl, bl2);
        this.skipLines = n;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] stringArray = this.readNext();
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public String[] readNext() throws IOException {
        String[] stringArray = null;
        do {
            String string = this.getNextLine();
            if (!this.hasNext) {
                return stringArray;
            }
            String[] stringArray2 = this.parser.parseLineMulti(string);
            if (stringArray2.length <= 0) continue;
            if (stringArray == null) {
                stringArray = stringArray2;
                continue;
            }
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            stringArray = stringArray3;
        } while (this.parser.isPending());
        return stringArray;
    }

    private String getNextLine() throws IOException {
        String string;
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((string = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? string : null;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public void read(CSVReadProc cSVReadProc) {
        try {
            int n = 0;
            String[] stringArray = this.readNext();
            while (stringArray != null) {
                cSVReadProc.procRow(n++, stringArray);
                stringArray = this.readNext();
            }
        }
        catch (IOException iOException) {
            throw new CSVRuntimeException(iOException);
        }
    }
}

