/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.streaming;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.streaming.ContextClassloaderLocal;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.WebServiceException;

public abstract class XMLStreamWriterFactory {
    private static final Logger LOGGER = Logger.getLogger(XMLStreamWriterFactory.class.getName());
    private static volatile ContextClassloaderLocal<XMLStreamWriterFactory> writerFactory = new ContextClassloaderLocal<XMLStreamWriterFactory>(){

        @Override
        protected XMLStreamWriterFactory initialValue() {
            XMLOutputFactory xof = null;
            if (Boolean.getBoolean(XMLStreamWriterFactory.class.getName() + ".woodstox")) {
                try {
                    xof = (XMLOutputFactory)Class.forName("com.ctc.wstx.stax.WstxOutputFactory").newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (xof == null) {
                xof = XMLOutputFactory.newInstance();
            }
            XMLStreamWriterFactory f = null;
            if (!Boolean.getBoolean(XMLStreamWriterFactory.class.getName() + ".noPool")) {
                f = Zephyr.newInstance(xof);
            }
            if (f == null && xof.getClass().getName().equals("com.ctc.wstx.stax.WstxOutputFactory")) {
                f = new NoLock(xof);
            }
            if (f == null) {
                f = new Default(xof);
            }
            LOGGER.fine("XMLStreamWriterFactory instance is = " + f);
            return f;
        }
    };

    public abstract XMLStreamWriter doCreate(OutputStream var1);

    public abstract XMLStreamWriter doCreate(OutputStream var1, String var2);

    public abstract void doRecycle(XMLStreamWriter var1);

    public static void recycle(XMLStreamWriter r) {
        XMLStreamWriterFactory.get().doRecycle(r);
    }

    @NotNull
    public static XMLStreamWriterFactory get() {
        return writerFactory.get();
    }

    public static void set(@NotNull XMLStreamWriterFactory f) {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        writerFactory.set(f);
    }

    public static XMLStreamWriter create(OutputStream out) {
        return XMLStreamWriterFactory.get().doCreate(out);
    }

    public static XMLStreamWriter create(OutputStream out, String encoding) {
        return XMLStreamWriterFactory.get().doCreate(out, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return XMLStreamWriterFactory.create(out);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        return XMLStreamWriterFactory.create(out, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding, boolean declare) {
        return XMLStreamWriterFactory.create(out, encoding);
    }

    public static final class Default
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;

        public Default(XMLOutputFactory xof) {
            this.xof = xof;
        }

        @Override
        public XMLStreamWriter doCreate(OutputStream out) {
            return this.doCreate(out, "UTF-8");
        }

        @Override
        public synchronized XMLStreamWriter doCreate(OutputStream out, String encoding) {
            try {
                return this.xof.createXMLStreamWriter(out, encoding);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        @Override
        public void doRecycle(XMLStreamWriter r) {
        }
    }

    public static final class NoLock
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;

        public NoLock(XMLOutputFactory xof) {
            this.xof = xof;
        }

        @Override
        public XMLStreamWriter doCreate(OutputStream out) {
            return this.doCreate(out, "UTF-8");
        }

        @Override
        public XMLStreamWriter doCreate(OutputStream out, String encoding) {
            try {
                return this.xof.createXMLStreamWriter(out, encoding);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        @Override
        public void doRecycle(XMLStreamWriter r) {
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }

    public static final class Zephyr
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;
        private final ThreadLocal<XMLStreamWriter> pool = new ThreadLocal();
        private final Method resetMethod;
        private final Method setOutputMethod;
        private final Class zephyrClass;

        public static XMLStreamWriterFactory newInstance(XMLOutputFactory xof) {
            try {
                Class<?> clazz = xof.createXMLStreamWriter(new StringWriter()).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.internal.stream.")) {
                    return null;
                }
                return new Zephyr(xof, clazz);
            }
            catch (XMLStreamException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private Zephyr(XMLOutputFactory xof, Class clazz) throws NoSuchMethodException {
            this.xof = xof;
            this.zephyrClass = clazz;
            this.setOutputMethod = clazz.getMethod("setOutput", StreamResult.class, String.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
        }

        @Nullable
        private XMLStreamWriter fetch() {
            XMLStreamWriter sr = this.pool.get();
            if (sr == null) {
                return null;
            }
            this.pool.set(null);
            return sr;
        }

        @Override
        public XMLStreamWriter doCreate(OutputStream out) {
            return this.doCreate(out, "UTF-8");
        }

        @Override
        public XMLStreamWriter doCreate(OutputStream out, String encoding) {
            XMLStreamWriter xsw = this.fetch();
            if (xsw != null) {
                try {
                    this.resetMethod.invoke(xsw, new Object[0]);
                    this.setOutputMethod.invoke(xsw, new StreamResult(out), encoding);
                    return xsw;
                }
                catch (IllegalAccessException e) {
                    throw new XMLReaderException("stax.cantCreate", new Object[]{e});
                }
                catch (InvocationTargetException e) {
                    throw new XMLReaderException("stax.cantCreate", new Object[]{e});
                }
            }
            try {
                return this.xof.createXMLStreamWriter(out, encoding);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        @Override
        public void doRecycle(XMLStreamWriter r) {
            if (this.zephyrClass.isInstance(r)) {
                try {
                    r.close();
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(e);
                }
                this.pool.set(r);
            }
            if (r instanceof RecycleAware) {
                ((RecycleAware)((Object)r)).onRecycled();
            }
        }
    }
}

