/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Bitset;
import jregex.UnicodeConstants;

class Block
implements UnicodeConstants {
    private boolean isFull;
    boolean[] bits;
    private boolean shared = false;
    private static final boolean[] EMPTY_BITS = new boolean[256];
    private static final boolean[] FULL_BITS = new boolean[256];

    Block() {
    }

    Block(boolean[] blArray) {
        this.bits = blArray;
        this.shared = true;
    }

    final boolean set(int n) {
        if (this.isFull) {
            return false;
        }
        boolean[] blArray = this.bits;
        if (blArray == null) {
            this.bits = blArray = new boolean[256];
            this.shared = false;
            blArray[n] = true;
            return true;
        }
        if (blArray[n]) {
            return false;
        }
        if (this.shared) {
            blArray = Block.copyBits(this);
        }
        blArray[n] = true;
        return true;
    }

    final boolean get(int n) {
        if (this.isFull) {
            return true;
        }
        boolean[] blArray = this.bits;
        if (blArray == null) {
            return false;
        }
        return blArray[n];
    }

    static final int add(Block[] blockArray, Block[] blockArray2, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            block3: {
                Block block;
                Block block2;
                block5: {
                    block4: {
                        block2 = blockArray2[n4];
                        if (block2 != null ? block2.isFull && bl : !bl) break block3;
                        block = blockArray[n4];
                        if (block != null) break block4;
                        blockArray[n4] = block = new Block();
                        break block5;
                    }
                    if (block.isFull) break block3;
                }
                n3 += Block.add(block, block2, bl);
            }
            ++n4;
        }
        return n3;
    }

    private static final int add(Block block, Block block2, boolean bl) {
        if (block2 == null) {
            if (!bl) {
                return 0;
            }
            int n = 256;
            boolean[] blArray = block.bits;
            if (block.bits != null) {
                n -= Block.count(blArray, 0, 255);
            }
            block.isFull = true;
            block.bits = null;
            block.shared = false;
            return n;
        }
        if (block2.isFull) {
            if (bl) {
                return 0;
            }
            int n = 256;
            boolean[] blArray = block.bits;
            if (block.bits != null) {
                n -= Block.count(blArray, 0, 255);
            }
            block.isFull = true;
            block.bits = null;
            block.shared = false;
            return n;
        }
        boolean[] blArray = block2.bits;
        if (block2.bits == null) {
            if (!bl) {
                return 0;
            }
            int n = 256;
            boolean[] blArray2 = block.bits;
            if (block.bits != null) {
                n -= Block.count(blArray2, 0, 255);
            }
            block.isFull = true;
            block.bits = null;
            block.shared = false;
            return n;
        }
        boolean[] blArray3 = block.bits;
        if (block.bits == null) {
            if (!bl) {
                block.bits = blArray;
                block.shared = true;
                return Block.count(blArray, 0, 255);
            }
            block.bits = blArray3 = Block.emptyBits(null);
            block.shared = false;
            return Bitset.add(blArray3, blArray, 0, 255, bl);
        }
        if (block.shared) {
            blArray3 = Block.copyBits(block);
        }
        return Bitset.add(blArray3, blArray, 0, 255, bl);
    }

    static final int subtract(Block[] blockArray, Block[] blockArray2, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            Block block = blockArray[n4];
            if (block != null && (block.isFull || block.bits != null)) {
                Block block2 = blockArray2[n4];
                if (block2 == null) {
                    if (bl) {
                        n3 = block.isFull ? (n3 -= 256) : (n3 -= Block.count(block.bits, 0, 255));
                        block.isFull = false;
                        block.bits = null;
                        block.shared = false;
                    }
                } else {
                    n3 += Block.subtract(block, block2, bl);
                }
            }
            ++n4;
        }
        return n3;
    }

    private static final int subtract(Block block, Block block2, boolean bl) {
        if (block2.isFull) {
            if (bl) {
                return 0;
            }
            int n = 0;
            n = block.isFull ? 256 : Block.count(block.bits, 0, 255);
            block.isFull = false;
            block.bits = null;
            block.shared = false;
            return n;
        }
        boolean[] blArray = block2.bits;
        if (block2.bits == null) {
            if (!bl) {
                return 0;
            }
            int n = 0;
            n = block.isFull ? 256 : Block.count(block.bits, 0, 255);
            block.isFull = false;
            block.bits = null;
            block.shared = false;
            return n;
        }
        if (block.isFull) {
            boolean[] blArray2 = Block.fullBits(block.bits);
            int n = Bitset.subtract(blArray2, blArray, 0, 255, bl);
            block.isFull = false;
            block.shared = false;
            block.bits = blArray2;
            return n;
        }
        boolean[] blArray3 = block.shared ? Block.copyBits(block) : block.bits;
        return Bitset.subtract(blArray3, blArray, 0, 255, bl);
    }

    private static boolean[] copyBits(Block block) {
        boolean[] blArray = new boolean[256];
        System.arraycopy(block.bits, 0, blArray, 0, 256);
        block.bits = blArray;
        block.shared = false;
        return blArray;
    }

    private static boolean[] fullBits(boolean[] blArray) {
        if (blArray == null) {
            blArray = new boolean[256];
        }
        System.arraycopy(FULL_BITS, 0, blArray, 0, 256);
        return blArray;
    }

    private static boolean[] emptyBits(boolean[] blArray) {
        if (blArray == null) {
            blArray = new boolean[256];
        } else {
            System.arraycopy(EMPTY_BITS, 0, blArray, 0, 256);
        }
        return blArray;
    }

    static final int count(boolean[] blArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (blArray[n4]) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    static final boolean[][] toBitset2(Block[] blockArray) {
        int n = blockArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            if (block != null) {
                blArrayArray[n2] = block.isFull ? FULL_BITS : block.bits;
            }
            ++n2;
        }
        return blArrayArray;
    }

    static {
        int n = 0;
        while (n < 256) {
            Block.FULL_BITS[n] = true;
            ++n;
        }
    }
}

