/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3.emulator;

import java.util.Date;
import java.util.Stack;
import net.noderunner.amazon.s3.ISO801DateFormat;

public class Writer {
    private Stack<String> tags = new Stack();
    private StringBuilder sb = new StringBuilder();

    public Writer start(String tag) {
        this.sb.append("<").append(tag).append(">");
        this.tags.push(tag);
        return this;
    }

    public Writer end() {
        String tag = this.tags.pop();
        this.sb.append("</").append(tag).append(">");
        return this;
    }

    public Writer write(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        this.sb.append(s);
        return this;
    }

    public Writer write(Writer w) {
        this.sb.append(w.toString());
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public Writer write(Date lastModified) {
        return this.write(new ISO801DateFormat().format(lastModified));
    }

    public Writer write(long size) {
        return this.write(String.valueOf(size));
    }
}

