/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers {
    public static final String METADATA_PREFIX = "x-amz-meta-";
    private Map<String, List<String>> headers;

    public Headers(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Headers(Headers headers) {
        this();
        for (Map.Entry<String, List<String>> me : headers.headers.entrySet()) {
            for (String v : me.getValue()) {
                this.put(me.getKey(), v);
            }
        }
    }

    public Headers() {
        this(new HashMap<String, List<String>>());
    }

    public Headers(Header[] requestHeaders) {
        this();
        for (Header h : requestHeaders) {
            this.put(h.getName(), h.getValue());
        }
    }

    public void put(String header, String value) {
        if (this.headers.containsKey(header)) {
            this.headers.get(header).add(value);
        } else {
            this.headers.put(header, new ArrayList<String>(Collections.singletonList(value)));
        }
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getValues(String header) {
        return this.headers.get(header);
    }

    public String getValue(String header) {
        List<String> values = this.getValues(header);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public int size() {
        return this.headers.size();
    }

    public Headers extractMetadata() {
        TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
        for (Map.Entry<String, List<String>> me : this.headers.entrySet()) {
            String key = me.getKey();
            if (key == null || !key.startsWith(METADATA_PREFIX)) continue;
            metadata.put(key.substring(METADATA_PREFIX.length()), me.getValue());
        }
        return new Headers(metadata);
    }

    public Headers mergeMetadata(Headers metadata) {
        if (metadata == null) {
            return this;
        }
        TreeMap<String, List<String>> merged = new TreeMap<String, List<String>>(this.headers);
        for (Map.Entry<String, List<String>> me : metadata.headers.entrySet()) {
            String key = me.getKey();
            String metadataKey = METADATA_PREFIX + key;
            if (merged.containsKey(metadataKey)) {
                ((List)merged.get(metadataKey)).addAll((Collection)me.getValue());
                continue;
            }
            merged.put(metadataKey, me.getValue());
        }
        return new Headers(merged);
    }

    public String toString() {
        return "headers=" + this.headers;
    }
}

