/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.util.Date;
import java.util.regex.Pattern;
import net.noderunner.amazon.s3.CallingFormat;

public class Bucket {
    private String name;
    private Date creationDate;
    static Pattern bucketPath = Pattern.compile("^[0-9A-Za-z\\.\\-_]*$");
    static Pattern ipv4Pattern = Pattern.compile("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$");
    static Pattern bucketNamePattern = Pattern.compile("^[a-z0-9]([a-z0-9\\-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-]*[a-z0-9])?)*$");

    Bucket() {
    }

    public Bucket(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean specified() {
        return this.name.length() != 0;
    }

    void setName(String name) {
        this.name = name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        return this.name;
    }

    public static boolean validateBucketName(String bucketName, CallingFormat callingFormat) {
        if (callingFormat == CallingFormat.PATH) {
            int MIN_BUCKET_LENGTH = 3;
            int MAX_BUCKET_LENGTH = 255;
            return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 255 && bucketPath.matcher(bucketName).matches();
        }
        int MIN_BUCKET_LENGTH = 3;
        int MAX_BUCKET_LENGTH = 63;
        return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 63 && !ipv4Pattern.matcher(bucketName).matches() && bucketNamePattern.matcher(bucketName).matches();
    }

    public boolean validateName(CallingFormat callingFormat) {
        return Bucket.validateBucketName(this.name, callingFormat);
    }
}

