/*
 * Decompiled with CFR 0.152.
 */
package org.order.pojo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.app.contactsmanager.Contacts;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonManagedReference;
import org.codehaus.jackson.type.TypeReference;
import org.common.db.AbsPojoEntity;
import org.common.enums.EFieldType;
import org.common.field.TmField;
import org.hibernate.Session;
import org.order.pojo.OrderProductRel;
import org.order.pojo.Product;
import org.order.pojo.ProductInOrder;

@Entity
@Table(name="cc_order")
public class Order
extends AbsPojoEntity {
    @TmField(text="\u8ba2\u5355ID")
    @Column(length=18)
    private String sid;
    @TmField(text="\u8ba2\u5355\u7f16\u53f7", uniqueIgnoreCase=true)
    @Column(length=40)
    private String num;
    @TmField(text="\u8ba2\u5355\u72b6\u6001", type=EFieldType.combo)
    @Column(length=50)
    private String status;
    @JsonIgnore
    @ManyToOne
    private Contacts contact;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="pid")
    @JoinColumn(name="productRelas")
    @JsonManagedReference(value="productRelas")
    private Set<OrderProductRel> productRelas = new LinkedHashSet<OrderProductRel>();
    @Transient
    @JsonIgnore
    private Set<OrderProductRel> existPRelas = new HashSet<OrderProductRel>();
    @Transient
    @JsonIgnore
    private Set<OrderProductRel> removedPRelas = new HashSet<OrderProductRel>();
    @TmField(text="\u4ea7\u54c1\u603b\u91d1\u989d", type=EFieldType.num182, exportFieldName="ProdSumMoney_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal prodSumMoney = new BigDecimal(0);
    @TmField(exportable=false, filterable=false)
    @Column
    private int prodTotalCount;
    @TmField(text="\u4ea7\u54c1\u6570\u91cf", type=EFieldType.num182)
    @Column(precision=18, scale=3)
    private BigDecimal prodAmountTotalCount = new BigDecimal(0);
    @TmField(exportable=false, filterable=false)
    @Transient
    private String prodParamJson;
    @TmField(text="\u4ed8\u6b3e\u65b9\u5f0f", type=EFieldType.combo)
    @Column(length=50)
    private String payType;
    @TmField(text="\u5df2\u652f\u4ed8\u603b\u989d", type=EFieldType.num182, exportFieldName="PaidupSumMoney_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal paidupSumMoney = new BigDecimal(0);
    @TmField(text="\u4ea4\u8d27\u671f\u9650", type=EFieldType.date, exportFieldName="deliveryTimeLimit_YMD")
    @JsonIgnore
    private Integer deliveryTimeLimit;
    @TmField(text="\u4ea4\u8d27\u72b6\u6001", type=EFieldType.combo)
    @Column(length=50)
    private String deliveryStatus;
    @TmField(text="\u53d1\u8fd0\u65b9\u5f0f", type=EFieldType.combo)
    @Column(length=50)
    private String transportType;
    @TmField(text="\u8fd0\u8d39", type=EFieldType.num182, exportFieldName="TransportFee_FMT")
    @Column(precision=18, scale=2)
    private BigDecimal transportFee = new BigDecimal(0);
    @TmField(text="\u6536\u8d27\u5730\u5740")
    @Column(length=500)
    private String receivingAddr;
    @TmField(text="\u5907\u6ce8")
    @Column(length=2048)
    private String memo;
    @TmField(text="\u521b\u5efa\u4eba", type=EFieldType.userlist, exportFieldName="Creater_FMT")
    @Column
    private Long creater;
    @TmField(text="\u521b\u5efa\u65f6\u95f4", type=EFieldType.datetime, exportFieldName="CreateTime_FMT")
    @Column(length=15)
    private Long createTime = ci.a();
    @TmField(text="\u4fee\u6539\u4eba", type=EFieldType.userlist, exportFieldName="Modifyer_FMT")
    @Column
    private Long modifyer;
    @TmField(text="\u4fee\u6539\u65f6\u95f4", type=EFieldType.datetime, exportFieldName="ModifyTime_FMT")
    @Column(length=15)
    private Long modifyTime = ci.a();

    public long getContactID() {
        if (this.contact != null) {
            return this.contact.getPid();
        }
        return 0L;
    }

    @TmField(text="\u5ba2\u6237\u59d3\u540d", filterable=false)
    public String getContactName() {
        if (this.contact != null) {
            return this.contact.get\u59d3\u540d();
        }
        return "";
    }

    @TmField(text="\u5ba2\u6237\u6027\u522b", filterable=false)
    public String getContactSex() {
        if (this.contact != null) {
            return this.contact.get\u6027\u522b();
        }
        return "";
    }

    public List<Map> getProducts() {
        ArrayList<Map> products = new ArrayList<Map>();
        if (this.productRelas != null && this.productRelas.size() > 0) {
            for (OrderProductRel rel : this.productRelas) {
                if (rel.getTheProduct() == null) continue;
                Product p2 = rel.getTheProduct();
                try {
                    long prodPid = p2.getPid();
                    Map mapP = bZ.a(p2);
                    Map mapRel = bZ.a(rel);
                    mapP.putAll(mapRel);
                    mapP.put("productId", prodPid);
                    products.add(mapP);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }
        }
        return products;
    }

    public String getProdSumMoney_FMT() {
        return cb.a(this.prodSumMoney);
    }

    public void setProdParamJson(Session sess, String s2) {
        this.prodParamJson = s2;
        if (StringUtils.isNotBlank(s2)) {
            try {
                HashSet<OrderProductRel> addedPRelas = new HashSet<OrderProductRel>();
                List<ProductInOrder> lstPio = cL.a(s2, new TypeReference<List<ProductInOrder>>(){});
                if (lstPio != null && lstPio.size() > 0) {
                    this.prodSumMoney = new BigDecimal(0);
                    this.prodAmountTotalCount = new BigDecimal(0);
                    this.prodTotalCount = 0;
                    for (ProductInOrder pio : lstPio) {
                        cz<Class<Product>> pDao;
                        Product p2;
                        boolean exist = false;
                        OrderProductRel oprEntity = null;
                        if (pio.getPid() != null) {
                            for (OrderProductRel opr : this.productRelas) {
                                if (opr.getPid().longValue() != pio.getPid().longValue()) continue;
                                exist = true;
                                oprEntity = opr;
                                OrderProductRel tmp = new OrderProductRel();
                                try {
                                    bZ.a((Object)oprEntity, tmp);
                                    this.existPRelas.add(tmp);
                                }
                                catch (Exception exception) {}
                                break;
                            }
                        }
                        if ((p2 = (Product)(pDao = new cz<Class<Product>>(Product.class)).b(sess, pio.getProductId())) != null) {
                            if (!exist) {
                                oprEntity = new OrderProductRel();
                                oprEntity.setTheOrder(this);
                            }
                            oprEntity.setTheProduct(p2);
                        }
                        if (oprEntity != null) {
                            try {
                                bZ.a((Object)pio, oprEntity);
                                this.prodSumMoney = this.prodSumMoney.add(oprEntity.getOrderPrice().multiply(oprEntity.getOrderAmount()));
                                this.prodAmountTotalCount = this.prodAmountTotalCount.add(oprEntity.getOrderAmount());
                            }
                            catch (IllegalAccessException | InvocationTargetException e2) {
                                e2.printStackTrace();
                            }
                        }
                        this.productRelas.add(oprEntity);
                        addedPRelas.add(oprEntity);
                    }
                    this.prodTotalCount += lstPio.size();
                }
                HashSet<OrderProductRel> delOPR = new HashSet<OrderProductRel>();
                for (OrderProductRel add : this.productRelas) {
                    if (addedPRelas.contains(add)) continue;
                    delOPR.add(add);
                }
                this.removedPRelas.addAll(delOPR);
                this.productRelas.removeAll(delOPR);
                this.existPRelas.removeAll(delOPR);
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public String getPaidupSumMoney_FMT() {
        return cb.a(this.paidupSumMoney);
    }

    public String getDeliveryTimeLimit_YMD() {
        if (this.deliveryTimeLimit != null) {
            return ck.c(this.deliveryTimeLimit.intValue());
        }
        return "";
    }

    public void setDeliveryTimeLimit_YMD(String fmt) {
        this.deliveryTimeLimit = StringUtils.isNotBlank(fmt) ? Integer.valueOf((int)cj.b(fmt)) : null;
    }

    public String getTransportFee_FMT() {
        return cb.a(this.transportFee);
    }

    public String getCreater_FMT() {
        return dt.a(this.creater);
    }

    public String getCreateTime_FMT() {
        if (this.createTime != null) {
            return ck.e(this.createTime);
        }
        return "";
    }

    public String getModifyer_FMT() {
        return dt.a(this.modifyer);
    }

    public String getModifyTime_FMT() {
        if (this.modifyTime != null) {
            return ck.e(this.modifyTime);
        }
        return "";
    }

    public String getSid() {
        return this.sid;
    }

    public String getNum() {
        return this.num;
    }

    public String getStatus() {
        return this.status;
    }

    public Contacts getContact() {
        return this.contact;
    }

    public Set<OrderProductRel> getProductRelas() {
        return this.productRelas;
    }

    public Set<OrderProductRel> getExistPRelas() {
        return this.existPRelas;
    }

    public Set<OrderProductRel> getRemovedPRelas() {
        return this.removedPRelas;
    }

    public BigDecimal getProdSumMoney() {
        return this.prodSumMoney;
    }

    public int getProdTotalCount() {
        return this.prodTotalCount;
    }

    public BigDecimal getProdAmountTotalCount() {
        return this.prodAmountTotalCount;
    }

    public String getProdParamJson() {
        return this.prodParamJson;
    }

    public String getPayType() {
        return this.payType;
    }

    public BigDecimal getPaidupSumMoney() {
        return this.paidupSumMoney;
    }

    public Integer getDeliveryTimeLimit() {
        return this.deliveryTimeLimit;
    }

    public String getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public BigDecimal getTransportFee() {
        return this.transportFee;
    }

    public String getReceivingAddr() {
        return this.receivingAddr;
    }

    public String getMemo() {
        return this.memo;
    }

    public Long getCreater() {
        return this.creater;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getModifyer() {
        return this.modifyer;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setContact(Contacts contact) {
        this.contact = contact;
    }

    public void setProductRelas(Set<OrderProductRel> productRelas) {
        this.productRelas = productRelas;
    }

    public void setExistPRelas(Set<OrderProductRel> existPRelas) {
        this.existPRelas = existPRelas;
    }

    public void setRemovedPRelas(Set<OrderProductRel> removedPRelas) {
        this.removedPRelas = removedPRelas;
    }

    public void setProdSumMoney(BigDecimal prodSumMoney) {
        this.prodSumMoney = prodSumMoney;
    }

    public void setProdTotalCount(int prodTotalCount) {
        this.prodTotalCount = prodTotalCount;
    }

    public void setProdAmountTotalCount(BigDecimal prodAmountTotalCount) {
        this.prodAmountTotalCount = prodAmountTotalCount;
    }

    public void setProdParamJson(String prodParamJson) {
        this.prodParamJson = prodParamJson;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public void setPaidupSumMoney(BigDecimal paidupSumMoney) {
        this.paidupSumMoney = paidupSumMoney;
    }

    public void setDeliveryTimeLimit(Integer deliveryTimeLimit) {
        this.deliveryTimeLimit = deliveryTimeLimit;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public void setTransportType(String transportType) {
        this.transportType = transportType;
    }

    public void setTransportFee(BigDecimal transportFee) {
        this.transportFee = transportFee;
    }

    public void setReceivingAddr(String receivingAddr) {
        this.receivingAddr = receivingAddr;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifyer(Long modifyer) {
        this.modifyer = modifyer;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }
}

