/*
 * Decompiled with CFR 0.152.
 */
package org.embedded.browser;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.embedded.browser.ChromeSettings;
import org.embedded.browser.CloseWindowListener;
import org.embedded.browser.LoadStatusListener;
import org.embedded.browser.NavStateListener;
import org.embedded.browser.NewWindowListener;
import org.embedded.browser.TitleChangeListener;

public class Chromium
extends Canvas {
    static volatile boolean inited = false;
    static int count = 0;
    static HashMap<Integer, Chromium> chmap = new HashMap();
    int id;
    int hwnd;
    int chptr;
    boolean tab = false;
    boolean webpage_loading = false;
    boolean can_go_back = false;
    boolean can_go_forward = false;
    volatile boolean loaded = false;
    ChromeSettings chromeset;
    Thread init;
    Composite parentbak;
    TitleChangeListener tcl = null;
    NewWindowListener nwl = null;
    CloseWindowListener cwl = null;
    LoadStatusListener lsl = null;
    NavStateListener nsl = null;

    static {
        System.loadLibrary("cef_runtime/libcef");
        System.loadLibrary("cef_runtime/chromium_loader_win");
    }

    public Chromium(Composite parent, int style) {
        this(parent, style, "about:blank");
    }

    public Chromium(Composite parent, int style, String url) {
        this(parent, style, url, new ChromeSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chromium(Composite parent, int style, final String url, ChromeSettings chromesettings) {
        super(parent, style);
        this.parentbak = parent;
        this.chromeset = chromesettings.Finalize();
        HashMap<Integer, Chromium> hashMap = chmap;
        synchronized (hashMap) {
            this.hwnd = this.handle;
            this.id = ++count;
            chmap.put(this.id, this);
            if (inited) {
                this.tab = true;
                this.browser_new(this.hwnd, this.id, url, this.chromeset);
            } else {
                this.init = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Chromium.this.browser_init(Chromium.this.hwnd, url, Chromium.this.chromeset);
                    }
                });
                this.init.start();
                while (!inited) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void widgetDisposed(DisposeEvent e2) {
                    HashMap<Integer, Chromium> hashMap = chmap;
                    synchronized (hashMap) {
                        chmap.remove(Chromium.this.id);
                        if (Chromium.this.tab) {
                            Chromium.this.browser_close(Chromium.this.chptr);
                        } else {
                            Chromium.this.browser_shutdown(Chromium.this.chptr);
                        }
                    }
                }
            });
            this.addControlListener(new ControlListener(){

                @Override
                public void controlMoved(ControlEvent arg0) {
                }

                @Override
                public void controlResized(ControlEvent arg0) {
                    Chromium.this.browser_resized(Chromium.this.chptr, Chromium.this.hwnd);
                }
            });
        }
    }

    public void setUrl(final String url) {
        if (!this.loaded) {
            Thread su = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!Chromium.this.loaded) {
                        try {
                            Thread.sleep(3L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Chromium.this.browser_setUrl(Chromium.this.chptr, url);
                }
            });
            su.start();
        } else {
            this.browser_setUrl(this.chptr, url);
        }
    }

    public void cleanCookies() {
        this.browser_clean_cookies();
    }

    public void back() {
        this.browser_back(this.chptr);
    }

    public void forward() {
        this.browser_forward(this.chptr);
    }

    public void reload() {
        this.browser_reload(this.chptr);
    }

    public boolean isLoading() {
        return this.webpage_loading;
    }

    public boolean canGoBack() {
        return this.can_go_back;
    }

    public boolean canGoForward() {
        return this.can_go_forward;
    }

    public static Collection<Chromium> getAllInstances() {
        return chmap.values();
    }

    void loadfinish(int bptr) {
        this.chptr = bptr;
        inited = true;
    }

    public void addTitleChangeListener(TitleChangeListener l2) {
        this.tcl = l2;
    }

    public void addNewWindowListener(NewWindowListener l2) {
        this.nwl = l2;
    }

    public void addCloseWindowListener(CloseWindowListener l2) {
        this.cwl = l2;
    }

    public void addLoadStatusListener(LoadStatusListener l2) {
        this.lsl = l2;
    }

    public void addNavStateListener(NavStateListener l2) {
        this.nsl = l2;
    }

    void title_change(final String title) {
        if (this.tcl != null) {
            final Chromium c2 = this;
            Display display = this.parentbak.getDisplay();
            if (display.isDisposed()) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Chromium.this.tcl.TitleChanged(title, c2);
                }
            });
        }
        this.browser_resized(this.chptr, this.hwnd);
    }

    void title_change(String title, int id) {
        Chromium.chmap.get((Object)Integer.valueOf((int)id)).loaded = true;
        if (title.equals("")) {
            return;
        }
        if (chmap.containsKey(id)) {
            chmap.get(id).title_change(title);
        }
    }

    void new_window(final String url) {
        if (this.nwl != null) {
            final Chromium c2 = this;
            this.parentbak.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Chromium.this.nwl.HandleNewWindow(c2, url);
                }
            });
        }
    }

    void new_window(int id, String url) {
        if (chmap.containsKey(id)) {
            chmap.get(id).new_window(url);
        }
    }

    void close_window() {
        if (this.cwl != null) {
            final Chromium c2 = this;
            this.parentbak.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Chromium.this.cwl.HandleCloseWindow(c2);
                }
            });
        }
    }

    void close_window(int id) {
        if (chmap.containsKey(id)) {
            chmap.get(id).close_window();
        }
    }

    void load_change(final boolean loading) {
        this.webpage_loading = loading;
        if (this.lsl != null) {
            final Chromium c2 = this;
            this.parentbak.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Chromium.this.lsl.LoadStatusChanged(loading, c2);
                }
            });
        }
    }

    void load_change(int id, boolean loading) {
        if (chmap.containsKey(id)) {
            chmap.get(id).load_change(loading);
        }
    }

    void navstate_change(boolean canback, boolean canforward) {
        this.can_go_back = canback;
        this.can_go_forward = canforward;
        if (this.nsl != null) {
            final Chromium c2 = this;
            this.parentbak.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Chromium.this.nsl.NavStateChanged(c2);
                }
            });
        }
    }

    void navstate_change(int id, boolean canback, boolean canforward) {
        if (chmap.containsKey(id)) {
            chmap.get(id).navstate_change(canback, canforward);
        }
    }

    native void browser_init(int var1, String var2, ChromeSettings var3);

    native void browser_new(int var1, int var2, String var3, ChromeSettings var4);

    native void browser_close(int var1);

    native void browser_shutdown(int var1);

    native void browser_clean_cookies();

    native void browser_setUrl(int var1, String var2);

    native void browser_resized(int var1, int var2);

    native void browser_back(int var1);

    native void browser_forward(int var1);

    native void browser_reload(int var1);
}

