/*
 * Decompiled with CFR 0.152.
 */
package org.common.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.jackson.annotate.JsonBackReference;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonManagedReference;
import org.common.combo.ComboNode;
import org.common.db.AbsPojoEntity;
import org.common.enums.EReturnOpers;
import org.common.enums.ETreeNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedSuperclass
public class TreeNode<T extends TreeNode>
extends AbsPojoEntity
implements Comparable<T>,
Comparator<T> {
    private static final Logger logger = LoggerFactory.getLogger(TreeNode.class);
    protected String text;
    @Transient
    protected Object value;
    protected int ordinal;
    protected int layer;
    protected ETreeNodeType type;
    @ManyToOne
    @JoinColumn(name="parentId")
    @JsonBackReference(value="treeNode_children")
    protected T parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonManagedReference(value="treeNode_children")
    @OrderBy(value="ordinal")
    protected Set<T> children = new TreeSet<T>();
    @Transient
    @JsonIgnore
    private Set<Long> allLevelsId = new HashSet<Long>();

    @Transient
    public Long getParentId() {
        if (this.parent != null) {
            return ((AbsPojoEntity)this.parent).getPid();
        }
        return null;
    }

    public void setChildren(Set<T> ch2) {
        if (this.children.size() > 0) {
            this.children.clear();
        }
        this.children.addAll(ch2);
    }

    public List<ComboNode> convertCombo(Long exceptId) {
        final ArrayList<ComboNode> combo = new ArrayList<ComboNode>();
        try {
            dc.a(this, new db<T>(){

                @Override
                public EReturnOpers a(T \u5f53\u524d\u9879, short \u5c42\u53f7) throws Exception {
                    ComboNode node = new ComboNode(((AbsPojoEntity)\u5f53\u524d\u9879).getPid(), ((TreeNode)\u5f53\u524d\u9879).getText(), "" + ((AbsPojoEntity)\u5f53\u524d\u9879).getPid(), ((TreeNode)\u5f53\u524d\u9879).getLayer());
                    combo.add(node);
                    return null;
                }
            }, exceptId);
        }
        catch (Exception ex) {
            logger.error("", ex);
        }
        return combo;
    }

    @JsonIgnore
    public Long[] getAllParentId(boolean withSelf) {
        LinkedHashSet<Long> idSets = new LinkedHashSet<Long>();
        TreeNode<T> currNode = this;
        if (withSelf) {
            idSets.add(currNode.getPid());
        }
        if (this.parent != null) {
            do {
                if ((currNode = currNode.parent) == null || currNode.getPid() == null) continue;
                idSets.add(currNode.getPid());
            } while (currNode != null && currNode.type != ETreeNodeType.ROOT);
        }
        return idSets.toArray(new Long[0]);
    }

    @JsonIgnore
    public Long[] getReverseAllParentId(boolean withSelf) {
        Object[] id = this.getAllParentId(withSelf);
        if (id != null && id.length > 0) {
            ArrayUtils.reverse(id);
        }
        return id;
    }

    @JsonIgnore
    public Long[] getDirectChildrenId() {
        HashSet<Long> idSets = new HashSet<Long>();
        if (this.children != null && this.children.size() > 0) {
            for (TreeNode node : this.children) {
                if (node.getParent() == null) continue;
                idSets.add(node.getPid());
            }
        }
        return idSets.toArray(new Long[0]);
    }

    @JsonIgnore
    public Long[] getSortedDirectChildrenId() {
        Object[] id = this.getDirectChildrenId();
        if (id != null && id.length > 0) {
            Arrays.sort(id);
        }
        return id;
    }

    @JsonIgnore
    public synchronized Long[] getAllLevelsChildrenId(boolean withSelf) {
        this.allLevelsId = new HashSet<Long>();
        if (withSelf) {
            this.allLevelsId.add(this.getPid());
        }
        if (this.children != null && this.children.size() > 0) {
            for (TreeNode node : this.children) {
                if (node.getParent() == null) continue;
                this.a(node);
            }
        }
        return this.allLevelsId.toArray(new Long[0]);
    }

    @JsonIgnore
    private void a(T node) {
        if (node != null && ((TreeNode)node).getParent() != null && ((AbsPojoEntity)node).getPid() != null) {
            this.allLevelsId.add(((AbsPojoEntity)node).getPid());
            if (((TreeNode)node).children != null && ((TreeNode)node).children.size() > 0) {
                for (T n2 : ((TreeNode)node).getChildren()) {
                    this.a((TreeNode)n2);
                }
            }
        }
    }

    @Override
    public int compare(T o1, T o2) {
        return this._compare(o1, o2);
    }

    @Override
    public int compareTo(T o2) {
        return this._compare(this, o2);
    }

    public int _compare(T o1, T o2) {
        return ((TreeNode)o1).getOrdinal() - ((TreeNode)o2).getOrdinal();
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.value;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getLayer() {
        return this.layer;
    }

    public ETreeNodeType getType() {
        return this.type;
    }

    public T getParent() {
        return this.parent;
    }

    public Set<T> getChildren() {
        return this.children;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setType(ETreeNodeType type) {
        this.type = type;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }
}

