/*
 * Decompiled with CFR 0.152.
 */
package org.common.tree;

import java.util.Comparator;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.codehaus.jackson.annotate.JsonProperty;
import org.common.enums.ETreeNodeType;
import org.common.tree.TreeNode;

@MappedSuperclass
public class ExtjsTreeNode<T extends ExtjsTreeNode>
extends TreeNode<T>
implements Comparable<T>,
Comparator<T> {
    @Transient
    private int count = -1;
    @Transient
    protected String icon;
    protected boolean expanded;

    @Transient
    @JsonProperty(value="_text")
    public String get_text() {
        return this.text;
    }

    @Override
    public String getText() {
        if (this.count < 0) {
            return this.text;
        }
        return String.valueOf(this.text) + " (" + this.count + ")";
    }

    public boolean getLeaf() {
        return this.type != null && this.type != ETreeNodeType.ROOT && (this.type == null && this.type == ETreeNodeType.LEAF || this.children == null || this.children.size() <= 0);
    }

    public int getCount() {
        return this.count;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }
}

