/*
 * Decompiled with CFR 0.152.
 */
package org.common.msg;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.util.Date;
import org.common.IProGuardIngore;
import org.common.enums.XiaoXiLeiXing;
import org.common.enums.XiaoXiMuBiao;
import org.common.enums.XiaoXiYuan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePackage
implements Serializable,
IProGuardIngore {
    private static final Logger logger = LoggerFactory.getLogger(MessagePackage.class);
    private long time = new Date().getTime();
    private XiaoXiYuan msgSource;
    private Long sourceUserPid;
    private XiaoXiMuBiao msgTarget;
    private Long targetUserPid;
    private XiaoXiLeiXing msgType;
    private String msgName;
    private Object msgData;

    private MessagePackage() {
    }

    public static MessagePackage getInstance(Long sourceUserPid, XiaoXiYuan msgSource, XiaoXiMuBiao msgTarget, Long targetUserPid, String msgName, Object msgBody) {
        MessagePackage msg = new MessagePackage();
        msg.setMsgSource(msgSource);
        msg.setSourceUserPid(sourceUserPid);
        msg.setMsgTarget(msgTarget);
        msg.setTargetUserPid(targetUserPid);
        msg.setMsgType(XiaoXiLeiXing.TXT);
        msg.setMsgName(msgName);
        msg.setMsgData(msgBody);
        return msg;
    }

    public String toString() {
        String sRet = "";
        try {
            sRet = cL.a((Object)this, false);
        }
        catch (Exception e2) {
            logger.error("", e2);
        }
        return sRet;
    }

    public CharBuffer toCharBuffer() {
        CharBuffer cb2 = null;
        try {
            cb2 = CharBuffer.wrap(URLEncoder.encode(this.toString(), "UTF-8").replace("+", "%20"));
        }
        catch (Exception e2) {
            logger.error("", e2);
        }
        return cb2;
    }

    public static MessagePackage unserializable(String msg) {
        MessagePackage mpt = null;
        try {
            mpt = cL.a(msg, MessagePackage.class);
        }
        catch (Exception ex) {
            logger.error("", ex);
        }
        return mpt;
    }

    public long getTime() {
        return this.time;
    }

    public XiaoXiYuan getMsgSource() {
        return this.msgSource;
    }

    public Long getSourceUserPid() {
        return this.sourceUserPid;
    }

    public XiaoXiMuBiao getMsgTarget() {
        return this.msgTarget;
    }

    public Long getTargetUserPid() {
        return this.targetUserPid;
    }

    public XiaoXiLeiXing getMsgType() {
        return this.msgType;
    }

    public String getMsgName() {
        return this.msgName;
    }

    public Object getMsgData() {
        return this.msgData;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setMsgSource(XiaoXiYuan msgSource) {
        this.msgSource = msgSource;
    }

    public void setSourceUserPid(Long sourceUserPid) {
        this.sourceUserPid = sourceUserPid;
    }

    public void setMsgTarget(XiaoXiMuBiao msgTarget) {
        this.msgTarget = msgTarget;
    }

    public void setTargetUserPid(Long targetUserPid) {
        this.targetUserPid = targetUserPid;
    }

    public void setMsgType(XiaoXiLeiXing msgType) {
        this.msgType = msgType;
    }

    public void setMsgName(String msgName) {
        this.msgName = msgName;
    }

    public void setMsgData(Object msgData) {
        this.msgData = msgData;
    }
}

