/*
 * Decompiled with CFR 0.152.
 */
package org.common.field;

import org.common.db.AbsPojoEntity;
import org.common.enums.EFieldType;
import org.common.enums.opers.ENumOperators;
import org.common.enums.opers.EOtherOperators;
import org.common.enums.opers.ETextOperators;

public class FieldDescribe
extends AbsPojoEntity {
    private String text;
    private String name;
    private int maxlength;
    private String dbAlias;
    private EFieldType type;
    private String assPid;
    private boolean userEditable = false;
    private boolean exportable = true;
    private String exportFieldName = "";
    private String exportHeader = "";
    private boolean filterable = true;
    private boolean unique = false;
    private boolean uniqueIgnoreCase = false;
    private Class operators = null;

    public boolean isDateField() {
        return this.type != null && (this.type == EFieldType.date || this.type == EFieldType.datetime || this.type == EFieldType.milliseconds || this.type == EFieldType.time6 || this.type == EFieldType.time4);
    }

    public String getTypeDesc() {
        String desc = "\u975e\u7f16\u8f91\u578b";
        if (this.type != null) {
            switch (this.type) {
                case text: {
                    desc = "\u6587\u672c\u578b";
                    break;
                }
                case email: {
                    desc = "\u7535\u90ae\u578b";
                    break;
                }
                case telephone: {
                    desc = "\u7535\u8bdd\u578b";
                    break;
                }
                case website: {
                    desc = "\u7f51\u5740\u578b";
                    break;
                }
                case integer: 
                case num182: 
                case num183: {
                    desc = "\u6570\u5b57\u578b";
                    break;
                }
                case date: 
                case time4: 
                case time6: 
                case datetime: 
                case milliseconds: {
                    desc = "\u65e5\u671f\u65f6\u95f4\u578b";
                    break;
                }
                case combo: {
                    desc = "\u4e0b\u62c9\u6846\u578b";
                    break;
                }
                case radio: {
                    desc = "\u5355\u9009\u578b";
                    break;
                }
                case checkbox: {
                    desc = "\u591a\u9009\u578b";
                    break;
                }
                case userlist: {
                    desc = "\u7528\u6237\u5217\u8868\u578b";
                    break;
                }
                case contactTreeCombo: {
                    desc = "\u6811\u5206\u7ec4\u578b";
                }
            }
        }
        return desc;
    }

    public boolean isNumericField() {
        return this.type == EFieldType.date || this.type == EFieldType.datetime || this.type == EFieldType.integer || this.type == EFieldType.milliseconds || this.type == EFieldType.num182 || this.type == EFieldType.num183 || this.type == EFieldType.time4 || this.type == EFieldType.time6 || this.type == EFieldType.userlist || this.type == EFieldType.contactTreeCombo;
    }

    public Class getOperators() {
        if (this.operators == null) {
            switch (this.type) {
                case text: 
                case email: 
                case telephone: 
                case website: 
                case checkbox: {
                    return ETextOperators.class;
                }
                case combo: 
                case radio: 
                case userlist: 
                case contactTreeCombo: {
                    return EOtherOperators.class;
                }
                case integer: 
                case num182: 
                case num183: 
                case date: 
                case time4: 
                case time6: 
                case datetime: 
                case milliseconds: {
                    return ENumOperators.class;
                }
            }
        }
        return this.operators;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public String getDbAlias() {
        return this.dbAlias;
    }

    public EFieldType getType() {
        return this.type;
    }

    public String getAssPid() {
        return this.assPid;
    }

    public boolean isUserEditable() {
        return this.userEditable;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public String getExportFieldName() {
        return this.exportFieldName;
    }

    public String getExportHeader() {
        return this.exportHeader;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isUniqueIgnoreCase() {
        return this.uniqueIgnoreCase;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxlength(int maxlength) {
        this.maxlength = maxlength;
    }

    public void setDbAlias(String dbAlias) {
        this.dbAlias = dbAlias;
    }

    public void setType(EFieldType type) {
        this.type = type;
    }

    public void setAssPid(String assPid) {
        this.assPid = assPid;
    }

    public void setUserEditable(boolean userEditable) {
        this.userEditable = userEditable;
    }

    public void setExportable(boolean exportable) {
        this.exportable = exportable;
    }

    public void setExportFieldName(String exportFieldName) {
        this.exportFieldName = exportFieldName;
    }

    public void setExportHeader(String exportHeader) {
        this.exportHeader = exportHeader;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setUniqueIgnoreCase(boolean uniqueIgnoreCase) {
        this.uniqueIgnoreCase = uniqueIgnoreCase;
    }

    public void setOperators(Class operators) {
        this.operators = operators;
    }
}

