/*
 * Decompiled with CFR 0.152.
 */
package org.common.combo;

import org.apache.commons.lang.StringUtils;
import org.common.db.AbsPojoEntity;

public class ComboNode
extends AbsPojoEntity
implements Comparable<ComboNode> {
    private String text;
    private String value;
    private int sortId;
    private boolean defaultItem = false;

    public ComboNode(long id, String text, String value) {
        this.setPid(id);
        this.text = text;
        this.value = value;
    }

    public ComboNode(long id, String text, String value, int layer) {
        this.setPid(id);
        this.value = value;
        this.text = String.valueOf(StringUtils.repeat("\u3000", layer)) + text;
    }

    @Override
    public int compareTo(ComboNode o2) {
        if (this.getSortId() > o2.getSortId()) {
            return 1;
        }
        if (this.getSortId() < o2.getSortId()) {
            return -1;
        }
        if (this.getPid() > o2.getPid()) {
            return 1;
        }
        if (this.getPid() < o2.getPid()) {
            return -1;
        }
        return 0;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public int getSortId() {
        return this.sortId;
    }

    public boolean isDefaultItem() {
        return this.defaultItem;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSortId(int sortId) {
        this.sortId = sortId;
    }

    public void setDefaultItem(boolean defaultItem) {
        this.defaultItem = defaultItem;
    }
}

