/*
 * Decompiled with CFR 0.152.
 */
package org.app.contactsmanager.tree;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.app.common.enums.EUserRightType;
import org.app.contactsmanager.tree.ContactTreeNode;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.common.db.AbsPojoEntity;
import org.group.user.User;

@Entity
@Table(name="cc_ctreeright")
public class ContactTreeNodeRight
extends AbsPojoEntity {
    @JsonIgnore
    @ManyToOne
    private ContactTreeNode node;
    @JsonIgnore
    @ManyToOne
    private User user;
    @Column(name="noderight")
    private EUserRightType right;
    @Transient
    private String rightInheritMsg = "";
    @Transient
    private boolean inherit = true;

    @Transient
    public Long getNodeId() {
        return this.node != null ? this.node.getPid() : null;
    }

    @Transient
    public String getNodeText() {
        return this.node != null ? this.node.getText() : "";
    }

    @Transient
    public Long getUserId() {
        return this.user != null ? this.user.getPid() : null;
    }

    @Transient
    public String getUserName() {
        return this.user != null ? this.user.getUserName() : "";
    }

    public ContactTreeNode getNode() {
        return this.node;
    }

    public User getUser() {
        return this.user;
    }

    public EUserRightType getRight() {
        return this.right;
    }

    public String getRightInheritMsg() {
        return this.rightInheritMsg;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public void setNode(ContactTreeNode node) {
        this.node = node;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRight(EUserRightType right) {
        this.right = right;
    }

    public void setRightInheritMsg(String rightInheritMsg) {
        this.rightInheritMsg = rightInheritMsg;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }
}

