/*
 * Decompiled with CFR 0.152.
 */
package com.ifp.wechat.service;

import com.ifp.wechat.entity.user.UserWeiXin;
import com.ifp.wechat.util.DateFormart;
import com.ifp.wechat.util.StringUtil;
import com.ifp.wechat.util.WeixinUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService {
    private static final Logger a = LoggerFactory.getLogger(UserService.class);
    public static String GET_USER_INFO = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
    public static String GET_USER_OPENID_LIST = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&next_openid=NEXT_OPENID";

    public static UserWeiXin getUserInfo(String openid) {
        String url;
        JSONObject jsonObject;
        String token = WeixinUtil.getToken();
        UserWeiXin user = null;
        if (token != null && (jsonObject = WeixinUtil.httpsRequest(url = GET_USER_INFO.replace("ACCESS_TOKEN", token).replace("OPENID", openid), "POST", null)) != null) {
            if (StringUtil.isNotEmpty(jsonObject.get("errcode")) && jsonObject.get("errcode") != "0") {
                a.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25 errcode:" + jsonObject.getInt("errcode") + "\uff0cerrmsg:" + jsonObject.getString("errmsg"));
            } else {
                user = new UserWeiXin();
                user.setSubscribe(jsonObject.getInt("subscribe"));
                user.setOpenid(jsonObject.getString("openid"));
                user.setNickname(jsonObject.getString("nickname"));
                user.setSex(jsonObject.getInt("sex"));
                user.setCity(jsonObject.getString("city"));
                user.setCountry(jsonObject.getString("country"));
                user.setProvince(jsonObject.getString("province"));
                user.setLanguage(jsonObject.getString("language"));
                user.setHeadimgurl(jsonObject.getString("headimgurl"));
                long subscibeTime = jsonObject.getLong("subscribe_time");
                Date st = DateFormart.paserYYYY_MM_DD_HHMMSSToDate(subscibeTime);
                user.setSubscribe_time(st);
            }
        }
        return user;
    }

    public static List<String> getUserOpenIdList() {
        String url;
        JSONObject jsonObject;
        String token = WeixinUtil.getToken();
        ArrayList<String> list = null;
        if (token != null && (jsonObject = WeixinUtil.httpsRequest(url = GET_USER_OPENID_LIST.replace("ACCESS_TOKEN", token).replace("NEXT_OPENID", ""), "POST", null)) != null) {
            if (StringUtil.isNotEmpty(jsonObject.get("errcode")) && jsonObject.get("errcode") != "0") {
                a.error("\u83b7\u53d6\u5173\u6ce8\u7528\u6237\u5217\u8868\u5931\u8d25 errcode:" + jsonObject.getInt("errcode") + "\uff0cerrmsg:" + jsonObject.getString("errmsg"));
            } else {
                list = new ArrayList<String>();
                JSONObject data = jsonObject.getJSONObject("data");
                String openidStr = data.getString("openid");
                openidStr = openidStr.substring(1, openidStr.length() - 1);
                openidStr = openidStr.replace("\"", "");
                String[] openidArr = openidStr.split(",");
                int i2 = 0;
                while (i2 < openidArr.length) {
                    list.add(openidArr[i2]);
                    ++i2;
                }
            }
        }
        return list;
    }

    public static List<UserWeiXin> getUserList() {
        ArrayList<UserWeiXin> list = new ArrayList<UserWeiXin>();
        List<String> listStr = UserService.getUserOpenIdList();
        if (listStr == null || listStr.size() == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < listStr.size()) {
            UserWeiXin user = UserService.getUserInfo(listStr.get(i2));
            if (user != null) {
                list.add(user);
            }
            ++i2;
        }
        return list;
    }
}

