/*
 * Decompiled with CFR 0.152.
 */
package com.ifp.wechat.service;

import com.ifp.wechat.constant.ConstantWeChat;
import com.ifp.wechat.entity.AccessTokenOAuth;
import com.ifp.wechat.entity.user.UserWeiXin;
import com.ifp.wechat.util.StringUtil;
import com.ifp.wechat.util.WeixinUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthService {
    private static final Logger a = LoggerFactory.getLogger(OAuthService.class);
    public static String OAUTH = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";
    public static String GET_USER_INFO_OAUTH = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
    public static String GET_ACCESS_TOKEN_OAUTH = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";

    public static String getOauthUrl(String redirectUrl, String charset, String scope) {
        String url = "";
        try {
            url = OAUTH.replace("APPID", ConstantWeChat.APPID).replace("REDIRECT_URI", URLEncoder.encode(redirectUrl, charset)).replace("SCOPE", scope);
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return url;
    }

    public static AccessTokenOAuth getOAuthAccessToken(String code) {
        String url = GET_ACCESS_TOKEN_OAUTH.replace("APPID", ConstantWeChat.APPID).replace("SECRET", ConstantWeChat.APPSECRET).replace("CODE", code);
        JSONObject jsonObject = WeixinUtil.httpsRequest(url, "POST", null);
        AccessTokenOAuth accessTokenOAuth = null;
        if (jsonObject != null) {
            if (StringUtil.isNotEmpty(jsonObject.get("errcode")) && jsonObject.get("errcode") != "0") {
                a.error("\u83b7\u53d6access_token\u5931\u8d25 errcode:" + jsonObject.getInt("errcode") + "\uff0cerrmsg:" + jsonObject.getString("errmsg"));
            } else {
                accessTokenOAuth = new AccessTokenOAuth();
                accessTokenOAuth.setAccessToken(jsonObject.getString("access_token"));
                accessTokenOAuth.setExpiresIn(jsonObject.getInt("expires_in"));
                accessTokenOAuth.setRefreshToken(jsonObject.getString("refresh_token"));
                accessTokenOAuth.setOpenid(jsonObject.getString("openid"));
                accessTokenOAuth.setScope(jsonObject.getString("scope"));
            }
        }
        return accessTokenOAuth;
    }

    public static UserWeiXin getUserInfoOauth(String token, String openid) {
        String url;
        JSONObject jsonObject;
        UserWeiXin user = null;
        if (token != null && (jsonObject = WeixinUtil.httpsRequest(url = GET_USER_INFO_OAUTH.replace("ACCESS_TOKEN", token).replace("OPENID", openid), "POST", null)) != null) {
            if (StringUtil.isNotEmpty(jsonObject.get("errcode")) && jsonObject.get("errcode") != "0") {
                a.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25 errcode:" + jsonObject.getInt("errcode") + "\uff0cerrmsg:" + jsonObject.getString("errmsg"));
            } else {
                user = new UserWeiXin();
                user.setOpenid(jsonObject.getString("openid"));
                user.setNickname(jsonObject.getString("nickname"));
                user.setSex(jsonObject.getInt("sex"));
                user.setCity(jsonObject.getString("city"));
                user.setCountry(jsonObject.getString("country"));
                user.setProvince(jsonObject.getString("province"));
                user.setLanguage(jsonObject.getString("language"));
                user.setPrivilege(jsonObject.getString("privilege"));
            }
        }
        return user;
    }
}

