/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.security;

import com.greenpineyu.fel.Fel;
import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.security.SecurityMgr;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RegexSecurityMgr
implements SecurityMgr {
    private Map<String, Pattern> callableMap = new HashMap<String, Pattern>();
    private Map<String, Pattern> uncallableMap = new HashMap<String, Pattern>();

    public RegexSecurityMgr(Set<String> set, Set<String> set2) {
        this.convert(set, this.callableMap);
        this.convert(set2, this.uncallableMap);
    }

    private void convert(Set<String> set, Map<String, Pattern> map) {
        if (set == null) {
            return;
        }
        for (String string : set) {
            Pattern pattern = Pattern.compile(this.toRegex(string));
            map.put(string, pattern);
        }
    }

    private String toRegex(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder("^");
        block4: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '.': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block4;
                }
                case '*': {
                    stringBuilder.append(".*");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append("$");
        return stringBuilder.toString();
    }

    private String getSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = method.getDeclaringClass();
        stringBuilder.append(clazz.getCanonicalName()).append(".");
        stringBuilder.append(method.getName()).append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            String string = clazz2.getCanonicalName();
            if (string.startsWith("java.lang")) {
                string = string.substring(string.lastIndexOf(".") + 1);
            }
            stringBuilder.append(string);
            if (i >= classArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean isMatch(Map<String, Pattern> map, String string) {
        for (Map.Entry<String, Pattern> entry : map.entrySet()) {
            if (!entry.getValue().matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCallable(Method method) {
        String string = this.getSignature(method);
        if (this.isMatch(this.uncallableMap, string)) {
            return false;
        }
        if (this.callableMap.isEmpty()) {
            return true;
        }
        return this.isMatch(this.callableMap, string);
    }

    public static void main(String[] stringArray) {
        Fel.eval("$(System).exit(1)", new Var[0]);
    }
}

