/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.optimizer;

import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.SourceGeneratorImpl;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.context.MapContext;
import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.interpreter.Interpreter;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.AbstFelNode;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.VarAstNode;
import java.util.List;
import java.util.Map;

public class VarVisitOpti
implements Optimizer {
    private Map<String, Var> varMap;

    public VarVisitOpti(Var ... varArray) {
        this.varMap = new MapContext();
        if (varArray != null) {
            for (Var var : varArray) {
                if (var == null) continue;
                this.varMap.put(var.getName(), var);
            }
        }
    }

    public VarVisitOpti() {
    }

    @Override
    public FelNode call(FelContext felContext, FelNode felNode) {
        List<FelNode> list = AbstFelNode.getNodes(felNode, SourceGeneratorImpl.varsFilter);
        for (FelNode felNode2 : list) {
            VarAstNode varAstNode;
            if (!(felNode2 instanceof VarAstNode) || !(varAstNode = (VarAstNode)felNode2).isDefaultInterpreter()) continue;
            varAstNode.setInterpreter(this.createInterpreter());
            varAstNode.setSourcebuilder(this.createVarSourceBuilder(varAstNode));
        }
        return felNode;
    }

    private Interpreter createInterpreter() {
        return new Interpreter(){

            @Override
            public Object interpret(FelContext felContext, FelNode felNode) {
                Var var = VarVisitOpti.this.getVar(felContext, felNode);
                return var != null ? var.getValue() : null;
            }
        };
    }

    private SourceBuilder createVarSourceBuilder(VarAstNode varAstNode) {
        return new SourceBuilder(){
            private String src = null;
            private Class<?> returnType = null;

            @Override
            public String source(FelContext felContext, FelNode felNode) {
                if (this.src == null) {
                    Var var = VarVisitOpti.this.getVar(felContext, felNode);
                    String string = VarBuffer.push(var);
                    Class<?> clazz = this.returnType(felContext, felNode);
                    this.src = VarAstNode.getVarFullCode(clazz, string + ".getValue()");
                }
                return this.src;
            }

            @Override
            public Class<?> returnType(FelContext felContext, FelNode felNode) {
                if (this.returnType == null) {
                    this.returnType = InterpreterSourceBuilder.getInstance().returnType(felContext, felNode);
                }
                return this.returnType;
            }
        };
    }

    private Var getVar(FelContext felContext, FelNode felNode) {
        Var var = null;
        if (this.varMap != null) {
            var = this.varMap.get(felNode.getText());
        }
        if (var == null) {
            var = felContext.getVar(felNode.getText());
        }
        return var;
    }
}

