/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator.big;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.common.FelBuilder;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ObjectUtils;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class BigAdd
extends StableFunction {
    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        List<FelNode> list = felNode.getChildren();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object object = TolerantFunction.eval(felContext, list.get(0));
        if (list.size() == 1) {
            return object;
        }
        Object object2 = TolerantFunction.eval(felContext, list.get(1));
        if (object instanceof String || object2 instanceof String) {
            return ObjectUtils.toString(object).concat(ObjectUtils.toString(object2));
        }
        try {
            if (BigAdd.hasFloat(object, object2)) {
                BigDecimal bigDecimal = NumberUtil.toBigDecimal(object);
                BigDecimal bigDecimal2 = NumberUtil.toBigDecimal(object2);
                return bigDecimal.add(bigDecimal2);
            }
            if (BigAdd.isInt(object, object2)) {
                BigInteger bigInteger = NumberUtil.toBigInteger(object);
                BigInteger bigInteger2 = NumberUtil.toBigInteger(object2);
                return bigInteger.add(bigInteger2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ObjectUtils.toString(object).concat(ObjectUtils.toString(object2));
    }

    public static boolean isInt(Object object, Object object2) {
        return BigAdd.isInt(object) && BigAdd.isInt(object2);
    }

    public static boolean hasFloat(Object object, Object object2) {
        return BigAdd.isFloat(object) || BigAdd.isFloat(object2);
    }

    @Override
    public String getName() {
        return "+";
    }

    public static boolean isFloat(Object object) {
        return NumberUtil.isFloatingPoint(object) || object instanceof BigDecimal;
    }

    public static boolean isInt(Object object) {
        return NumberUtil.isNumberable(object) || object instanceof BigInteger;
    }

    @Override
    public SourceBuilder toMethod(FelNode felNode, FelContext felContext) {
        return InterpreterSourceBuilder.getInstance();
    }

    public static void main(String[] stringArray) {
        BigInteger bigInteger = new BigInteger("1000000000000000000");
        BigAdd.calc(bigInteger);
    }

    private static void calc(BigInteger bigInteger) {
        String string = "(-9484950.4f)+(-188132624.1)-(-10645.84)*(-196528.43)/(-109190992.2)+(-12353902.38)+(-502721396.8)";
        String string2 = "(-822091040.15)==(0)+(0)+(-9484950.4f)+(-188132624.1)+(-10645.84)+(-196528.43)+(-109190992.2)+(-12353902.38)+(0)+(0)+(-502721396.8)";
        string = "(0)+(0)+(-9484950.4f)+(-188132624.1)+(-10645.84)+(-196528.43)+(-109190992.2)+(-12353902.38)+(0)+(0)+(-502721396.8)";
        FelEngine felEngine = FelBuilder.bigNumberEngine();
        Object object = felEngine.eval("1.666+2323.7777");
        System.out.println("1.666+2323.7777:" + object);
        felEngine.getContext().set("a", new BigDecimal("1234567891000000123123123123.123456"));
        System.out.println("right:" + felEngine.eval(string));
        System.out.println("compile:" + felEngine.compile("a*a", felEngine.getContext(), new Optimizer[0]).eval(felEngine.getContext()));
        System.out.println("equals:" + felEngine.eval(string2));
        System.out.print("java:");
        System.out.println(-8.2209103975E8);
    }
}

