/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ObjectUtils;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.FelNode;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionGet
extends StableFunction {
    String[][] a = new String[][]{{"a", "b"}, {"c", "d"}};
    int[][] num = new int[][]{{1, 2}, {3, 4}};

    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        if (felNode.getChildCount() >= 2) {
            Object object = TolerantFunction.eval(felContext, felNode.getChild(0));
            Object object2 = TolerantFunction.eval(felContext, felNode.getChild(1));
            int n = 0;
            if (object2 instanceof Number) {
                n = ((Number)object2).intValue();
            }
            return CollectionGet.get(object, n);
        }
        return null;
    }

    @Override
    public String getName() {
        return "[";
    }

    @Override
    public SourceBuilder toMethod(FelNode felNode, FelContext felContext) {
        Class<Object> clazz = null;
        List<FelNode> list = felNode.getChildren();
        FelNode felNode2 = list.get(0);
        SourceBuilder sourceBuilder = felNode2.toMethod(felContext);
        Class<?> clazz2 = sourceBuilder.returnType(felContext, felNode2);
        if (!clazz2.isArray() && !List.class.isAssignableFrom(clazz2)) {
            return InterpreterSourceBuilder.getInstance();
        }
        FelNode felNode3 = list.get(1);
        SourceBuilder sourceBuilder2 = felNode3.toMethod(felContext);
        Class<?> clazz3 = sourceBuilder2.returnType(felContext, felNode3);
        String string = sourceBuilder.source(felContext, felNode2);
        String string2 = this.getRightSrc(felContext, felNode3, sourceBuilder2, clazz3);
        String string3 = "";
        if (clazz2.isArray()) {
            clazz = clazz2.getComponentType();
            string3 = "(" + string + ")[" + string2 + "]";
        } else if (List.class.isAssignableFrom(clazz2)) {
            clazz = Object.class;
            string3 = "(" + string + ").get(" + string2 + ")";
        }
        return new FelMethod(clazz, string3);
    }

    private String getRightSrc(FelContext felContext, FelNode felNode, SourceBuilder sourceBuilder, Class<?> clazz) {
        String string = "";
        Class[] classArray = new Class[]{Integer.class, Short.class, Character.class, Byte.class, Integer.TYPE, Short.TYPE, Character.TYPE, Byte.TYPE};
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            bl = true;
            break;
        }
        if (bl) {
            string = sourceBuilder.source(felContext, felNode);
        } else if (Number.class.isAssignableFrom(clazz)) {
            string = "(" + sourceBuilder.source(felContext, felNode) + ").intValue()";
        }
        return string;
    }

    public static Object get(Object object, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + n);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionGet.get(iterator, n);
        }
        if (object instanceof List) {
            return ((List)object).get(n);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (--n == -1) {
                    return iterator.next();
                }
                iterator.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + n);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionGet.get(iterator, n);
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                if (--n == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + n);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public int[][] getNum() {
        return this.num;
    }

    public void setNum(int[][] nArray) {
        this.num = nArray;
    }

    public String[][] getA() {
        return this.a;
    }

    public void setA(String[][] stringArray) {
        this.a = stringArray;
    }

    public static void main(String[] stringArray) throws SecurityException, NoSuchMethodException {
        CollectionGet.test();
    }

    public static void test() {
        FelEngineImpl felEngineImpl = new FelEngineImpl();
        FelContext felContext = felEngineImpl.getContext();
        int[] nArray = new int[]{1, 2, 3};
        nArray.getClass().getName();
        felContext.set("pInt", nArray);
        Integer[] integerArray = new Integer[]{1, 2, 3};
        felContext.set("wInt", integerArray);
        int[][] nArrayArray = new int[][]{{1, 2}, {3, 4}};
        felContext.set("twoDimension", nArrayArray);
        CollectionGet[][] collectionGetArray = new CollectionGet[1][1];
        felContext.set("twoDimensionx", collectionGetArray);
        CollectionGet.assertEval("pInt", felEngineImpl, nArray);
        CollectionGet.assertCompile("pInt", felEngineImpl, nArray);
        CollectionGet.assertEval("twoDimensionx", felEngineImpl, collectionGetArray);
        CollectionGet.assertCompile("twoDimensionx", felEngineImpl, collectionGetArray);
        CollectionGet.assertEval("pInt[1]", felEngineImpl, 2);
        CollectionGet.assertCompile("pInt[1]", felEngineImpl, 2);
    }

    public static void assertEval(String string, FelEngine felEngine, Object object) {
        Object object2 = felEngine.eval(string);
        if (object2 instanceof Number && object instanceof Number ? !$assertionsDisabled && NumberUtil.toDouble(object2) != NumberUtil.toDouble(object) : !$assertionsDisabled && !ObjectUtils.equals(object, object2)) {
            throw new AssertionError();
        }
    }

    public static void assertCompile(String string, FelEngine felEngine, Object object) {
        Expression expression = felEngine.compile(string, null, new Optimizer[0]);
        Object object2 = expression.eval(felEngine.getContext());
        if (object2 instanceof Number && object instanceof Number ? !$assertionsDisabled && NumberUtil.toDouble(object2) != NumberUtil.toDouble(object) : !$assertionsDisabled && !ObjectUtils.equals(object, object2)) {
            throw new AssertionError();
        }
    }
}

