/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.Null;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.util.List;

public class And
extends StableFunction {
    public String toJavaOper() {
        return this.getName();
    }

    @Override
    public Object call(FelNode felNode, FelContext felContext) {
        List<FelNode> list = felNode.getChildren();
        if (list != null && list.size() == 2) {
            return this.logic(felContext, list);
        }
        throw new EvalException("\u4f20\u5165\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!");
    }

    Boolean logic(FelContext felContext, List<FelNode> list) {
        Boolean bl = this.toBoolean(felContext, list.get(0));
        if (!bl.booleanValue()) {
            return bl;
        }
        return this.toBoolean(felContext, list.get(1));
    }

    Boolean toBoolean(FelContext felContext, Object object) {
        object = TolerantFunction.eval(felContext, object);
        return NumberUtil.toBooleanObj(object);
    }

    @Override
    public String getName() {
        return "&&";
    }

    @Override
    public FelMethod toMethod(FelNode felNode, FelContext felContext) {
        String string = this.toBoolean(felNode, felContext, 0) + this.toJavaOper() + this.toBoolean(felNode, felContext, 1);
        return new FelMethod(Boolean.class, string);
    }

    public String toBoolean(FelNode felNode, FelContext felContext, int n) {
        List<FelNode> list = felNode.getChildren();
        FelNode felNode2 = list.get(n);
        SourceBuilder sourceBuilder = felNode2.toMethod(felContext);
        Class<?> clazz = sourceBuilder.returnType(felContext, felNode2);
        if (Boolean.class.isAssignableFrom(clazz)) {
            return "(" + sourceBuilder.source(felContext, felNode2) + ")";
        }
        if (String.class.isAssignableFrom(clazz)) {
            return "Boolean.valueOf(" + sourceBuilder.source(felContext, felNode2) + ")";
        }
        if (Null.class.isAssignableFrom(clazz)) {
            return "false";
        }
        return "false";
    }
}

