/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.common;

import com.greenpineyu.fel.common.ArrayUtils;
import com.greenpineyu.fel.common.Null;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ReflectUtil {
    static final Map<Class<?>, Class<?>> wrapperCls;
    static final Map<Class<?>, Class<?>> primitiveCls;
    static final Map<Class<?>, Class<?>> numberClassMap;

    private static Map<Class<?>, Class<?>> primitiveNumberCls() {
        HashMap hashMap = new HashMap();
        hashMap.put(Byte.TYPE, Byte.TYPE);
        hashMap.put(Byte.class, Byte.TYPE);
        hashMap.put(Short.TYPE, Short.TYPE);
        hashMap.put(Short.class, Short.TYPE);
        hashMap.put(Integer.TYPE, Integer.TYPE);
        hashMap.put(Integer.class, Integer.TYPE);
        hashMap.put(Long.TYPE, Long.TYPE);
        hashMap.put(Long.class, Long.TYPE);
        hashMap.put(Float.TYPE, Float.TYPE);
        hashMap.put(Float.class, Float.TYPE);
        hashMap.put(Double.TYPE, Double.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Character.TYPE, Character.TYPE);
        hashMap.put(Character.class, Character.TYPE);
        return hashMap;
    }

    private static Map<Class<?>, Class<?>> wrapperNumberCls() {
        HashMap hashMap = new HashMap();
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Byte.class, Byte.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Short.class, Short.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Integer.class, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Long.class, Long.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Float.class, Float.class);
        hashMap.put(Double.TYPE, Double.class);
        hashMap.put(Double.class, Double.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Character.class, Character.class);
        return hashMap;
    }

    public static boolean isFloatingPointNumber(Object object) {
        return object instanceof Float || object instanceof Double;
    }

    public static boolean isFloatType(Class<?> clazz) {
        return clazz == Float.TYPE || clazz == Float.class;
    }

    public static boolean isDoubleType(Class<?> clazz) {
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isPrimitiveOrWrapNumber(Class<?> clazz) {
        return numberClassMap.containsKey(clazz);
    }

    public static boolean isPrimitiveNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isPrimitive() && clazz != Boolean.TYPE;
    }

    public static Class<?> toWrapperClass(Class<?> clazz) {
        return wrapperCls.get(clazz);
    }

    public static Class<?> toPrimitiveClass(Class<?> clazz) {
        return primitiveCls.get(clazz);
    }

    public static void sort(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            int n = nArray[i];
            for (int j = i - 1; j > -1 && n < nArray[j]; --j) {
                nArray[j + 1] = nArray[j];
            }
            nArray[j + 1] = n;
        }
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        String string2;
        String[] stringArray;
        if (string == null || "".equals(string)) {
            return null;
        }
        String string3 = String.valueOf(string.charAt(0)).toUpperCase() + string.substring(1);
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        String[] stringArray2 = stringArray = new String[]{string, "get" + string3, "is" + string3};
        int n = stringArray2.length;
        for (int i = 0; i < n && (method = ReflectUtil.match(string2 = stringArray2[i], classArray, methodArray)) == null; ++i) {
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        Method[] methodArray = clazz.getMethods();
        return ReflectUtil.match(string, classArray, methodArray);
    }

    private static Method match(String string, Class<?>[] classArray, Method[] methodArray) {
        Method method = null;
        Method method2 = null;
        block0: for (Method method3 : methodArray) {
            String string2 = method3.getName();
            if (!string2.equals(string)) continue;
            Object[] objectArray = method3.getParameterTypes();
            if (objectArray != null && classArray != null) {
                if (objectArray.length != classArray.length) continue;
                if (method2 == null) {
                    method2 = method3;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    Class<?> clazz = classArray[i];
                    if (!ReflectUtil.isTypeMatch(object, clazz)) continue block0;
                }
                method = method3;
                break;
            }
            if (!ArrayUtils.isEmpty(objectArray) || !ArrayUtils.isEmpty(classArray)) continue;
            method = method3;
            break;
        }
        return method == null ? method2 : method;
    }

    public static boolean isTypeMatch(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2 || clazz2 == Null.class) {
            return true;
        }
        Class<?> clazz3 = ReflectUtil.toWrapperClass(clazz);
        Class<?> clazz4 = ReflectUtil.toWrapperClass(clazz2);
        if (clazz3 != null && clazz3 == clazz4) {
            return true;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        return clazz.getCanonicalName();
    }

    static {
        numberClassMap = ReflectUtil.wrapperNumberCls();
        primitiveCls = new HashMap(ReflectUtil.primitiveNumberCls());
        primitiveCls.put(Boolean.TYPE, Boolean.TYPE);
        primitiveCls.put(Boolean.class, Boolean.TYPE);
        wrapperCls = new HashMap(ReflectUtil.wrapperNumberCls());
        wrapperCls.put(Boolean.TYPE, Boolean.class);
        wrapperCls.put(Boolean.class, Boolean.class);
    }
}

