/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.CacheException;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;

@Deprecated
public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    @Start
    void init() {
        if (this.txManager == null || this.txManager.getClass().equals(BatchModeTransactionManager.class)) {
            this.log.fatal((Object)"No transaction manager lookup class has been defined. Transactions cannot be used and thus OPTIMISTIC locking cannot be used!  Expect errors!!");
        }
    }

    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        GlobalTransaction gtx = this.getGlobalTransaction(ctx);
        boolean succeeded = false;
        try {
            TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Locking nodes in transaction workspace for GlobalTransaction " + gtx));
            }
            for (WorkspaceNode workspaceNode : workspace.getNodes().values()) {
                boolean isWriteLockNeeded;
                NodeSPI node = workspaceNode.getNode();
                boolean acquired = this.lockManager.lockAndRecord(node, (isWriteLockNeeded = workspaceNode.isDirty() || workspaceNode.isChildrenModified() && (this.configuration.isLockParentForChildInsertRemove() || node.isLockForChildInsertRemove())) ? LockType.WRITE : LockType.READ, ctx);
                if (acquired) {
                    if (!this.trace) continue;
                    this.log.trace((Object)("Acquired lock on node " + node.getFqn()));
                    continue;
                }
                throw new CacheException("Unable to acquire lock on node " + node.getFqn());
            }
            Object retval = this.invokeNextInterceptor(ctx, command);
            succeeded = true;
            Object object = retval;
            return object;
        }
        catch (Throwable e) {
            succeeded = false;
            this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
            throw e;
        }
        finally {
            if (!succeeded) {
                this.unlock(ctx);
            }
        }
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        return this.transactionFinalized(ctx, command);
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.transactionFinalized(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transactionFinalized(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Object retval = null;
        try {
            retval = this.invokeNextInterceptor(ctx, command);
        }
        finally {
            this.unlock(ctx);
        }
        return retval;
    }

    private void unlock(InvocationContext ctx) {
        try {
            TransactionContext transactionContext = ctx.getTransactionContext();
            if (transactionContext != null) {
                this.lockManager.unlock(ctx);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to unlock nodes after a commit or rollback!  Locks are possibly in a very inconsistent state now!", (Throwable)e);
        }
    }
}

