/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.msn;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.ContactsImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import rath.msnm.BuddyList;
import rath.msnm.MSNMessenger;
import rath.msnm.NotificationProcessor;
import rath.msnm.entity.MsnFriend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSNImporter
implements ContactsImporter {
    private String username;
    private String password;
    private MSNMessenger msn;

    public MSNImporter(String username, String password) {
        this.username = username;
        this.password = password;
        this.msn = new MSNMessenger();
    }

    @Override
    public List<Contact> getContacts() throws ContactsException {
        try {
            this.login();
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            BuddyList list = this.msn.getBuddyGroup().getAllowList();
            for (MsnFriend friend : list) {
                contacts.add(new Contact(new String(friend.getFriendlyName().getBytes(), "UTF-8"), friend.getLoginName()));
            }
            this.logout();
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("msn protocol has changed", e);
        }
    }

    private void login() {
        this.msn.setInitialStatus("FLN");
        this.msn.login(this.username, this.password);
    }

    private void logout() {
        this.fixedLogout(this.msn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixedLogout(MSNMessenger messenger) {
        if (messenger != null) {
            Thread leakedThread = null;
            try {
                leakedThread = this.getLeakedThread(messenger);
                messenger.logout();
            }
            catch (Exception exception) {
            }
            finally {
                if (leakedThread != null && !leakedThread.isInterrupted()) {
                    leakedThread.interrupt();
                }
            }
        }
    }

    private Thread getLeakedThread(MSNMessenger messenger) {
        try {
            Field nsField = MSNMessenger.class.getDeclaredField("ns");
            nsField.setAccessible(true);
            NotificationProcessor ns = (NotificationProcessor)nsField.get(messenger);
            if (ns == null) {
                return null;
            }
            Field callbackField = NotificationProcessor.class.getDeclaredField("callbackCleaner");
            callbackField.setAccessible(true);
            return (Thread)callbackField.get(ns);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unexpected", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("unexpected", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unexpected", e);
        }
    }
}

