/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YeahImporter
extends EmailImporter {
    private String loginUrl = "http://reg.163.com/login.jsp?type=1&product=mailyeah&url=http://entry.mail.yeah.net/cgi/ntesdoor?lightweight%3D1%26verifycookie%3D1%26style%3D3";
    private String contactsUrl = "http://g1a8.mail.yeah.net/jy3/address/addrlist.jsp?sid=%sid";
    private String indexPage = null;
    private Pattern SidPattern = Pattern.compile("sid=([^\"]*)\"");

    public YeahImporter(String email, String password) {
        super(email, password, "GBK");
    }

    @Override
    public void doLogin() throws ContactsException {
        try {
            Cookie[] cookies;
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("username", this.email), new NameValuePair("user", this.getUsername(this.email)), new NameValuePair("password", this.password), new NameValuePair("url2", "http%3A%2F%2Femail.163.com%2Ferrorpage%2Ferr_yeah.htm"), new NameValuePair("style", "3")};
            String responseStr = this.doPost(this.loginUrl, params, "http://email.163.com/");
            String redirectUrl1 = this.getJSRedirectLocation(responseStr);
            redirectUrl1 = redirectUrl1.replaceAll("\\|", "%7C");
            responseStr = this.doGet(redirectUrl1, this.loginUrl);
            this.removeCookies(new String[]{"URSJESSIONID"});
            Calendar calendar = Calendar.getInstance();
            calendar.set(2099, 11, 31);
            for (Cookie cookie : cookies = this.client.getState().getCookies()) {
                if (!cookie.getName().equals("NTES_SESS")) continue;
                this.client.getState().addCookie(new Cookie(".yeah.net", "NTES_SESS", cookie.getValue(), cookie.getPath(), cookie.getExpiryDate(), cookie.getSecure()));
            }
            this.client.getState().addCookies(new Cookie[]{new Cookie(".yeah.net", "logType", "9", "/", calendar.getTime(), false), new Cookie(".yeah.net", "ntes_mail_noremember", "true", "/", calendar.getTime(), false)});
            String redirectUrl2 = this.getJSRedirectLocation(responseStr);
            this.indexPage = this.doGet(redirectUrl2, redirectUrl1);
        }
        catch (Exception e) {
            throw new ContactsException("yeah protocal has changed", e);
        }
    }

    @Override
    public List<Contact> parseContacts() throws ContactsException {
        try {
            String sid = this.getSid(this.indexPage, "folder");
            String content = this.doGet(this.contactsUrl.replaceFirst("%sid", sid) + "&gid=all");
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            DOMParser parser = new DOMParser();
            InputSource is = new InputSource(new ByteArrayInputStream(content.getBytes("GBK")));
            is.setEncoding("GBK");
            parser.parse(is);
            NodeList nodes = parser.getDocument().getElementsByTagName("td");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!node.getFirstChild().getNodeName().equalsIgnoreCase("input")) continue;
                String username = "";
                if (nodes.item(++i).getFirstChild().getFirstChild() != null) {
                    username = nodes.item(i).getFirstChild().getFirstChild().getNodeValue();
                }
                String email = nodes.item(++i).getFirstChild().getFirstChild().getNodeValue();
                if (username == null) continue;
                contacts.add(new Contact(username, email));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("yeah protocol has changed", e);
        }
    }

    private String getSid(String content, String frameName) {
        int indexEnd;
        int indexMid = content.indexOf("name=\"" + frameName + "\"");
        int indexBegin = content.substring(0, indexMid).lastIndexOf("<");
        Matcher matcher = this.SidPattern.matcher(content.substring(indexBegin, indexEnd = content.indexOf("<", indexMid)));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

